<?php
return array(
    0 =>
    array(
        'id' => 1,
        'title' => 'What is QR Codes?',
        'slug' => 'what-is-qr-codes',
        'content' => 'You\'ve probably noticed a square barcode pasted to a graffitied light pole or on the back of a business card. 
  
  That pixelated code, shaped in a square, is called a QR code. They help you download apps, give you contactless access to a restaurant\'s menu, can be found on marketing billboards, and on websites or social media to promote items and deals. 
  
  Despite being a mid-90s invention, the QR code didn\'t gain real momentum until the era of smartphones. Mobile devices allowed the digital mark to be used in more dynamic and diverse ways, making it an easy — and in the era of a pandemic, contactless — way to connect to and share information. 
  
  Here\'s what you need to know about QR codes.
  
  ## What is a QR code?
  
  Invented in 1994 by Masahiro Hara, chief engineer of Denso Wave, a Japanese company and subsidiary of Toyota, the QR code was initially used to track vehicles and parts as they moved through the manufacturing process. 
  
  Short for Quick Response, QR codes are a type of barcode easily readable with digital devices like smartphones. They store information as a series of pixels in a square grid that can be read in two directions — top to bottom and right to left — unlike standard barcodes that can only be read top to bottom. 
  
  QR codes can store about 7,000 digits or around 4,000 characters, including punctuation and special characters. It can also encode information like phone numbers or internet addresses. The arrangement of each QR code varies depending on the information it contains, and that changes the arrangement of its black modules.',
        'excerpt' => 'You\'ve probably noticed a square barcode pasted to a graffitied light pole or on the back of a business card. 
  
  That pixelated code, shaped in...',
        'user_id' => 1,
        'published_at' => '2022-05-23',
        'created_at' => '2022-05-24T06:32:54.000000Z',
        'updated_at' => '2022-05-24T06:32:54.000000Z',
    ),
    1 =>
    array(
        'id' => 2,
        'title' => 'Business card with a QR Code: What does it mean?',
        'slug' => 'business-card-with-a-qr-code-what-does-it-mean',
        'content' => 'A business card—either digital or physical—with a QR Code simply refers to a contact information card that has a QR embedded on it. Upon scanning, the QR Code redirects users to details of a person, including name, phone number, address, email, website, social media handle, or a customized landing/campaign page.
  
  There are 2 ways to use a QR Code on business cards:
  
  1. Create a QR Code for your contact information and embed it on a business card, or
  Directly share the QR Code via emails, social media, OOH ads, flyers, etc.
  1. A business card with a QR Code is easily the most convenient way to share your personal or company’s contact information. All users have to do is scan the QR Code, view contact details, and save them on their smartphones within a few minutes.
  
  ### Why QR Codes on business cards are needed?
  
  For convenient and easy information sharing
  Traditionally, professionals shared their physical business cards with clients to follow up and stay connected. This meant the receiver would have to manually type and save contact details on their mobile devices, which can be time-consuming and inconvenient.
  
  But with a QR Code on a business card, the receiver can simply scan the code, view the information, and save these details with a few clicks. This allows for easy, convenient, and instant information sharing.',
        'excerpt' => 'A business card—either digital or physical—with a QR Code simply refers to a contact information card that has a QR embedded on it. Upon scanning,...',
        'user_id' => 1,
        'published_at' => '2022-05-16',
        'created_at' => '2022-05-24T06:36:52.000000Z',
        'updated_at' => '2022-05-24T06:36:52.000000Z',
    ),
    2 =>
    array(
        'id' => 3,
        'title' => 'What can you do with a QR code?',
        'slug' => 'what-can-you-do-with-a-qr-code',
        'content' => 'Nowadays, QR codes are still used to track products and product information through a supply chain, but they are also used for so much more. You\'ve likely used a QR code to view a menu, link a social profile or add friends to an account, board a flight,  download an app, send and receive payments, access Wi-Fi, and authenticate your login details. The possibilities with QR codes are truly endless. 
  
  Denso Wave has also made some significant improvements to the code\'s design. Now QR codes can come with brand protection, anti-forgery measures, and traceability, all features meant to improve the QR code experience as they become increasingly more common across industries. 
  
  ## What makes up a QR code?
  Visually, a QR code looks like a twisted crossword puzzle, but its design is crucial to its function. Here are some of its most important elements. 
  
  - **Position detection markers**: The prominent squares located in three corners of each code offer easier recognition and assist with reading the QR code at high speed. 
  - **Alignment markers**: These help straighten out codes placed on curved surfaces. It\'s smaller than a position detection marker but will become larger the more information a QR code holds. 
  - **Timing pattern**: The black and white alternating modules configure the data grid and help the scanner calculate how large the data matrix is.
  - **Version information**: This determines which of the 40 different QR code versions is being used, with the most common versions being 1 to 7.
  - **Format information**: This pattern holds information about the data mask pattern and error tolerance of the code, making it easier to scan.
  - **Data and error correction keys**: The error correction function shares a structural space where all the data in a QR code is contained. This correction block\'s mechanism is essential to allowing up to 30% of a code being read if damaged. 
  - **Quiet Zone**: This white space can be seen as the border of a QR code to help improve comprehension for scanning and provide structure. It determines what is and isn\'t part of the code.',
        'excerpt' => 'Nowadays, QR codes are still used to track products and product information through a supply chain, but they are also used for so much more....',
        'user_id' => 1,
        'published_at' => '2022-05-23',
        'created_at' => '2022-05-24T06:38:27.000000Z',
        'updated_at' => '2022-05-24T06:38:27.000000Z',
    ),
    3 =>
    array(
        'id' => 4,
        'title' => 'How to scan a QR Code from a picture in the gallery',
        'slug' => 'test',
        'content' => 'As QR Codes have cemented their position in marketing and communication, marketers like you and I, want to place them on almost everything – even websites. 
  
  However, one of the limitations of placing it on websites and campaign landing pages is – “how will users scan the QR Codes on the same mobile device they are browsing on?” 
  
  That’s not a limitation anymore!
  
  This scenario is not just restricted to QR Codes on websites – you might have a QR Code at a restaurant, subway, or airport and want users to click a picture and use it later. 
  
  This is a great way to push for re-orders, availing a coupon for the following order, or just delivering updated information. 
  
  Getting users to leverage QR Codes on a mobile device is a simple 2-step process: 
  
  Prompt users to take a screenshot of the mobile landing page
  Scan the QR Code from the picture in the smartphone gallery (or Google Photos)
  Both iOS and Android now have an easy way to scan QR Codes from the photo in the gallery. You do not need external apps to do that!
  
  Scan QR Code from a photo on iOS devices
  Apple has made several advancements in the last couple of years to incorporate the growing need for QR Codes – live text and visual look-up that scans QR Codes in photos, in one significant one. 
  
  Here’s how to do it – 
  
  - Open the picture/screenshot on your phone gallery.
  - Click on the live text detection on the right bottom corner
  - Click on the QR Code and follow the prompt against it
  
  Scan QR Code from a photo on Android devices
  With Google’s image-recognition technology, scanning QR Codes from a photo is super simple. This capability is baked into Google Assistant, Google Photos, or the Google app. 
  
  Here’s how to do it – 
  
  - Open your camera and switch to the Google Assistant mode
  - Select the picture from the gallery
  - The QR Code is automatically scanned. Follow the prompt.',
        'excerpt' => 'As QR Codes have cemented their position in marketing and communication, marketers like you and I, want to place them on almost everything – even...',
        'user_id' => 1,
        'published_at' => '2022-05-23',
        'created_at' => '2022-05-24T07:47:25.000000Z',
        'updated_at' => '2022-05-24T07:56:38.000000Z',
    ),
    4 =>
    array(
        'id' => 5,
        'title' => '5 Ways QR Codes Can Drive Traffic to Your Blog',
        'slug' => 'test-1',
        'content' => 'Did you know that out of 1.9 billion websites, over 600 million of them have a blog?
  
  A lot of these blogs incorporate keywords, use the best images, build backlinks, etc., and yet struggle to drive the desired amount of traffic.
  
  If you are looking to try something unique to increase your blog traffic, you have come to the right place.
  
  In this article, we will be discussing how you can generate more blog traffic using QR Codes.
  
  But before we begin, let’s quickly go through what QR Codes are.
  
  1. Assign a QR Code to every blog post & category
  77% of internet users read blogs regularly. If they like any of them, they don’t hesitate to share it in their circles.
  
  When they do so, it encourages other like-minded people to click on the link and read the blog post. This way, you can increase your blog traffic. But, copying the URL and pasting it is tedious for most users.
  
  So, you should provide them with easy sharing options. One of them is assigning a URL QR Code to every blog post and category.
  
  When users want to share a blog post, they can use this QR Code and share it. People can simply scan the QR Code to read your post.
  
  Incredibly easy and modern!',
        'excerpt' => 'In this article, we will be discussing how you can generate more blog traffic using QR Codes.',
        'user_id' => 1,
        'published_at' => '2022-05-23',
        'created_at' => '2022-05-24T07:47:45.000000Z',
        'updated_at' => '2022-05-24T08:01:41.000000Z',
    ),
    5 =>
    array(
        'id' => 6,
        'title' => 'Top 10 Ways to Effectively Grow Your Email List',
        'slug' => 'top-10-ways-to-effectively-grow-your-email-list',
        'content' => 'Keeping your company’s email list fresh is more important than you might realize. Without proactive measures on your part, an email list will become stale over time. After all, people change their email addresses, abandon accounts, and unsubscribe from email communications regularly.
  
  By chipping away at growing your email list, you can maximize its potential. Not sure where to begin?
  
  There are all kinds of practical and effective ways to start growing your email list today. Here are the top 10 ways:
  
  ## QR Codes
  You’ll agree when we say QR Codes are everywhere. And, rightly so. These days, more marketers are finding success using QR Codes to grow email lists.
  
  Specifically, this is done by adding unique QR Codes to a wide range of marketing materials, such as:
  
  digital business cards,
  print ads,
  flyers,
  signs and banners,
  billboards, and
  receipts.
  These QR Codes encourage people to scan them with their smartphones. From there, users are prompted to enter their email addresses or any other information marketers wish to collect.
  
  QR Code marketing is especially effective when brands offer consumers something in return for their email address. This can include a special coupon code or discount.',
        'excerpt' => 'Keeping your company’s email list fresh is more important than you might realize. Without proactive measures on your part, an email list will become stale...',
        'user_id' => 1,
        'published_at' => '2022-05-23',
        'created_at' => '2022-05-24T08:02:54.000000Z',
        'updated_at' => '2022-05-24T08:02:54.000000Z',
    ),
);
