<?php

namespace App\Support\QRCodeProcessors\ShapeProcessors;


class TeddyShapeProcessor extends BaseShapeProcessor
{
    public static $shapeId = 'teddy';

    public function symbolPath()
    {
        return 'm 701.13086,33.025391 c -11.09045,0.207407 -22.27851,2.505154 -32.16581,7.644598 -4.63643,2.541205 -8.92483,5.666548 -13.1304,8.857465 -5.89179,4.587981 -11.74071,9.274913 -17.01314,14.576576 -1.62223,1.766633 -3.46601,3.428205 -4.53498,5.610823 -0.74661,1.470618 -0.46951,3.331113 0.68288,4.513361 1.4399,1.667266 3.18571,3.037234 4.79546,4.534138 9.49424,8.33115 19.85483,15.617991 29.22958,24.091158 13.78152,12.13126 26.89628,24.97542 39.42487,38.41541 3.96488,4.29088 7.85727,8.63309 11.55612,13.10339 5.36481,6.43851 10.07634,13.37939 15.03753,20.12426 2.83597,3.74527 5.33045,7.8419 8.95415,10.90366 1.7296,1.46224 4.06275,2.77303 6.38678,2.03693 3.30171,-0.96761 6.2189,-2.87102 9.14467,-4.62505 5.92836,-3.75601 11.52306,-8.02617 16.86862,-12.56797 3.11728,-2.6638 5.95018,-5.66163 8.31465,-9.01684 5.69455,-7.86732 9.93968,-16.91981 11.44377,-26.56343 1.27581,-7.45118 1.27748,-15.05096 0.97704,-22.58266 -0.23688,-5.42257 -1.29595,-10.83142 -3.44085,-15.831888 C 789.36714,85.320071 783.18935,75.106467 775.25961,66.428474 760.81142,50.466186 741.21882,39.211635 720.12799,34.855876 713.88207,33.5874 707.50531,32.952608 701.13086,33.025391 Z m -436.01367,0.484375 c -29.5646,0.540269 -58.48454,15.547741 -75.94648,39.410231 -5.53498,7.463857 -9.64886,15.873959 -13.14006,24.453841 -1.54864,3.994682 -2.36125,8.270602 -2.30708,12.558252 -0.0934,5.53072 0.28715,11.05594 0.59671,16.57489 0.67931,9.77083 2.44295,19.69938 7.13152,28.40747 4.79985,8.91336 12.26477,16.03384 20.17515,22.19493 5.08511,3.92896 10.28284,7.96341 16.39044,10.16605 1.627,0.60786 3.56087,0.46164 4.92865,-0.67144 2.41456,-1.76068 4.395,-4.03348 6.44911,-6.18601 9.79613,-10.69492 18.00713,-22.6995 27.4824,-33.6651 16.86695,-19.9571 35.73317,-38.30716 56.75854,-53.896269 7.30953,-5.490199 14.76052,-10.894289 21.15102,-17.469892 1.24334,-1.3256 1.99562,-3.295257 1.26878,-5.061791 -0.88844,-2.846887 -3.01529,-5.058066 -4.91113,-7.274991 -4.75753,-5.215874 -10.28731,-9.65867 -15.93117,-13.871741 -6.66832,-4.88125 -13.99498,-8.942923 -21.89089,-11.453434 -9.07411,-2.993628 -18.65721,-4.373723 -28.20551,-4.214996 z m 222.15429,37.982422 c -16.5225,0.141559 -33.08556,0.58085 -49.4909,2.687105 -7.66613,1.092804 -15.12915,3.229629 -22.57313,5.305948 -34.86686,10.043246 -67.94932,26.664999 -96.2111,49.493509 -24.81847,20.00627 -45.84691,44.73381 -61.39786,72.573 -6.04035,10.84479 -11.40776,22.08694 -15.70982,33.73731 -3.87395,10.70625 -6.11452,21.93658 -7.42165,33.22726 -1.35794,11.29717 -2.28544,22.65091 -2.66985,34.02382 -0.61465,20.37639 0.97468,40.91826 6.00501,60.71431 5.00427,19.87605 13.35994,38.80131 23.76095,56.42444 4.61507,7.77921 9.45352,15.44465 14.86912,22.69514 9.17971,12.07576 19.7044,23.0649 30.69651,33.49279 9.40752,8.88343 19.4095,17.15707 30.10415,24.45106 3.55379,2.45517 7.08182,4.97031 10.84205,7.10224 1.62894,0.80667 3.49794,1.86406 5.35493,1.17064 1.75971,-0.55633 2.73057,-2.53733 2.34405,-4.29703 -0.5829,-2.74787 -2.13558,-5.15013 -3.44017,-7.59884 -3.25938,-5.61752 -6.73308,-11.12297 -9.54019,-16.98955 -2.30091,-4.72219 -4.38769,-9.49234 -6.15081,-14.41726 -2.88129,-8.4227 -4.17304,-17.28779 -5.08418,-26.1123 -0.57766,-5.9215 -0.8737,-11.86578 -0.83457,-17.85234 0.0645,-5.94825 0.3237,-11.94191 1.42623,-17.84614 1.40573,-7.64245 3.91414,-15.24255 7.23425,-22.33621 4.02209,-8.58341 9.28682,-16.56611 15.45339,-23.75828 7.68531,-8.94979 16.9047,-16.79534 26.86379,-23.2376 3.12493,-2.03077 6.35875,-3.9274 9.57762,-5.67451 6.93968,-3.74267 14.43099,-7.03222 21.88441,-9.62512 6.03151,-2.08713 12.172,-3.89105 18.41661,-5.22029 5.08975,-1.03093 10.28416,-1.38974 15.45109,-1.8149 7.04327,-0.53634 14.1042,-0.77688 21.16195,-1.03305 14.57344,-0.38954 29.33009,-0.4376 43.9651,0.12292 3.08924,0.12111 6.29083,0.29815 9.30443,0.49818 5.47551,0.35812 10.92912,1.04276 16.30529,2.14777 5.18969,0.99505 10.46919,2.24481 15.46229,3.69012 11.84831,3.42063 23.28608,8.43644 33.51356,15.36526 4.7835,3.2097 9.32711,6.7694 13.6505,10.57419 5.98791,5.31042 11.70727,11.14947 16.9036,17.31054 2.45882,2.9342 4.76826,5.99293 6.91867,9.16016 0.78656,1.16613 1.67382,2.53863 2.4515,3.81768 1.73495,2.84933 3.32223,5.78956 4.72428,8.81709 1.00392,2.16238 2.01654,4.63128 2.84579,7.00756 1.32443,3.70733 2.35176,7.47168 3.14598,11.38917 0.66487,3.27228 1.14138,6.52946 1.48072,9.88623 0.1956,1.97405 0.34024,4.07773 0.44938,6.13696 0.036,1.0246 0.0996,2.3191 0.11134,3.44869 0.12062,6.11457 -0.15135,12.12414 -0.66212,18.21342 -0.31502,3.47239 -0.73746,6.97779 -1.29122,10.34706 -0.63645,3.92024 -1.50277,8.02212 -2.59229,11.93117 -2.79082,10.32877 -7.45002,20.05758 -12.97177,29.18892 -2.63069,4.55234 -5.41213,9.09211 -7.08158,14.1062 -0.65202,1.9749 0.71428,4.45222 2.88022,4.58485 2.66375,0.26093 4.95297,-1.4053 7.16789,-2.62667 6.34805,-3.81657 12.15039,-8.44858 17.97712,-12.99997 13.22524,-10.56559 25.88574,-21.88148 37.45444,-34.25125 16.39489,-17.59007 30.46403,-37.50547 40.40509,-59.45088 9.39609,-20.66827 15.08975,-42.93446 17.43288,-65.49343 1.68782,-15.8175 1.69634,-31.75859 1.18883,-47.64046 -0.30111,-8.05294 -1.21369,-16.10419 -3.15373,-23.93607 -2.55143,-11.22313 -6.1661,-22.18862 -10.59114,-32.80924 -6.61624,-16.11087 -14.60574,-31.67143 -23.99942,-46.34142 -5.48611,-8.47239 -11.73881,-16.4347 -18.56021,-23.87066 -10.4825,-11.63403 -21.8709,-22.44663 -33.9443,-32.41642 -7.75425,-6.39002 -16.04711,-12.11044 -24.71375,-17.19065 C 601.38251,95.897452 576.50916,85.601791 550.84248,78.288164 544.44166,76.524156 538.0087,74.82148 531.46484,73.671875 522.04607,72.276308 512.51176,71.960279 503.00781,71.652344 497.76347,71.521599 492.5174,71.470223 487.27148,71.492188 Z M 597.18945,217.73828 c 10.48867,0.33473 20.73508,5.53276 27.14605,13.85073 2.32516,2.90282 4.2711,6.2247 4.92048,9.93217 0.22515,1.11702 0.35957,2.259 0.43887,3.2975 0.17824,2.42611 0.0496,4.85988 -0.0405,7.28679 -0.0954,1.68351 -0.26626,3.58365 -0.54102,5.33398 -0.99812,6.80584 -4.23911,13.30776 -9.31032,17.99028 -1.85566,1.74557 -3.97133,3.28792 -6.12053,4.49301 -6.65128,3.66293 -14.53807,5.57114 -22.08547,4.10001 -7.01329,-1.33849 -13.29378,-5.46918 -17.80538,-10.93711 -3.36676,-4.01096 -6.14198,-8.58775 -7.79583,-13.57144 -2.67005,-8.62842 -1.01502,-18.28403 3.7472,-25.87824 4.23726,-6.88238 10.95714,-12.28406 18.7258,-14.61448 0.50741,-0.15277 1.34188,-0.37952 1.99166,-0.52393 2.20284,-0.51682 4.46617,-0.77516 6.72904,-0.75927 z m -226.75,0.2832 c 0.76955,0.004 1.5271,0.0198 2.1865,0.0668 8.99161,0.57249 17.47392,4.91002 23.85323,11.16647 2.49184,2.40155 4.93232,4.94281 6.67507,7.95379 1.66538,3.34026 1.91837,7.1475 2.21234,10.80703 0.35491,6.1535 -0.65506,12.43726 -3.37715,17.99784 -1.12552,2.32491 -2.51691,4.52226 -4.15546,6.51982 -0.6107,0.74742 -1.43004,1.66685 -2.19548,2.41547 -3.42175,3.45664 -7.75439,5.92191 -12.38455,7.36236 -1.11137,0.35298 -2.12401,0.62702 -3.30672,0.90565 -3.98127,0.86733 -8.09558,1.34536 -12.16752,0.98611 -3.08622,-0.27237 -6.04832,-1.33561 -8.72635,-2.86934 -6.567,-3.50606 -12.25348,-8.90074 -15.45269,-15.68252 -1.97162,-4.06341 -3.01262,-8.69003 -3.22762,-13.0982 -0.18227,-3.78663 0.18236,-7.52253 1.06491,-11.2427 0.95265,-3.91068 2.62314,-7.65038 4.94485,-10.94089 0.43523,-0.61791 1.06756,-1.45453 1.63635,-2.11307 5.46749,-6.52999 13.95163,-10.21564 22.42029,-10.23459 z m 105.57617,104.7461 c -14.25588,0.2674 -28.56643,1.05066 -42.59715,3.7241 -8.344,1.59647 -16.33925,4.58945 -24.18938,7.77118 -14.55869,6.07197 -28.3471,14.44398 -39.41874,25.77727 -9.34905,9.59898 -16.62858,21.17362 -21.46269,33.65909 -4.8324,12.49191 -6.82432,26.06944 -5.72988,39.42134 1.09156,14.18048 5.38397,27.96413 11.47511,40.7642 3.40111,7.17374 7.63494,13.97901 12.87611,19.95826 5.33635,6.22854 11.18396,11.99849 17.13948,17.62979 11.35005,10.47497 24.22836,19.40663 38.41642,25.58953 10.90587,4.84081 22.37185,8.3407 34.00277,10.94869 7.77967,1.56301 15.75412,1.72098 23.66334,1.74913 12.53316,-0.0102 25.09844,-0.77156 37.46301,-2.8869 9.39636,-1.76014 18.41728,-5.0958 27.1702,-8.87521 14.26819,-6.28681 27.69985,-14.48644 39.79638,-24.32512 8.1652,-6.69225 15.58417,-14.36209 21.52605,-23.11141 9.35318,-13.4 16.53501,-28.51453 19.63687,-44.62496 2.3535,-11.96771 2.3865,-24.38002 0.0839,-36.35826 -2.19878,-11.50827 -6.36586,-22.63633 -12.2034,-32.79119 -8.15576,-13.7753 -20.32975,-24.82975 -33.93021,-33.09798 -9.57199,-5.81026 -19.86589,-10.41474 -30.52487,-13.82975 -9.2208,-2.79004 -18.80255,-4.11867 -28.35342,-5.17797 -14.88481,-1.58964 -29.87627,-2.1071 -44.83994,-1.91383 z M 477.90234,348.5 c 10.33168,0.0832 20.66581,0.35455 30.92987,1.01776 3.8947,0.27139 7.92345,0.50538 11.80256,1.40802 5.15128,1.11598 9.69266,4.29949 12.92141,8.4111 2.51074,3.24989 4.65459,7.1824 4.38107,11.41718 -0.20239,2.69695 -1.56517,5.12062 -2.80576,7.46403 -5.01121,8.59676 -11.60382,16.16689 -18.70205,23.09763 -4.58579,4.38242 -9.40836,8.65521 -15.04393,11.64464 -1.51274,0.79897 -3.20664,1.12472 -4.81804,1.63702 -2.53254,1.11212 -3.64256,3.97005 -3.86022,6.56116 -0.74585,5.50736 -0.55998,11.08122 -0.65548,16.62386 -0.0755,13.78109 -0.0425,27.56411 -0.0349,41.34433 0.12632,1.59818 1.48503,3.1818 3.19052,3.0013 2.08894,-0.0185 4.16204,-0.3374 6.24766,-0.44444 5.9019,-0.50508 11.71663,-1.74694 17.38279,-3.45373 10.64053,-3.1453 20.87744,-7.62461 30.49416,-13.14978 6.24817,-3.65802 12.1756,-8.02545 19.04072,-10.49226 1.44062,-0.40485 3.04813,-1.08793 4.51592,-0.44915 0.95688,0.84828 0.99699,2.2772 1.0922,3.46517 -0.0868,2.57966 -2.03655,4.51142 -3.62597,6.34102 -2.7344,2.89249 -5.73962,5.52486 -8.84972,8.00409 -5.77814,4.47923 -12.21674,8.05608 -18.93096,10.9241 -1.00467,0.41404 -2.25209,0.93461 -3.36267,1.35742 -9.22126,3.49292 -18.71841,6.13916 -28.31169,8.03261 -7.22461,1.41224 -14.67634,2.23278 -21.96041,2.49083 -17.73015,0.62527 -35.57487,-2.12241 -52.27104,-8.13119 -2.39567,-0.8485 -4.63043,-1.72494 -6.98884,-2.71422 -1.46974,-0.62254 -2.90104,-1.2563 -4.25965,-1.89092 -7.75431,-3.659 -15.2211,-8.07365 -21.71335,-13.70717 -2.53941,-2.301 -4.96439,-4.8395 -6.60019,-7.87674 -0.98035,-1.87703 -1.35087,-4.40807 0.0586,-6.14238 0.83576,-0.98454 2.25751,-0.63177 3.37587,-0.53274 2.97608,0.52732 5.64734,2.0492 8.2806,3.45702 4.94485,2.87982 9.41435,6.52263 14.51912,9.13795 10.80843,5.84874 22.41532,10.15706 34.30381,13.22176 5.88867,1.52347 11.9086,2.46013 17.92789,3.2841 1.60677,0.16344 3.39476,-0.91247 3.49763,-2.63061 0.22037,-2.14172 0.0145,-4.29971 0.0885,-6.44869 -0.009,-18.24753 0.0257,-36.49869 -0.0108,-54.74395 -0.24944,-1.66134 -1.54229,-3.07376 -3.15482,-3.52027 -4.57581,-2.1024 -9.35227,-3.94386 -13.35218,-7.08031 -2.70943,-2.00071 -5.29474,-4.21292 -7.69696,-6.47164 -6.76394,-6.39012 -13.00657,-13.41835 -17.94757,-21.32719 -2.59927,-4.41905 -4.22478,-9.7653 -3.01367,-14.87891 1.5258,-6.37939 6.53319,-11.72365 12.72524,-13.82764 1.45172,-0.54325 3.05188,-1.00897 4.44276,-1.32753 5.60859,-1.275 11.37222,-1.6844 17.10544,-1.93076 3.14177,-0.11917 6.44671,-0.16059 9.64648,-0.17188 z M 254.39453,473.4707 c -1.73986,0.63511 -3.26641,1.71897 -4.93638,2.50694 -14.1214,7.50305 -28.28587,14.96463 -41.83966,23.46869 -35.71974,22.10965 -68.75164,48.66368 -97.51808,79.30535 -19.02627,20.33994 -36.157967,42.57206 -49.902476,66.83285 -9.177094,16.31909 -16.835093,33.59616 -21.614341,51.73164 -2.170885,8.99691 -3.092449,18.24467 -3.628948,27.46767 -0.463213,9.08813 -0.427892,18.2177 0.398566,27.28409 0.580031,5.66157 1.458994,11.41307 3.975054,16.57977 3.902187,8.59958 9.171426,16.78246 16.510235,22.84535 5.741841,4.80092 12.663739,8.08799 19.929078,9.8175 10.266438,2.43657 21.091274,2.6227 31.397632,0.30284 9.09808,-2.00201 17.65454,-5.91389 25.75646,-10.43336 7.82492,-4.46907 15.33838,-9.4935 22.44301,-15.03702 3.37469,-2.67865 6.68546,-5.48203 9.5596,-8.70077 1.64348,-1.94985 2.37571,-4.42892 3.01967,-6.84547 3.56022,-12.3004 5.02646,-25.10427 7.67045,-37.54296 3.03542,-14.80963 6.88063,-29.45879 11.68833,-43.79404 2.54437,-7.55137 5.39359,-15.17426 8.51513,-22.5759 4.64495,-11.07359 9.97593,-22.02796 15.78204,-32.58138 3.79153,-6.90249 7.8256,-13.71091 11.98728,-20.3365 5.34106,-8.51537 11.01671,-16.86447 16.83982,-24.99933 13.28096,-18.53663 27.85343,-36.39533 42.70425,-53.83769 3.22823,-3.82833 6.53953,-7.59331 9.6579,-11.50972 0.82485,-1.28123 0.6836,-3.17594 -0.59249,-4.11739 -4.14292,-4.28432 -8.3986,-8.45896 -12.58522,-12.70086 -7.41643,-7.43826 -14.80822,-14.90474 -22.24004,-22.32536 -0.83556,-0.60872 -1.93242,-1.06711 -2.97687,-0.80494 z m 459.24414,0.49024 c -1.48974,0.47527 -2.27052,1.94052 -3.41765,2.8926 -10.76184,10.82313 -21.54737,21.62531 -32.2944,32.46152 -0.99653,1.19685 -1.23978,3.18857 -10e-4,4.3141 4.46104,5.54505 9.07125,10.96847 13.58987,16.46676 11.97698,14.46211 23.81603,28.99211 34.86975,44.16787 9.72143,13.21769 18.99423,26.99797 27.33987,41.19312 7.3091,12.43835 13.91397,25.23643 19.63336,38.49847 5.64615,13.03981 10.39542,26.46382 14.37619,40.13001 2.85765,9.78748 5.29612,19.75639 7.44166,29.81147 2.58632,12.08995 4.53329,24.44104 8.31963,36.27425 0.99235,3.00669 1.93944,6.14691 4.07668,8.5718 2.69758,2.99805 5.78743,5.62315 8.93975,8.1308 9.40074,7.25214 19.35757,13.82103 29.90701,19.28403 4.31409,2.18036 8.71822,4.33095 13.49125,5.29067 4.85683,0.9742 9.83876,0.98303 14.77238,1.05242 6.82219,-0.004 13.70046,0.0209 20.43672,-1.19674 5.32536,-0.94884 10.50387,-2.87517 14.98363,-5.9358 4.65259,-3.08694 8.86927,-6.84621 12.46064,-11.12072 4.83398,-5.96753 7.90455,-13.20391 9.52966,-20.67297 2.27297,-9.89688 2.71546,-20.09236 2.97594,-30.20783 0.22993,-13.28212 -0.91297,-26.67573 -4.51193,-39.50078 -4.18816,-15.12701 -10.89214,-29.39944 -17.98865,-43.34761 -8.92728,-17.28296 -19.73176,-33.59651 -32.21199,-48.52001 -14.65899,-17.65943 -31.02903,-33.79829 -47.66245,-49.57753 -16.01565,-15.14926 -32.80567,-29.60128 -51.25023,-41.73846 -20.61037,-13.64778 -42.72257,-24.782 -64.62967,-36.15308 -0.97518,-0.54864 -2.06465,-0.82721 -3.17578,-0.56836 z m -390.625,59.46679 c -3.56205,0.16568 -6.49845,2.48897 -9.02699,4.78647 -6.91525,6.46372 -13.15024,13.60456 -19.43094,20.67326 -27.05462,30.98837 -50.15713,65.61606 -66.89844,103.25048 -9.10667,20.57494 -16.35835,42.02367 -20.87742,64.08213 -1.95613,10.70686 -2.78277,21.57777 -3.56575,32.42126 -1.11969,16.75373 -1.78077,33.55521 -1.36748,50.34713 0.12783,5.49367 0.5665,10.99338 1.68561,16.38116 0.38023,1.84842 0.65149,3.73077 1.12726,5.55256 0.64917,1.5218 2.2344,2.5261 3.87412,2.58155 19.33721,3.42041 38.7676,6.88835 57.41207,13.20386 13.7797,4.61575 27.03296,10.93814 38.98002,19.24374 2.74425,1.89268 5.28617,3.7679 7.92915,5.83154 11.47454,8.96781 21.83945,19.26587 31.66105,29.99394 11.97968,13.25225 22.54063,28.06579 30.42654,44.22289 6.95284,14.10173 11.86734,29.17268 15.15983,44.49923 2.89476,13.27087 4.5532,26.75007 5.67693,40.31337 0.73727,8.1181 1.48927,16.274 3.33856,24.2287 0.34819,2.0828 1.60806,4.0981 3.6258,4.9014 3.54104,1.7438 7.46438,2.4556 11.27648,3.356 8.15928,1.7224 16.44898,2.7745 24.75207,3.4974 7.89931,0.5682 15.82394,0.6187 23.73842,0.812 26.28093,0.4896 52.65235,0.7903 78.82783,-1.9975 7.52224,-0.8644 15.08952,-1.8869 22.32143,-4.21 2.60391,-0.8859 5.28846,-1.9939 7.19565,-4.0487 1.01002,-1.0903 1.51177,-2.5441 1.53674,-4.0173 0.1491,-1.6748 0.13066,-3.2878 0.28585,-4.9028 0.76427,-11.0839 1.45498,-22.1529 2.55435,-33.1941 1.07488,-10.2222 2.69725,-20.44764 5.03803,-30.45617 2.71137,-11.62282 6.4625,-23.13701 11.41532,-34.11893 5.5794,-12.37347 12.71215,-24.14319 20.90994,-35.01777 9.66866,-12.73591 20.6995,-24.57893 32.59471,-35.36667 9.5636,-8.67238 19.99949,-16.42406 31.27443,-22.73294 11.74271,-6.56976 24.53327,-11.43639 37.5862,-14.84604 9.6965,-2.55952 19.5744,-4.35502 29.48704,-5.83779 6.49089,-1.06602 13.02371,-2.16655 19.2588,-4.31812 1.71234,-0.62856 3.05693,-2.19847 3.23714,-4.03696 0.9244,-4.22425 0.90579,-8.57571 1.1654,-12.87335 0.62056,-14.44875 0.47373,-28.91576 0.46457,-43.37403 -0.057,-10.61735 -0.0512,-21.25485 -0.97434,-31.84005 -0.69818,-7.20726 -2.26059,-14.29394 -4.08541,-21.29034 -6.64301,-26.18351 -16.55261,-51.47806 -28.68432,-75.59113 -8.54059,-16.84222 -18.20013,-33.14937 -29.3428,-48.40744 -7.6462,-10.41303 -15.99128,-20.28456 -24.36233,-30.1158 -7.09201,-8.24428 -14.32823,-16.37124 -21.8681,-24.20953 -2.10925,-2.11373 -4.20521,-4.29638 -6.68779,-5.9737 -2.80392,-1.5498 -6.15084,-0.86888 -9.07675,-0.0796 -4.43056,1.30279 -8.64854,3.21993 -12.8961,5.01162 -6.3621,2.77137 -12.59585,5.6161 -18.97538,8.28926 -14.66691,6.26113 -29.47006,12.30287 -44.78489,16.8114 -1.22996,0.34255 -2.66986,0.76998 -3.9216,1.10934 -7.92341,2.18603 -15.91257,3.76341 -24.06905,4.91841 -4.03612,0.56996 -7.9819,1.01743 -12.07779,1.38668 -8.27956,0.71806 -16.69415,1.16488 -25.00461,1.45467 -12.02149,0.40406 -24.05819,0.5918 -36.08125,0.14067 -4.05613,-0.16162 -8.26205,-0.38743 -12.36765,-0.70973 -2.33153,-0.17721 -4.55197,-0.39158 -6.89016,-0.6184 -2.01262,-0.22237 -4.26838,-0.4603 -6.32351,-0.73554 -11.88651,-1.51819 -23.6253,-4.01029 -35.1377,-7.41275 -9.77853,-2.87608 -19.57409,-6.40695 -29.03872,-10.2336 -11.95124,-4.8559 -23.7015,-10.1907 -35.64376,-15.06875 -4.39658,-1.77919 -8.77849,-3.60717 -13.24889,-5.19389 -1.00704,-0.30018 -2.05158,-0.51225 -3.10742,-0.47266 z M 208.77148,868.81055 c -19.99498,0.60536 -39.89013,6.64009 -56.54101,17.79687 -14.85649,9.87871 -27.06933,23.5311 -35.74731,39.08452 -4.58757,8.16843 -8.49124,16.75951 -11.19805,25.73904 -2.87828,9.66493 -4.17662,19.72867 -4.62797,29.78221 -0.46885,9.95562 -0.37071,19.93521 0.11445,29.88821 0.70613,12.3832 2.73227,24.7598 6.90168,36.4718 3.78249,10.7913 8.75396,21.1353 14.32403,31.1098 14.00547,24.6684 33.58166,46.359 57.47689,61.7727 11.7822,7.5829 24.54358,13.7244 37.98089,17.7435 9.14417,2.2733 18.60231,2.8091 27.98385,3.1528 10.52684,0.288 21.10665,-0.024 31.52977,-1.6096 13.66552,-2.2948 26.34707,-8.7005 37.38717,-16.9228 12.37678,-9.2705 22.90737,-20.9217 31.27081,-33.9074 5.54543,-8.6794 10.13908,-18.0062 13.28294,-27.8242 2.95752,-10.0406 3.95043,-20.5197 4.69194,-30.92 0.85844,-14.0869 0.63035,-28.2601 -1.00895,-42.2835 -0.93026,-7.7349 -2.71211,-15.35283 -5.17883,-22.73924 -9.38251,-29.07653 -26.75034,-55.38541 -49.17597,-76.0631 -16.13524,-14.8183 -35.10089,-26.76857 -55.91856,-33.77127 -13.99198,-4.67797 -28.794,-6.95022 -43.54777,-6.50034 z m 544.75196,1.1289 c -17.63756,0.29628 -35.37973,3.30934 -51.69053,10.17554 -9.79602,4.22288 -18.80111,10.07901 -27.2915,16.49291 -17.56194,13.35166 -32.59035,29.97412 -44.38204,48.60452 -6.29175,10.01374 -11.45086,20.70047 -15.93536,31.63115 -3.34807,8.32434 -5.89376,17.02022 -6.88902,25.95763 -1.41812,11.5432 -1.11661,23.2013 -0.87836,34.8021 0.28841,9.3291 0.37771,18.6878 1.49361,27.9652 0.75459,5.7015 2.44597,11.2397 4.66142,16.5352 8.73044,22.0963 22.68176,42.3319 41.20564,57.3348 12.40546,10.0188 26.84219,17.6907 42.3568,21.5429 11.31402,2.4985 23.01288,2.4649 34.51539,1.6352 12.61248,-1.0074 25.26764,-3.3183 36.92795,-8.377 22.18139,-9.391 41.89641,-24.1495 58.03263,-41.9568 13.83174,-15.2913 25.14322,-32.8796 33.11381,-51.9048 2.71578,-6.5401 5.11859,-13.2203 7.04126,-20.0378 1.57168,-5.6623 2.48584,-11.4924 2.83438,-17.3559 0.68949,-9.7164 0.90153,-19.4616 0.93635,-29.2003 -0.0721,-14.54989 -1.21999,-29.24784 -5.37331,-43.25594 -3.60445,-12.1629 -9.71853,-23.51216 -17.52243,-33.48974 -6.54216,-8.48112 -13.95912,-16.27949 -21.98028,-23.37211 -9.21878,-7.98787 -19.77705,-14.60024 -31.41394,-18.41154 -12.77119,-4.28014 -26.36546,-5.43069 -39.76247,-5.31522 z';
    }

    protected function frameNode()
    {
        return $this->makeSinglePathUsedSymbol(
            'symbol-frame-' . $this::$shapeId,
            $this->symbolViewBox(),
            'm 700.88189,3.0071085 c -2.78425,0.04946 -5.48703,0.1371513 -8.29884,0.3054069 -5.87338,0.3677 -11.80779,1.0205 -17.56089,2.484888 -6.51742,1.749803 -12.81604,4.2582546 -18.90227,7.1581336 -13.07984,6.314097 -25.27428,14.598592 -35.57784,24.864071 -3.80234,3.808318 -7.21894,7.989536 -10.26231,12.424828 -2.42645,3.18106 -5.17052,6.375485 -8.89589,8.043922 -1.90619,0.76027 -3.97241,0.364059 -5.90406,-0.05571 -11.80287,-2.325475 -23.26069,-6.065887 -34.95456,-8.847161 -20.01907,-4.81527 -40.53483,-7.939295 -61.15233,-8.943189 -6.18584,-0.308617 -12.34973,-0.42986 -18.57447,-0.355813 -4.78846,0.05207 -9.47154,0.215843 -14.26516,0.494958 -12.4053,0.732412 -24.92093,2.234701 -37.20979,4.498148 -9.96737,1.821721 -19.99341,4.170457 -29.80098,6.956826 -8.43496,2.380496 -16.87479,4.811355 -25.49022,6.458973 -2.02782,0.405854 -4.23105,0.283952 -6.01892,-0.845683 -3.66961,-2.020902 -6.39695,-5.312213 -8.99702,-8.516813 -2.7464,-3.550602 -5.47403,-7.127809 -8.60327,-10.35621 C 339.05961,26.749877 325.02281,17.327987 309.74713,11.032498 301.58032,7.7253714 293.01234,5.3087194 284.2338,4.3834524 c -5.15663,-0.59188 -10.33231,-0.890149 -15.47744,-0.99244 -4.2482,-0.09108 -8.65128,-0.01854 -12.75728,0.17469 -8.37484,0.428713 -16.80897,1.31597 -24.82128,3.914774 -1.52141,0.454236 -2.94722,0.917126 -4.39408,1.418935 -15.83966,5.4504396 -30.51309,14.1287616 -43.18308,25.0608216 -1.30109,1.134081 -2.74575,2.425092 -4.06085,3.667125 -13.10421,12.320591 -23.8732,27.295087 -30.52899,44.053578 -3.22911,8.204612 -5.50724,16.818204 -6.30186,25.614054 -0.37637,3.7699 -0.56607,7.55484 -0.60879,11.2879 -0.0529,8.90434 0.43895,17.89688 2.62609,26.56033 2.54203,9.23041 6.65737,17.9747 11.61659,26.14318 6.19115,10.07999 13.93074,19.40073 22.83104,27.28763 5.92142,5.26532 12.46592,9.82924 19.49247,13.49644 3.95254,2.20946 7.9287,4.52305 11.21386,7.6758 1.18162,1.17289 1.86829,2.92501 1.37953,4.57228 -1.34332,8.00392 -3.18398,15.91297 -4.9186,23.83842 -1.07847,4.92861 -2.08747,9.84782 -2.94332,14.74675 -1.73086,9.91055 -2.96778,19.90611 -3.62139,29.96667 -0.39863,6.06285 -0.56658,12.1956 -0.51976,18.32964 0.048,5.03212 0.24236,9.98965 0.59789,15.02973 0.71943,9.98421 2.10095,20.14481 4.12118,29.98063 1.78319,8.66361 4.03106,17.22813 6.54772,25.70595 1.41974,4.7034 3.00539,9.35699 4.79594,13.93256 1.4441,3.68553 3.07281,7.48622 4.74689,11.14748 4.43193,9.74335 9.51378,19.27929 14.01577,29.03319 1.06467,2.38298 2.1659,4.76638 2.98333,7.24516 0.40611,1.57934 -0.354,3.25717 -1.68544,4.14839 -3.34243,2.70979 -7.13872,4.77666 -10.82004,6.97845 -8.35385,4.77925 -16.97316,9.08001 -25.25834,13.98209 -9.1886,5.33289 -18.15179,10.95559 -26.97555,16.89939 -23.57944,15.90391 -45.98073,33.99169 -66.52862,53.7604 -20.731149,19.98034 -39.764527,41.75503 -56.242284,65.40497 -3.695153,5.32441 -7.289405,10.77594 -10.659086,16.24463 -3.536036,5.71634 -6.868469,11.48864 -10.031237,17.39208 -9.53613,17.86253 -17.434932,36.87652 -22.0961692,56.68174 -1.100771,4.74665 -2.025903,9.54585 -2.6582027,14.41406 -0.224486,1.82322 -0.442182,3.84005 -0.5887,5.68797 -0.541938,6.52054 -0.634821,13.01567 -0.407082,19.57312 0.364068,10.00824 1.5006807,20.05145 3.5260087,29.91441 1.590892,7.82668 3.7876612,15.6877 6.9813012,23.08822 3.745544,8.8664 9.836146,16.62403 16.89064,23.17918 2.400295,2.23779 5.08505,4.46652 7.783087,6.47481 2.479593,1.85652 5.225304,3.70156 7.945604,5.34987 10.346752,6.22243 21.901175,10.76446 33.986433,11.91572 12.567158,1.38829 25.430667,0.68669 37.634287,-2.72728 7.51531,-2.04601 14.94574,-5.06542 21.96027,-8.60726 4.79242,-2.40582 9.43095,-5.06903 13.98346,-7.82337 3.76816,-2.09252 7.58564,-4.29786 11.82773,-5.25669 1.76216,-0.35333 3.84351,0.41922 4.49768,2.19879 1.32738,3.02614 1.6967,6.35273 2.24478,9.58173 0.75357,5.35746 1.20068,10.75278 1.76966,16.13047 -0.0137,1.37282 -0.73622,2.82371 -2.11753,3.2598 -6.93598,3.39833 -14.06647,6.45067 -20.82167,10.12462 -5.65541,3.0341 -11.19754,6.38333 -16.44256,9.9786 -11.2546,7.76203 -21.79978,16.78576 -30.13363,27.6855 -6.48154,8.60833 -12.008168,17.89966 -17.029414,27.4219 -4.824281,9.27876 -9.280484,18.79522 -12.515746,28.75614 -1.181239,3.67013 -2.09286,7.59021 -2.834329,11.43625 -1.093556,5.83097 -1.839299,11.8954 -2.315647,17.87308 -0.632918,7.84298 -0.831507,15.82293 -0.677274,23.78333 0.07325,4.35746 0.259542,8.62766 0.559754,12.99616 0.552351,8.017 1.501585,16.2444 2.929377,24.171 1.34588,7.5449 3.253503,14.9958 5.886947,22.1972 2.734009,7.7328 5.802515,15.1572 9.335765,22.5482 1.618609,3.3829 3.34016,6.7585 5.152245,10.1008 8.703032,16.0665 19.486862,31.2278 32.025622,44.6244 9.65839,10.3529 20.50678,19.8095 32.19186,27.914 3.32045,2.2942 6.70387,4.5026 10.22269,6.6207 3.59324,2.1676 7.09911,4.1312 10.80135,6.0491 4.71675,2.4424 9.52924,4.6738 14.3691,6.6701 3.99653,1.6517 7.96276,3.1058 12.0786,4.4838 3.63659,1.2247 7.20349,2.2976 10.98476,3.1906 5.21184,1.2479 10.58872,1.8289 15.86681,2.2393 5.23255,0.4008 10.59221,0.5755 15.76416,0.7582 6.97076,0.193 14.07804,0.1421 20.95704,-0.3652 9.82143,-0.7034 19.58629,-2.5116 28.89797,-5.7473 1.55453,-0.5256 2.96651,-1.0525 4.48289,-1.6297 1.38328,-0.5488 2.97444,-1.1855 4.41704,-1.8214 14.73827,-6.4404 28.64252,-15.0187 40.3718,-26.0793 10.85851,-10.1572 19.76939,-22.2368 27.19748,-35.0778 4.08818,-6.9703 7.52997,-14.4656 11.80324,-21.3945 1.17268,-1.7852 2.19184,-3.7101 3.67919,-5.2598 1.16233,-1.2119 2.84316,-1.6288 4.46286,-1.7396 3.87157,-0.3511 7.74964,0.2086 11.59264,0.6344 5.71079,0.7578 11.38082,1.829 17.12794,2.2985 8.95803,0.8334 18.12254,1.2843 27.12124,1.629 23.22029,0.7859 46.46677,0.8507 69.69027,0.1591 5.82071,-0.1721 11.61831,-0.4234 17.46135,-0.7624 6.88189,-0.4399 13.84655,-0.887 20.68062,-2.0306 6.95752,-1.2353 13.89314,-2.651 20.90995,-3.5068 2.14309,-0.028 3.54273,1.8528 4.65048,3.4357 5.89922,8.4174 9.89902,17.9449 15.09707,26.7775 4.96483,8.5935 10.69366,16.7612 17.26808,24.2029 0.73115,0.8078 1.62029,1.8196 2.44171,2.6839 10.59383,11.4246 23.26969,20.8012 36.88222,28.3204 7.8195,4.0785 16.13402,7.1268 24.54156,9.7455 10.14019,3.0675 20.53493,5.5369 31.13451,6.2287 3.93065,0.2772 8.07501,0.3768 12.09281,0.3023 5.13528,-0.082 10.3262,-0.4457 15.47164,-1.0348 5.76347,-0.6646 11.72682,-1.6602 17.49287,-2.923 4.82269,-1.0503 9.74662,-2.3414 14.47498,-3.7868 17.03495,-5.2372 33.50781,-12.9023 47.71157,-23.8159 12.26256,-9.4531 23.37853,-20.3254 33.65003,-31.8914 9.36416,-10.6898 18.12777,-22.0023 25.11241,-34.4093 7.99776,-14.2856 13.96265,-29.6647 18.15189,-45.4782 0.7086,-2.7133 1.41755,-5.6006 2.02637,-8.3487 1.46792,-6.6318 2.62963,-13.3308 3.48339,-20.0693 0.32603,-2.6697 0.64712,-5.59 0.87582,-8.2796 0.74812,-8.6172 0.96491,-17.38476 0.61833,-25.96256 -0.25743,-6.17585 -0.80688,-12.39972 -1.69533,-18.51216 -0.39301,-2.70973 -0.87578,-5.56545 -1.41421,-8.255 -1.52897,-7.82546 -3.77138,-15.61868 -6.59164,-23.17425 -6.13244,-16.71016 -14.48498,-32.84947 -25.69812,-46.78824 -10.009,-12.53734 -22.26738,-23.19529 -35.77611,-31.81265 -9.66368,-6.26634 -20.0999,-11.18757 -30.27395,-16.54401 -1.14668,-0.69726 -2.68551,-1.02805 -3.28307,-2.35119 -0.61233,-0.86974 -0.88048,-1.96483 -0.58427,-3.00109 0.98468,-8.03959 1.56795,-16.15161 3.26301,-24.08518 0.28955,-1.61191 1.57636,-3.19834 3.33138,-3.15661 2.15405,-0.0224 4.10933,1.04472 6.08059,1.77571 9.9433,4.16817 19.22171,9.72209 29.02241,14.19546 4.45025,2.07013 8.90778,4.25358 13.71954,5.35264 3.85665,0.98691 7.83335,1.73329 11.67257,2.25439 3.35922,0.46361 6.89293,0.78011 10.18227,0.94202 12.05035,0.5317 24.48845,-0.48928 36.07709,-4.2682 4.3369,-1.40451 8.45515,-3.41158 12.36041,-5.75133 0.86205,-0.52705 1.87895,-1.14787 2.72829,-1.71536 3.18872,-2.07931 6.31413,-4.45914 9.24378,-6.99961 5.96157,-5.17887 11.37118,-11.20363 15.96231,-17.69559 0.85935,-1.21176 1.77082,-2.57393 2.52656,-3.73787 5.25811,-8.20528 9.47927,-17.13184 12.01367,-26.5586 0.27695,-1.06136 0.60098,-2.36509 0.83843,-3.53674 1.18859,-5.82043 1.85065,-11.56926 2.23551,-17.47326 0.61435,-9.8498 0.41921,-19.74243 -0.43331,-29.57203 -0.115,-1.1112 -0.21775,-2.37768 -0.3475,-3.51384 -1.05361,-10.08931 -3.01206,-20.09159 -6.03674,-29.77902 -4.64045,-15.3744 -11.13775,-30.45028 -18.64892,-44.67769 -7.13261,-13.52705 -15.29857,-26.4942 -24.17192,-38.94351 -1.08793,-1.5043 -2.24394,-3.1265 -3.36718,-4.63375 -19.5695,-26.55068 -42.32922,-50.6447 -67.13327,-72.38303 -13.75556,-12.02255 -28.2491,-23.42983 -43.27335,-33.93022 -12.89604,-8.89581 -26.23934,-17.12546 -39.72366,-25.0944 -7.40693,-4.29073 -14.80223,-8.63816 -22.55135,-12.28979 -2.8318,-1.20314 -5.96534,-2.31447 -7.86721,-4.8817 -0.96982,-1.33611 -1.11251,-3.1725 -0.34181,-4.63684 2.62964,-6.55776 6.66817,-12.41367 9.7425,-18.75498 8.02456,-16.40499 14.39123,-33.61193 19.25347,-51.23652 3.21666,-11.69795 5.65866,-23.61398 7.17592,-35.65291 0.26158,-2.18148 0.53549,-4.52658 0.74506,-6.73139 0.97686,-10.08201 1.27079,-20.11354 0.93641,-30.26845 -0.20623,-6.05176 -0.64758,-12.23131 -1.30361,-18.30361 -1.34017,-12.45969 -3.61258,-24.90511 -6.52472,-37.12962 -1.65924,-7.22544 -3.435,-14.43315 -4.75353,-21.72904 -0.14669,-1.84464 1.20666,-3.34418 2.62227,-4.32655 6.06829,-4.70882 13.3044,-7.55638 19.57137,-11.96371 12.32857,-8.41602 22.91054,-19.33864 31.13427,-31.78437 2.1036,-3.16976 4.06297,-6.61729 5.73459,-9.92342 6.02757,-12.10383 9.94938,-25.32792 10.91602,-38.83984 0.12285,-1.65131 0.19657,-3.4291 0.23189,-5.10228 0.0627,-3.39404 -0.0598,-6.82874 -0.36315,-10.13784 -0.52654,-5.95017 -1.65023,-11.96412 -3.25858,-17.783045 -1.5261,-5.529428 -3.62372,-11.210105 -6.09976,-16.573039 -4.16201,-9.029604 -9.37548,-17.571581 -15.41347,-25.467026 -7.85336,-10.010182 -17.72358,-18.267711 -28.24358,-25.344146 -3.8695,-2.589015 -7.89927,-5.012396 -11.90284,-7.18906 -4.37695,-2.379999 -8.88433,-4.559882 -13.43063,-6.460571 -4.83473,-2.0364186 -9.82305,-3.7915716 -14.78911,-5.1729736 -5.08014,-1.432563 -10.4221,-2.274063 -15.59405,-2.803223 -6.28552,-0.6485781 -12.60657,-0.8889162 -19.00782,-0.8300779 z m 1.57618,28.8144525 c 29.94076,-0.200761 59.41917,14.290603 78.06368,37.625544 9.87926,12.374884 16.57744,27.467575 18.11404,43.292915 1.201,12.29928 -0.53316,24.92296 -5.27343,36.35107 -3.94077,9.30387 -10.20735,17.532 -17.82787,24.13305 -5.35655,4.64399 -11.27785,8.58537 -17.29469,12.31282 -2.64066,1.49025 -5.46177,2.97923 -8.55025,3.13234 -2.82671,0.14362 -5.57602,-1.06721 -7.61243,-2.98693 -3.29203,-2.93562 -5.646,-6.72006 -8.13325,-10.31895 -2.98192,-4.5541 -5.91211,-9.15022 -9.25711,-13.45166 -8.89131,-11.71465 -18.8317,-22.58853 -29.06089,-33.13884 -11.10726,-11.34081 -22.6683,-22.26962 -35.03619,-32.23275 -3.55368,-2.83382 -7.19202,-5.516844 -10.97033,-8.103492 -5.38772,-3.725024 -10.79236,-7.4909 -15.57297,-11.989015 -1.32412,-1.209676 -2.60464,-2.946864 -2.09613,-4.844852 0.81295,-2.783551 2.93938,-4.892126 4.78563,-7.029199 5.94534,-6.438972 12.57191,-12.215011 19.41436,-17.67678 3.44226,-2.672889 6.94253,-5.339477 10.84105,-7.317013 5.53515,-2.597428 11.40738,-4.447818 17.37185,-5.764725 5.94121,-1.285533 12.01712,-1.942223 18.09493,-1.993533 z m -436.5293,0.632812 c 10.51684,-0.04828 21.24424,0.854506 31.11833,4.719823 7.40028,2.865764 14.27843,6.948958 20.70873,11.569347 6.23569,4.695873 11.97705,10.117775 16.6913,16.354766 1.77234,2.40145 3.52254,5.038414 3.89179,8.067002 0.10933,1.618925 -0.88629,3.014189 -2.05211,4.028381 -3.3923,3.265108 -7.26582,5.973827 -11.09091,8.699684 -5.40655,3.735454 -10.82956,7.452604 -16.02504,11.480674 -8.17218,6.2473 -16.064,12.96307 -23.59433,20.03705 -16.29939,15.31618 -31.07114,32.41464 -44.07608,50.66679 -3.97531,5.56674 -8.05998,11.07555 -12.62479,16.17696 -1.57113,1.61447 -3.06691,3.50508 -5.28851,4.23179 -1.32933,0.3943 -2.61434,1.04216 -4.0119,1.13765 -2.20702,0.003 -4.0968,-1.34777 -5.93646,-2.40246 -6.29041,-3.92599 -12.08766,-8.58252 -17.75648,-13.34615 -3.28981,-2.82351 -6.57558,-5.70665 -9.32947,-9.06846 -2.82424,-3.70129 -5.43282,-7.57968 -7.69634,-11.64972 -2.76428,-5.10398 -4.53545,-10.73215 -5.17659,-16.50187 -0.991,-7.89157 -0.83161,-15.86409 -0.85075,-23.80087 0.0429,-6.40276 0.4212,-12.96706 2.88161,-18.96073 2.28103,-5.800304 5.0193,-11.4348 8.29248,-16.741994 10.56552,-16.978408 26.83029,-30.199027 45.37021,-37.588749 11.59043,-4.646803 24.06772,-7.075164 36.55531,-7.108914 z M 486.18072,69.76492 c 14.49254,0.0839 29.02478,0.599782 43.38546,2.667095 8.23543,1.291959 16.35107,3.249925 24.40908,5.364516 35.54192,9.55899 69.27665,26.150979 98.05771,49.150989 24.56214,19.59761 45.46883,43.84744 60.79126,71.30585 8.57647,15.35403 15.49539,31.64247 20.52055,48.49788 5.88853,19.97808 8.72738,40.85135 8.33371,61.67757 -0.32838,19.39605 -3.19008,38.70371 -7.86079,57.51526 -5.88371,23.10387 -15.9135,45.12153 -29.34717,64.81053 -11.09665,16.34393 -24.29965,31.20961 -38.81717,44.58604 -9.90788,9.07578 -20.27403,17.65724 -31.07788,25.64637 -4.50137,3.28617 -9.04406,6.58895 -14.05128,9.07063 -2.05181,1.01943 -4.72138,1.3633 -6.65994,-0.0928 -1.86493,-1.41437 -2.1008,-4.11602 -1.26638,-6.16689 1.26502,-3.71253 3.58927,-6.93093 5.72284,-10.18104 2.23197,-3.29606 4.31494,-6.58793 6.20484,-10.11476 8.88985,-16.46052 13.88911,-34.97597 14.7431,-53.65194 0.14724,-3.38797 0.15048,-6.9008 -0.008,-10.28169 -0.49308,-11.41155 -2.93099,-22.87042 -7.19487,-33.38175 -2.42591,-6.00282 -5.42536,-11.77104 -8.91992,-17.2207 -6.40562,-10.00007 -14.64519,-19.01595 -23.91267,-26.54517 -14.59629,-11.88934 -31.84133,-20.32184 -49.9301,-25.39422 -4.77724,-1.3455 -9.60473,-2.46321 -14.45895,-3.27299 -10.11233,-1.56125 -20.30746,-2.18782 -30.5461,-2.67256 -13.78649,-0.61613 -27.72438,-0.70524 -41.50765,-0.22053 -3.09695,0.12552 -6.19241,0.28533 -9.28516,0.49024 -1.91573,0.1445 -4.03174,0.32019 -6.02013,0.518 -4.70902,0.44521 -9.50484,1.3224 -14.20448,2.2691 -1.03482,0.23168 -2.29744,0.49221 -3.39169,0.74259 -16.96151,3.81569 -33.46456,10.32292 -48.0034,19.99724 -2.15818,1.43059 -4.25481,2.9133 -6.27722,4.43013 -9.04916,6.81726 -17.31796,14.72647 -24.25299,23.69857 -3.31404,4.31329 -6.28882,8.88773 -8.86962,13.6764 -0.43891,0.83232 -1.00802,1.91313 -1.47441,2.85247 -1.41691,2.85562 -2.66859,5.74037 -3.76963,8.68281 -3.3387,8.88521 -5.31838,18.37149 -5.98057,27.7694 -0.83319,12.03477 0.35132,24.27782 2.89779,36.11265 0.48913,2.24434 1.0432,4.51311 1.63705,6.646 0.48302,1.78691 1.01785,3.58829 1.61266,5.4111 3.17834,9.90196 7.7917,19.32477 13.54447,27.98362 2.45759,3.87147 5.03644,7.7144 6.82951,11.9521 0.85102,2.13021 0.33425,5.01453 -1.83383,6.14173 -1.71541,1.01626 -3.76503,0.41343 -5.47006,-0.29253 -3.58471,-1.59021 -6.81763,-3.85114 -10.11651,-5.94828 -23.68471,-15.49133 -45.03929,-34.67745 -62.35577,-57.09967 -13.58528,-17.49783 -24.66386,-36.90462 -33.08171,-57.38656 -2.91112,-7.13503 -5.60132,-14.37212 -7.77854,-21.76698 -4.6466,-16.36034 -6.06085,-33.4369 -6.36839,-50.38046 -0.2074,-13.47265 0.25041,-26.95149 1.17083,-40.39225 1.12779,-14.44997 3.86997,-28.82365 8.82623,-42.46587 5.65558,-15.74409 13.65709,-30.51321 22.13192,-44.89176 7.14387,-11.9639 15.3525,-23.32298 24.8524,-33.53299 7.91361,-8.56626 16.36351,-16.63884 25.25248,-24.18721 35.67226,-30.08121 79.26876,-50.771538 125.22627,-58.98446 12.52698,-2.086315 25.24117,-2.710175 37.91903,-3.039313 3.34085,-0.07371 6.68249,-0.09769 10.02409,-0.101517 z M 595.84088,218.5032 c -8.73639,0.30457 -16.95795,4.93969 -22.50391,11.57226 -0.29443,0.34724 -0.66194,0.8115 -1.00842,1.25563 -5.39605,6.98175 -8.04993,16.21533 -6.42905,24.96183 1.23212,6.79379 5.20869,12.75027 9.9014,17.67362 3.38253,3.44167 7.30669,6.50788 11.85655,8.22689 2.6755,0.9948 5.59888,1.51378 8.36099,1.58067 9.74656,0.31265 19.27188,-4.37125 25.66228,-11.6127 5.01884,-5.63797 8.14057,-13.04126 8.16716,-20.63055 0.0789,-7.35276 -2.20182,-14.83533 -6.93363,-20.53306 -4.6694,-5.79669 -11.45692,-9.59349 -18.59155,-11.46332 -2.76818,-0.71993 -5.61548,-1.14984 -8.48182,-1.03127 z m -224.59375,0.11719 c -4.09406,0.0507 -8.15434,0.98475 -11.90821,2.60547 -0.70193,0.29739 -1.65184,0.74476 -2.42675,1.15412 -2.86375,1.52858 -5.64303,3.36217 -7.67637,5.93531 -2.71935,3.28721 -4.72379,7.10865 -6.32266,11.04728 -0.46824,1.20004 -0.99106,2.6315 -1.36941,3.96029 -1.28666,4.20256 -1.61091,8.72691 -0.61158,13.02661 0.72033,3.43978 2.12507,6.88355 3.84623,9.82365 3.23265,5.54187 8.03659,10.38823 13.50976,13.51758 3.21155,1.87652 6.77473,3.00099 10.26926,4.13122 2.16721,0.698 4.51071,0.96051 6.73465,0.36097 3.1708,-0.70734 6.34601,-1.51264 9.34686,-2.77378 12.87659,-5.57856 21.50749,-19.69853 20.46369,-33.71255 -0.36326,-4.61835 -1.56389,-9.36362 -4.57275,-13.00062 -2.78097,-3.54882 -6.01318,-6.76315 -9.62257,-9.46813 -5.66508,-4.1382 -12.58869,-6.74834 -19.66015,-6.60742 z m 108.93164,103.13086 c 16.74138,0.0992 33.54962,0.24557 50.16042,2.55962 10.64895,1.51969 21.13519,4.27927 31.05943,8.44874 8.45103,3.44318 16.61441,7.64529 24.11295,12.86333 9.12456,6.26749 17.60474,13.5924 24.57815,22.219 4.73717,5.92065 8.1398,12.77386 10.96083,19.7768 6.1727,15.62194 8.5885,32.67433 7.32295,49.40793 -0.92217,12.08524 -3.93793,24.06634 -9.38734,34.92068 -5.74757,11.7226 -13.2466,22.5572 -21.92388,32.29786 -6.07669,6.79704 -12.94898,12.89957 -20.56456,17.92569 -10.95315,7.39095 -22.71367,13.55513 -34.8891,18.66987 -8.74452,3.66681 -17.83344,6.6677 -27.24704,8.00863 -10.79063,1.67085 -21.68977,2.63345 -32.60162,2.98724 -4.74787,0.12374 -9.54705,0.1421 -14.2178,-0.83313 -9.07912,-1.58647 -18.18,-3.18726 -27.06278,-5.67883 -9.19864,-2.67861 -18.04105,-6.47101 -26.58864,-10.77353 -20.02704,-10.23254 -37.97243,-24.87166 -51.0812,-43.22433 -11.86277,-16.54031 -19.68584,-36.14517 -21.42569,-56.48768 -1.46444,-16.94052 1.42883,-34.31013 8.79712,-49.66884 6.92349,-14.551 17.7253,-27.12524 30.6897,-36.64105 7.55134,-5.60223 15.85944,-10.09987 24.41747,-13.95769 10.206,-4.71946 20.90322,-8.55736 32.03736,-10.34544 13.66578,-2.29988 27.56939,-2.40653 41.38999,-2.47318 0.48776,-5.6e-4 0.97552,-0.001 1.46328,-0.002 z m -0.21094,27.42187 c -6.04488,0.0746 -11.97736,0.258 -17.98995,0.83719 -4.36505,0.44434 -8.79544,0.81756 -13.14734,1.6623 -2.45176,0.48066 -4.84367,1.51214 -6.60587,3.32711 -2.80953,2.67172 -5.44339,5.61807 -7.28754,9.05104 -1.07925,2.02177 -1.7486,4.40052 -1.12218,6.6737 0.89006,3.62323 2.73815,6.92425 4.63313,10.10701 2.23906,3.62237 4.82186,7.17395 7.4553,10.41782 3.71549,4.5315 7.84381,8.9368 12.31344,12.83816 3.48005,3.01452 7.18047,5.95041 11.51273,7.62864 2.48848,0.9361 5.07609,1.61363 7.55139,2.56804 1.15352,0.66784 2.12007,1.94378 1.8822,3.3429 0,21.02448 0,42.04896 0,63.07343 -0.24438,1.24719 -0.97549,2.71553 -2.4082,2.82422 -1.52146,0.34577 -3.0372,-0.24917 -4.55717,-0.33272 -5.29669,-0.6753 -10.59668,-1.42123 -15.77272,-2.76372 -8.79797,-2.11788 -17.49993,-4.69625 -25.93219,-7.9912 -2.85253,-1.13154 -5.5957,-2.64284 -8.06253,-4.37487 -5.37211,-3.49428 -10.38,-7.50698 -15.66162,-11.12885 -2.12829,-1.39437 -4.3549,-2.8894 -6.92197,-3.26801 -1.45696,0.01 -2.55843,1.2579 -3.17591,2.45919 -0.74982,1.56177 0.2258,3.21187 1.02426,4.53813 2.25795,3.29643 5.41406,5.83728 8.4954,8.3269 5.20926,4.03231 10.78385,7.59812 16.6289,10.63672 2.67742,1.37821 5.55453,2.71107 8.39063,3.89257 1.40329,0.56677 3.01849,1.21475 4.52112,1.76526 11.07536,4.09443 22.71224,6.60687 34.34587,8.2364 5.86493,0.79961 11.93543,1.5805 17.76973,1.28741 11.14627,-0.64639 22.04128,-2.81362 32.87397,-5.57261 2.86873,-0.74622 5.85348,-1.58942 8.60259,-2.43911 7.52544,-2.32348 14.92849,-5.15053 21.80158,-9.02812 6.31917,-3.56885 12.40801,-7.68701 17.53685,-12.85491 2.15612,-2.3158 4.37735,-4.78333 5.33344,-7.86502 0.26976,-0.845 0.16762,-1.93193 -0.71875,-2.36719 -1.30736,-0.89876 -2.97836,-0.59871 -4.33593,0.006 -3.85717,1.54706 -7.18278,4.10838 -10.60695,6.41058 -6.1991,4.22736 -12.5272,8.29984 -19.18783,11.76618 -6.22787,3.00801 -12.89036,4.97907 -19.54702,6.78613 -6.37913,1.6397 -12.84984,3.15662 -19.44924,3.48773 -2.10115,0.029 -4.21699,0.086 -6.31,0.006 -1.21075,-0.25325 -2.55989,-1.02108 -2.68641,-2.38574 -0.31098,-1.50125 -0.05,-3.04736 -0.13833,-4.56849 0,-19.71758 0,-39.43516 0,-59.15274 0.23382,-1.36165 1.13114,-2.82755 2.62599,-2.99456 3.06145,-0.73109 6.29719,-1.0592 9.05565,-2.69684 4.44931,-2.43068 8.28538,-5.81607 11.97312,-9.25842 6.52198,-6.2118 12.37597,-13.14716 17.29055,-20.69862 2.10599,-3.39055 4.18884,-6.90978 5.1376,-10.82288 0.46899,-1.93921 -0.0197,-3.93816 -0.86974,-5.69662 -1.82841,-3.94207 -4.96557,-7.16014 -8.4689,-9.66508 -2.78311,-1.96875 -6.0612,-3.23708 -9.41228,-3.70074 -7.11957,-1.25635 -14.35441,-1.67664 -21.56517,-2.03565 -5.55537,-0.24593 -11.20985,-0.33477 -16.8137,-0.29387 z m 234.66602,123.125 c 1.24491,0.21603 2.27071,1.0631 3.4179,1.5537 20.28871,10.4392 40.77682,20.60389 60.04484,32.87829 14.56796,9.24397 28.28906,19.78747 41.18149,31.24509 12.39892,10.94932 24.23594,22.5166 35.90198,34.23836 17.41293,17.66789 34.06608,36.31969 47.29389,57.38596 5.94841,9.49742 11.28656,19.37013 16.21314,29.43243 7.63208,15.78369 13.70766,32.45621 16.50465,49.81363 1.92486,11.76345 2.5362,23.74253 1.86711,35.64225 -0.76112,11.67258 -3.17867,23.46122 -8.84169,33.7989 -4.59384,8.3795 -11.54266,15.51822 -20.02476,19.97998 -4.78581,2.61669 -10.03533,4.37647 -15.44515,5.09691 -9.35998,1.41167 -18.91635,1.34787 -28.29862,0.18012 -5.93516,-0.73758 -11.85469,-2.18777 -17.15132,-5.03703 -8.70131,-4.43625 -16.89168,-9.80038 -24.89729,-15.37594 -5.23001,-3.71581 -10.41607,-7.55162 -15.02008,-12.03577 -2.91315,-2.95931 -5.11971,-6.61638 -6.22659,-10.62845 -2.02623,-6.61415 -2.56746,-13.54621 -3.76584,-20.33119 -0.80073,-4.93132 -1.73018,-9.93553 -2.70874,-14.77474 -0.62231,-3.01644 -1.30236,-6.13186 -1.9668,-9.07031 -3.17072,-13.76184 -7.17997,-27.54317 -11.95895,-40.84542 -4.1807,-11.67869 -9.03805,-23.21567 -14.40628,-34.33036 -3.60515,-7.43569 -7.40828,-14.70166 -11.43507,-21.94063 -9.78132,-17.75002 -21.32314,-34.57395 -33.74069,-50.66123 -14.0114,-18.23711 -28.87433,-35.77648 -43.71881,-53.30533 -0.90802,-1.13519 -2.12955,-2.19497 -2.23942,-3.74299 -0.25934,-1.42884 0.96537,-2.40906 1.83537,-3.32892 11.67819,-11.66773 23.34665,-23.34556 35.02127,-35.017 0.75177,-0.47191 1.65607,-0.87747 2.56446,-0.82031 z m -458.1211,0.17383 c 1.53226,0.0441 2.33858,1.54859 3.38847,2.43729 11.42845,11.42846 22.85691,22.85691 34.28536,34.28537 0.74494,1.09678 1.2302,2.70904 0.26692,3.83563 -1.38265,1.88973 -2.99864,3.59747 -4.46584,5.42229 -9.18743,10.98884 -18.50838,21.86731 -27.54657,32.98079 -8.10217,10.02324 -15.94264,20.30738 -23.35802,30.80816 -8.30247,11.772 -16.18725,23.98285 -23.34422,36.53683 -7.05104,12.39205 -13.49984,25.26161 -19.07875,38.44155 -2.36971,5.58519 -4.64023,11.41059 -6.71463,17.14551 -2.52759,7.02582 -4.83222,14.15396 -6.85758,21.23126 -3.3836,11.77804 -6.12713,23.75904 -8.29372,35.85324 -1.47885,8.04848 -2.47854,16.33177 -3.92968,24.4493 -0.83419,4.65947 -1.9002,9.56975 -5.1113,13.23027 -2.48434,2.84832 -5.50051,5.1627 -8.39696,7.56869 -9.55132,7.59636 -19.84816,14.27398 -30.74032,19.78365 -6.01624,3.02101 -12.39323,5.38438 -19.03201,6.58354 -10.83266,2.09536 -22.11908,2.09903 -32.893411,-0.34923 -8.993522,-2.12062 -17.576312,-6.59125 -23.850565,-13.45925 -4.940214,-5.31368 -8.483865,-11.73203 -11.648312,-18.21152 -2.0796,-4.4001 -4.159249,-8.87056 -5.067341,-13.68603 -1.110507,-5.36586 -1.111003,-10.87447 -1.236499,-16.32908 -0.03744,-9.91724 -0.06412,-19.87865 1.296789,-29.72324 1.513108,-11.56767 5.281394,-22.67949 9.28935,-33.58487 7.632502,-20.57998 18.506915,-39.83145 30.992785,-57.83612 18.131351,-26.03841 39.762664,-49.53054 63.397614,-70.65426 27.75422,-24.72579 58.39239,-46.24511 91.20577,-63.72194 8.33148,-4.41597 16.81484,-8.53715 25.29822,-12.64936 0.65412,-0.37812 1.4098,-0.39876 2.14445,-0.38847 z m 65.60742,59.23437 c 3.64311,0.33123 7.05003,1.78698 10.46703,2.99188 13.45601,5.09201 26.28124,11.6581 39.50697,17.29323 7.64616,3.31742 15.35672,6.4936 23.18225,9.36529 0.97559,0.33625 2.14237,0.74157 3.15204,1.05014 10.87547,3.34315 22.11238,5.69652 33.30109,7.44009 12.14899,1.8773 24.42944,3.03536 36.75088,3.62834 10.2669,0.48547 20.71974,0.54599 30.98967,0.19968 7.67035,-0.26262 15.26109,-0.77031 22.90007,-1.52724 9.93713,-1.02526 19.95132,-2.45912 29.78342,-4.61599 5.91918,-1.26893 11.92201,-2.89025 17.8054,-4.56887 7.67961,-2.22843 15.13678,-4.84466 22.45666,-7.97191 12.98217,-5.4488 25.62377,-11.65822 38.47434,-17.40145 4.67335,-2.02741 9.37925,-4.08694 14.34742,-5.28152 2.30082,-0.55987 4.99858,-0.63715 6.93294,0.94438 2.64642,1.95618 4.87701,4.40555 7.21659,6.70557 8.12042,8.29889 15.83011,16.98888 23.45755,25.73958 7.55298,8.72583 14.99472,17.57055 21.72157,26.9568 16.87714,23.3882 31.24204,48.61752 42.47442,75.19016 8.18506,19.44498 14.68287,39.63559 18.86041,60.3262 1.54264,7.59759 2.43314,15.31217 2.90286,23.04682 0.79283,12.49438 0.80716,25.02175 0.79047,37.53644 -0.0601,11.92884 -0.16426,23.86818 -0.94484,35.77498 -0.2131,3.02157 -0.77825,6.38134 -3.16592,8.4899 -2.5447,2.13669 -5.98112,2.54116 -9.13767,3.09263 -8.22145,1.28263 -16.54833,1.80545 -24.73298,3.34132 -7.69828,1.34639 -15.33389,3.18056 -22.75435,5.48012 -4.64244,1.44247 -9.35508,3.11191 -13.86626,4.95433 -17.7201,7.19235 -34.17459,17.46585 -48.43322,30.20889 -6.00031,5.32282 -11.53296,11.14179 -17.06403,16.9424 -9.66871,10.28388 -18.87873,21.25754 -26.15835,33.43929 -5.18378,8.61063 -9.55744,17.61888 -13.45087,26.90163 -4.66634,11.21783 -8.31779,23.02369 -10.73227,34.99962 -1.87989,9.23845 -3.05365,18.60975 -3.74618,28.00885 -0.43803,6.064 -0.61801,12.3112 -0.99819,18.4437 -0.45262,6.1995 -0.72113,12.4391 -1.84664,18.5626 -0.35101,1.5399 -1.47825,2.8275 -2.95595,3.3824 -3.75484,1.7708 -7.84766,2.6385 -11.8638,3.5974 -11.54774,2.5202 -23.37376,3.3489 -35.14535,4.0633 -21.5422,1.1524 -43.13878,1.1858 -64.69343,0.3623 -13.29287,-0.5344 -26.59795,-1.3585 -39.77158,-3.2744 -4.64331,-0.7383 -9.28676,-1.575 -13.81685,-2.8443 -2.82547,-0.9083 -5.38695,-2.9335 -6.42738,-5.7777 -1.54592,-3.7328 -1.7393,-7.8302 -2.11551,-11.8038 -0.60481,-7.5738 -0.88539,-15.1981 -1.51489,-22.696 -0.46995,-5.5716 -1.11673,-11.1368 -1.92929,-16.6206 -0.67101,-4.4629 -1.43659,-8.81066 -2.37113,-13.24039 -0.85924,-4.11529 -1.82218,-8.1174 -2.94045,-12.20075 -2.64379,-9.72749 -6.09907,-19.4286 -10.32775,-28.66277 -5.04981,-11.07673 -11.3231,-21.81288 -18.48456,-31.75489 -4.83312,-6.72017 -10.08001,-13.13728 -15.63318,-19.27432 -2.70162,-2.96221 -5.5806,-6.0216 -8.47339,-8.9037 -8.64331,-8.65942 -17.86515,-16.64248 -27.88599,-23.66466 -3.03864,-2.14136 -6.25811,-4.24602 -9.4375,-6.20117 -16.76551,-10.31349 -35.40249,-17.52104 -54.70189,-21.35589 -6.31667,-1.30439 -12.74329,-2.13499 -19.14406,-3.15815 -5.10453,-0.80454 -10.22072,-1.55963 -15.29725,-2.52258 -2.41484,-0.61055 -4.20351,-2.74984 -4.724,-5.14005 -1.04276,-3.71368 -1.14657,-7.60192 -1.4511,-11.42464 -0.6047,-9.56208 -1.10446,-19.13582 -1.21632,-28.71782 -0.2852,-27.59874 2.70593,-55.2913 9.69906,-82.0157 6.78334,-26.09566 17.26052,-51.16086 30.37282,-74.69541 8.07979,-14.53111 17.04485,-28.57533 26.94239,-41.9374 9.62999,-13.06342 19.83163,-25.70772 30.55263,-37.89163 5.29656,-5.96197 10.69128,-11.87085 16.67409,-17.15748 1.88201,-1.60669 3.85948,-3.27234 6.25555,-4.02658 0.45031,-0.11489 0.92029,-0.15204 1.38378,-0.1305 z M 213.45221,867.55789 c 19.08732,-0.019 38.13503,4.36758 55.35478,12.58452 17.72075,8.40014 33.48469,20.53635 47.12383,34.55349 11.84851,12.02326 22.62215,25.28269 30.59781,40.21734 7.17781,13.33007 12.15008,27.74313 15.81736,42.4005 2.45868,10.46326 3.31073,21.22736 3.70596,31.94416 0.30697,10.5543 -10e-4,21.1449 -1.26722,31.6326 -0.79078,6.5033 -2.21234,12.9247 -4.25721,19.149 -6.42558,20.02 -17.68831,38.4613 -32.49987,53.3778 -10.37339,10.3887 -22.6693,19.0791 -36.4921,24.2022 -7.32769,2.572 -15.08389,3.5731 -22.77255,4.3768 -11.58613,1.116 -23.26981,1.375 -34.88422,0.5527 -6.30927,-0.4339 -12.61823,-1.3874 -18.62796,-3.409 -20.67604,-6.4262 -39.61232,-17.7875 -55.93258,-31.9193 -18.14211,-15.7398 -33.13785,-35.1089 -43.7027,-56.6863 -5.87528,-11.6371 -11.01174,-23.7874 -13.54941,-36.6283 -2.66603,-13.2278 -3.16633,-26.7647 -3.40728,-40.21886 -0.13838,-14.16398 0.8605,-28.51029 5.04096,-42.11773 2.87247,-9.50986 6.93065,-18.63571 11.68013,-27.34951 11.42382,-20.30724 29.09474,-37.16863 50.22579,-47.08438 8.67634,-4.05374 17.96387,-6.78086 27.45628,-8.0522 6.74664,-1.01248 13.5682,-1.51768 20.3902,-1.52553 z m 542.5039,0.61914 c 14.76466,-0.0265 29.70883,2.07661 43.41672,7.7487 13.54507,5.50534 25.51043,14.38073 35.69261,24.78847 10.78661,10.91835 20.0131,23.54289 26.10108,37.68383 6.43978,14.77013 9.38945,30.8516 10.17302,46.88413 0.58387,11.79028 0.0449,23.60314 -0.76364,35.36944 -0.58732,7.4231 -1.87173,14.8037 -4.10763,21.9142 -3.52138,11.9538 -8.07481,23.6246 -13.95976,34.62 -14.20862,26.7791 -35.25377,50.0134 -60.90578,66.2407 -12.89845,8.1243 -26.97611,14.4836 -41.77372,18.2246 -8.46072,1.8707 -17.1402,2.4899 -25.78147,2.7919 -8.38081,0.2208 -16.8618,0.1177 -25.0736,-1.7574 -18.25779,-3.9217 -35.40098,-12.64 -49.5344,-24.8176 -17.0429,-14.5976 -29.77355,-33.833 -37.92065,-54.6573 -2.24627,-5.7411 -4.34632,-11.6083 -5.14907,-17.7511 -1.00209,-7.0919 -1.05923,-14.272 -1.17927,-21.4206 -0.0987,-10.7546 -0.0715,-21.5121 0.17612,-32.2644 0.20285,-7.739 0.85132,-15.56556 3.30306,-22.9566 3.10849,-9.96308 6.90179,-19.722 11.44816,-29.11855 7.18888,-14.84966 16.48614,-28.69098 27.67572,-40.82404 9.37314,-10.21138 19.87085,-19.38634 31.18138,-27.39402 11.5872,-8.10019 24.40065,-14.56269 38.05063,-18.35029 12.6473,-3.54313 25.82283,-4.91716 38.93049,-4.95407 z',
            $this->frameId()
        );
    }

    public function symbolViewBox()
    {
        return sprintf('0 0 %s %s', $this->svgWidth(), $this->svgHeight());
    }

    private function svgWidth()
    {
        return '970.75623';
    }

    private function svgHeight()
    {
        return '1196.7694';
    }

    protected function renderStyles()
    {
        return sprintf('.foreground-0 {
            transform: translate(5%%, 16%%) scale(1.4);
        }

        #%2$s path {
        }

        #%3$s {
            fill: %4$s;
        }

        .foreground-1 {
            mask: url(#%s);
        }', $this->maskId(), $this->symbolId(), $this->frameId(), $this->qrcode->design->frameColor);
    }

    protected function frameStrokeWidth()
    {
        return 3;
    }

    protected function modifiedViewBox()
    {
        return sprintf(
            '%1$s %1$s %2$s %2$s',
            $this->output->size * -2,
            $this->output->size * 6
        );
    }
}
