<?php

namespace App\Support\QRCodeProcessors\ShapeProcessors;


class SunRiseShapeProcessor extends BaseShapeProcessor
{
    public static $shapeId = 'sun-rise';

    public function symbolPath()
    {
        return 'm 213.11324,558.17812 c 7.34188,-72.22835 34.33138,-131.41452 81.38185,-178.46499 35.04251,-35.04251 74.78656,-57.60472 122.12641,-69.32965 15.71004,-3.891 22.55136,-4.45581 53.97142,-4.45581 31.51014,0 38.21635,0.55694 53.97142,4.48221 48.74231,12.14382 86.24457,33.39714 122.22586,69.26798 47.02744,46.88305 75.5601,108.36537 81.52003,175.65966 l 1.2998,14.67644 H 470.7601 211.91015 Z';
    }

    protected function frameNode()
    {
        return $this->makeSinglePathUsedSymbol(
            'symbol-frame-' . $this::$shapeId,
            '0 0 700 700',
            'm 286.34316,605.03423 h -12.43818 c -3.32849,0 -6.13145,-2.99644 -6.13145,-6.55464 0,-3.55823 2.80296,-6.55467 6.13145,-6.55467 h 12.6134 c 3.32849,0 6.13146,2.99644 6.13146,6.55467 0,3.5582 -2.97819,6.55464 -6.30668,6.55464 z m 13.31012,0 h -9.63519 c -3.3285,0 -6.13146,-2.99644 -6.13146,-6.55464 0,-3.55823 2.80296,-6.55467 6.13146,-6.55467 h 9.63519 c 3.3285,0 6.13147,2.99644 6.13147,6.55467 0,3.5582 -2.80297,6.55464 -6.13147,6.55464 z m 126.1339,0 H 303.33239 c -3.3285,0 -6.13147,-2.99644 -6.13147,-6.55464 0,-3.55823 2.80297,-6.55467 6.13147,-6.55467 h 122.45479 c 3.32851,0 6.13148,2.99644 6.13148,6.55467 0,3.5582 -2.80297,6.55464 -6.13148,6.55464 z m 46.4173,-39.70702 h -20.1462 c -3.32848,0 -6.13147,-2.99643 -6.13147,-6.55465 0,-3.55822 2.80299,-6.55465 6.13147,-6.55465 h 20.1462 c 3.32848,0 6.13146,2.99643 6.13146,6.55465 0,3.55822 -2.62775,6.55465 -6.13146,6.55465 z m -25.75534,0 h -15.59161 c -3.32849,0 -6.13147,-2.99643 -6.13147,-6.55465 0,-3.55822 2.80298,-6.55465 6.13147,-6.55465 h 15.59161 c 3.32848,0 6.13145,2.99643 6.13145,6.55465 0,3.55822 -2.80297,6.55465 -6.13145,6.55465 z m -21.71907,0 H 227.28845 c -3.32849,0 -6.13147,-2.99643 -6.13147,-6.55465 0,-3.55822 2.80298,-6.55465 6.13147,-6.55465 h 197.26543 c 3.32851,0 6.13147,2.99643 6.13147,6.55465 0,3.55822 -2.62775,6.55465 -5.9564,6.55465 z M 195.41461,521.87038 h -19.27006 c -3.32849,0 -6.13146,-2.99644 -6.13146,-6.55466 0,-3.55821 2.80297,-6.55463 6.13146,-6.55463 h 19.27006 c 3.3285,0 6.13148,2.99642 6.13148,6.55463 0,3.55822 -2.80298,6.55466 -6.13148,6.55466 z m 29.08688,0 H 203.1284 c -3.32848,0 -6.13147,-2.99644 -6.13147,-6.55466 0,-3.55821 2.80299,-6.55463 6.13147,-6.55463 h 21.37309 c 3.32849,0 6.13147,2.99642 6.13147,6.55463 0,3.55822 -2.62774,6.55466 -6.13147,6.55466 z m 277.49461,0 H 232.91042 c -3.32849,0 -6.13147,-2.99644 -6.13147,-6.55466 0,-3.55821 2.80298,-6.55463 6.13147,-6.55463 H 501.9961 c 3.32849,0 6.13147,2.99642 6.13147,6.55463 0,3.55822 -2.80298,6.55466 -6.13147,6.55466 z m 100.20238,-42.5151 h -16.2925 c -3.32849,0 -6.13147,-2.99644 -6.13147,-6.55466 0,-3.55822 2.80298,-6.55465 6.13147,-6.55465 h 16.2925 c 3.3285,0 6.13147,2.99643 6.13147,6.55465 0,3.55822 -2.62776,6.55466 -6.13147,6.55466 z m -28.55832,0 h -33.8103 c -3.32849,0 -6.13147,-2.99644 -6.13147,-6.55466 0,-3.55822 2.80298,-6.55465 6.13147,-6.55465 h 33.8103 c 3.32849,0 6.13147,2.99643 6.13147,6.55465 0,3.55822 -2.80298,6.55466 -6.13147,6.55466 z m -46.94584,0 H 100.642 c -3.328497,0 -6.131465,-2.99644 -6.131465,-6.55466 0,-3.55822 2.802968,-6.55465 6.131465,-6.55465 h 425.87612 c 3.32851,0 6.13149,2.99643 6.13149,6.55465 0,3.55822 -2.62776,6.55466 -5.95642,6.55466 z M 683.48478,441.90843 H 23.039613 c -3.328485,0 -6.131469,-2.99643 -6.131469,-6.55465 0,-3.55822 2.802984,-6.55465 6.131469,-6.55465 H 683.48478 c 3.32848,0 6.13147,2.99643 6.13147,6.55465 0,3.55822 -2.80299,6.55465 -6.13147,6.55465 z M 287.03188,177.84565 c -2.62774,0 -5.2555,-1.87285 -5.9564,-4.86929 l -9.81042,-39.32861 c -0.87594,-3.55821 1.05111,-7.11643 4.37969,-8.05287 3.32857,-0.93643 6.65698,1.12367 7.53296,4.68197 l 9.81041,39.32862 c 0.87595,3.55821 -1.05111,7.11643 -4.37968,8.05286 -0.52556,0.18728 -1.05112,0.18728 -1.57669,0.18728 z m -114.56964,70.78431 c -1.57667,0 -3.15342,-0.56182 -4.37968,-1.87285 l -26.97905,-28.8411 c -2.45251,-2.62179 -2.45251,-6.74198 0,-9.17661 2.45253,-2.6218 6.3067,-2.6218 8.58416,0 l 26.97904,28.84108 c 2.45252,2.62179 2.45252,6.74197 0,9.17663 -1.2263,1.12365 -2.62775,1.87285 -4.20447,1.87285 z m -66.21429,122.49417 c -0.52554,0 -1.05111,0 -1.57668,-0.18728 L 67.881822,360.44933 c -3.328509,-0.9364 -5.255501,-4.49466 -4.379691,-8.05286 0.87581,-3.55823 4.204464,-5.61823 7.532961,-4.68197 l 36.789448,10.48751 c 3.32849,0.9364 5.25549,4.49463 4.3797,8.05287 -0.87595,2.99643 -3.32851,4.86929 -5.95642,4.86929 z m 494.02849,0 c -2.62775,0 -5.25551,-1.87287 -5.95641,-4.86929 -0.87593,-3.55822 1.05112,-7.11643 4.37969,-8.05287 l 36.78946,-10.48751 c 3.32849,-0.9364 6.65699,1.12365 7.53296,4.68197 0.87597,3.5583 -1.05112,7.11644 -4.37969,8.05286 l -36.78946,10.48752 c -0.52556,0.18728 -1.05111,0.18728 -1.57668,0.18728 z M 534.04612,248.62996 c -1.57667,0 -3.15342,-0.56182 -4.37969,-1.87285 -2.45252,-2.6218 -2.45252,-6.74199 0,-9.17663 l 26.97904,-28.84108 c 2.45253,-2.6218 6.3067,-2.6218 8.58416,0 2.27746,2.62178 2.45253,6.74195 0,9.17661 l -26.80285,28.8411 c -1.22629,1.12365 -2.80299,1.87285 -4.3797,1.87285 z M 419.47649,177.84565 c -0.52555,0 -1.05111,0 -1.57667,-0.18728 -3.32851,-0.9364 -5.25552,-4.49465 -4.37971,-8.05288 l 9.81042,-39.3286 c 0.87595,-3.55822 4.20447,-5.61822 7.53296,-4.68197 3.32849,0.93625 5.25549,4.49465 4.3797,8.05287 l -9.81042,39.32861 c -0.87594,2.99642 -3.3285,4.86929 -5.9564,4.86929 z m -194.11008,27.3446 c -2.10223,0 -4.20446,-1.12367 -5.2555,-3.37107 L 182.09616,131.403 c -1.75195,-3.18375 -0.70074,-7.11645 2.27746,-8.98929 2.9782,-1.87287 6.65698,-0.74912 8.40891,2.43463 l 38.01477,70.41617 c 1.75193,3.18375 0.70074,7.11645 -2.27746,8.9893 -1.05111,0.56183 -2.10222,0.9364 -3.15343,0.9364 z m -93.71548,100.01236 c -1.05111,0 -2.10224,-0.37456 -2.9782,-0.93639 L 62.802796,263.62774 c -2.978199,-1.87286 -3.854009,-5.80556 -2.277459,-8.98931 1.751935,-3.18375 5.430729,-4.12 8.408928,-2.43464 l 65.869915,40.63848 c 2.9782,1.87286 3.85402,5.80554 2.27747,8.98929 -1.2263,2.24734 -3.3285,3.37109 -5.43072,3.37109 z m 443.04635,0 c -2.10224,0 -4.20447,-1.12366 -5.25551,-3.37106 -1.75193,-3.18377 -0.70074,-7.11646 2.27748,-8.98931 l 65.86992,-40.63848 c 2.9782,-1.87286 6.65699,-0.74912 8.40893,2.43463 1.75194,3.18377 0.70074,7.11646 -2.27746,8.98931 l -65.86992,40.63848 c -1.05113,0.56183 -2.10224,0.9364 -3.15344,0.9364 z M 481.14196,205.19025 c -1.05112,0 -2.10223,-0.37457 -2.9782,-0.9364 -2.9782,-1.87287 -3.85401,-5.80555 -2.27746,-8.9893 l 38.01475,-70.41617 c 1.75195,-3.18375 5.43074,-4.12001 8.40894,-2.43466 2.9782,1.87287 3.85401,5.80556 2.27745,8.98931 l -38.01475,70.41617 c -1.2263,2.06002 -3.3285,3.37107 -5.43073,3.37107 z M 353.26219,168.66801 c -3.32848,0 -6.13147,-2.99643 -6.13147,-6.55465 V 80.83469 c 0,-3.558234 2.80299,-6.554661 6.13147,-6.554661 3.32849,0 6.13147,2.996427 6.13147,6.554661 v 81.27867 c 0,3.55822 -2.80298,6.55465 -6.13147,6.55465 z m 200.75715,273.24042 h -401.5303 c -3.32848,0 -6.13146,-2.99643 -6.13146,-6.55465 0,-121.91714 92.84897,-220.98264 206.89165,-220.98264 113.87129,0 206.53927,98.69565 206.89164,220.4176 v 0.7491 c 0,3.37109 -2.62775,6.36751 -6.13147,6.36751 z M 158.62356,428.79913 H 547.70862 C 544.38014,317.18115 458.36418,227.47307 353.06999,227.47307 247.9584,227.28579 161.93908,317.17944 158.60754,428.79913 Z',
            $this->frameId()
        );
    }

    public function symbolViewBox()
    {
        return '0 0 700 700';
    }

    protected function renderStyles()
    {
        return sprintf('.foreground-0 {
            transform: translate(5%%, 2%%) scale(1.5);
        }

        #%2$s path {
            transform: scale(0.75);
        }

        #%3$s {
            fill: %4$s;
        }

        .foreground-1 {
            mask: url(#%s);
        }', $this->maskId(), $this->symbolId(), $this->frameId(), $this->qrcode->design->frameColor);
    }

    protected function frameStrokeWidth()
    {
        return 2;
    }

    protected function modifiedViewBox()
    {
        return sprintf(
            '%1$s %1$s %2$s %2$s',
            $this->output->size * -2,
            $this->output->size * 6
        );
    }
}
