<?php

namespace App\Support\QRCodeProcessors\ShapeProcessors;


class StarShapeProcessor extends BaseShapeProcessor
{
    public static $shapeId = 'star';

    public function symbolPath()
    {
        return 'm 208.66614,878.30743 c -14.15748,-5.44372 -24.84712,-20.8797 -24.77423,-35.77432 0.0205,-4.19187 8.51693,-57.05342 18.88092,-117.47012 12.16762,-70.93091 18.84362,-113.22226 18.84362,-119.37115 0,-12.0254 -3.70493,-24.26563 -10.49534,-34.67413 -3.50087,-5.36624 -31.90959,-33.96172 -87.68968,-88.2662 -59.923725,-58.3385 -83.529942,-82.16559 -86.232869,-87.0397 -3.209996,-5.78848 -3.718196,-8.18436 -3.695867,-17.42391 0.02173,-8.99389 0.602363,-11.81325 3.619066,-17.57311 4.78554,-9.13714 14.40707,-17.45342 23.019764,-19.89692 3.746648,-1.06295 57.125816,-9.25023 118.620386,-18.19394 72.45366,-10.5376 114.27745,-17.18515 118.8233,-18.88597 10.45906,-3.91324 22.62284,-12.61229 28.47629,-20.36512 2.85518,-3.78167 28.64408,-54.20591 57.30866,-112.05386 47.68128,-96.22555 52.59284,-105.554638 57.70306,-109.602002 15.69885,-12.433727 35.50143,-12.423121 51.22153,0.02744 5.15858,4.085667 9.98209,13.255559 58.71456,111.621282 47.36196,95.5994 53.81447,107.90884 59.76516,114.01394 8.03348,8.24195 15.83757,13.33942 25.52485,16.67233 3.9708,1.36615 38.38197,7.02392 76.46926,12.57279 38.08727,5.54889 89.4516,13.04172 114.14293,16.65076 24.69134,3.60904 47.07098,7.47177 49.73256,8.58384 7.03736,2.94041 15.53445,11.15476 19.58738,18.93562 2.8792,5.52756 3.54038,8.63599 3.57842,16.82338 0.085,18.30969 3.20853,14.65315 -90.36885,105.79203 -55.57736,54.1291 -84.71654,83.45231 -87.81882,88.37346 -7.59144,12.04229 -10.38203,23.35837 -9.52787,38.63643 0.40461,7.23742 8.96922,60.91242 19.47673,122.06211 20.30643,118.17571 19.94593,114.80727 13.61532,127.21632 -8.43143,16.52694 -29.64172,25.47724 -46.38032,19.57151 -2.86721,-1.0116 -46.47955,-23.52835 -96.91632,-50.0372 -126.69569,-66.58947 -116.48153,-61.91285 -135.22307,-61.91285 -18.73467,0 -9.16046,-4.38487 -137.25491,62.86106 -50.0813,26.29125 -93.10522,48.50562 -95.60871,49.36528 -6.71151,2.30461 -17.27503,1.7839 -25.13691,-1.23908 z';
    }

    protected function frameNode()
    {
        return $this->makeSinglePathUsedSymbol(
            'symbol-frame-' . $this::$shapeId,
            '0 0 700 700',
            'm 348.7062,19.527591 c -13.5274,0.279559 -26.86394,6.430993 -35.68862,16.718959 -3.68314,4.183704 -6.43459,9.078767 -8.7917,14.103737 -23.9969,48.61646 -47.97137,97.243813 -72.0182,145.833573 -4.8513,8.81672 -14.42169,14.65329 -24.40398,15.40104 -54.33397,7.90582 -108.67594,15.76079 -162.996536,23.75554 -13.630194,2.52679 -26.001768,11.19039 -32.938357,23.20778 -7.0202065,11.91289 -8.8610865,26.85074 -4.5184235,40.02261 2.448838,7.68363 6.8755905,14.70126 12.6793365,20.29324 39.705587,38.71934 79.4237,77.43469 119.10552,116.18132 6.85917,7.33313 9.43309,18.21051 7.05948,27.91212 -9.27366,54.14987 -18.59056,108.29283 -27.7876,162.45544 -0.60297,4.85564 -0.45926,9.87405 0.37965,14.61578 0.28626,1.63866 0.70895,3.49221 1.20737,5.17604 0.85133,2.90221 1.98808,5.7625 3.32911,8.38234 1.67782,3.31897 3.83109,6.54469 6.18743,9.31067 0.58855,0.70104 1.2219,1.38987 1.83505,2.04405 4.56587,4.84552 10.11855,8.74927 16.21023,11.43243 0.74307,0.31265 1.77298,0.75464 2.64949,1.07162 12.48626,4.70417 26.91005,3.90269 38.79776,-2.15791 6.88108,-3.53016 13.69971,-7.18275 20.55538,-10.76353 42.66533,-22.42845 85.33179,-44.85639 128.01973,-67.24077 9.06883,-4.20161 20.14693,-3.28923 28.61436,1.92405 48.65609,25.56584 97.28663,51.18176 145.98648,76.6634 2.17213,1.02896 4.46508,1.88442 6.68084,2.54829 3.1503,0.93381 6.41065,1.56746 9.61101,1.84999 2.49154,0.23675 5.1396,0.27952 7.46516,0.12162 13.84724,-0.82171 27.11506,-7.9325 35.63155,-18.8544 6.84299,-8.59156 10.50665,-19.5883 10.37565,-30.55642 0.0233,-3.9666 -0.66462,-7.88179 -1.37366,-11.76956 -9.14811,-53.41097 -18.30695,-106.8207 -27.4042,-160.23992 -1.32514,-9.90763 2.90967,-20.20858 10.44467,-26.68781 39.43964,-38.46449 78.92046,-76.88793 118.29491,-115.41851 5.85862,-6.28466 9.99512,-14.14982 11.89343,-22.52783 0.44965,-1.95766 0.79858,-4.16038 0.98164,-6.24516 1.1958,-12.87827 -2.95625,-26.13231 -11.23569,-36.06165 -4.40807,-5.31243 -9.95054,-9.69856 -16.19103,-12.66293 -5.24425,-2.55834 -11.10793,-4.10675 -16.95011,-4.7987 -52.56649,-7.61798 -105.12832,-15.26916 -157.69192,-22.90601 -4.6409,-0.60138 -9.37259,-1.51792 -13.42804,-3.97865 -6.10447,-3.43076 -10.86394,-9.04416 -13.53994,-15.49004 -24.26079,-49.13931 -48.4812,-98.299103 -72.80814,-147.405132 -6.62006,-12.12843 -18.6205,-21.215731 -32.15633,-24.09619 -3.95845,-0.873351 -8.0211,-1.251625 -12.07276,-1.164517 z m 1.28118,18.975334 c 7.29057,0.05927 14.59574,2.695931 20.05169,7.570069 3.07228,1.487188 4.56116,4.751833 6.07112,7.612511 4.71074,9.02201 9.02804,18.240765 13.60398,27.331382 20.43022,41.370943 40.8164,82.764213 61.30845,124.103963 4.6052,8.43519 11.80031,15.39811 20.30532,19.85407 0.57175,0.28988 1.4631,0.74019 2.16944,1.06591 4.06742,1.87165 8.39699,3.15553 12.81394,3.877 0.77084,0.11287 1.77784,0.28767 2.57179,0.39642 10.47605,1.45952 20.9353,3.04281 31.40584,4.54437 43.97735,6.40358 87.96107,12.7697 131.92659,19.25055 11.09522,2.18684 20.35573,11.36212 22.8729,22.35601 2.36345,9.57969 -0.18841,20.40933 -7.16738,27.50241 -3.64068,3.87831 -7.62734,7.41057 -11.36381,11.19368 -36.47881,35.57528 -72.99091,71.11762 -109.4083,106.75514 -10.01371,10.63861 -14.91053,25.95383 -12.66883,40.41843 0.94876,6.4117 2.20078,12.94271 3.25897,19.40155 8.36177,48.81872 16.7521,97.63346 25.04947,146.46259 1.39825,11.24744 -4.45337,22.94218 -14.14936,28.75343 -8.22565,5.13651 -19.0903,6.15894 -27.90873,1.91849 -4.94004,-2.24926 -9.60459,-5.04316 -14.4597,-7.46354 -45.18937,-23.74678 -90.35333,-47.5437 -135.58812,-71.20285 -1.64044,-0.77318 -3.32767,-1.44423 -5.04517,-2.02588 -0.4654,-0.1491 -1.3003,-0.4285 -1.9212,-0.59552 -5.24951,-1.52548 -10.75572,-2.13959 -16.21394,-1.87698 -0.44968,0.0295 -1.29682,0.0709 -1.89968,0.13462 -6.81267,0.57129 -13.47589,2.63561 -19.44943,5.95502 -11.84906,6.18715 -23.66184,12.43892 -35.50133,18.64521 -37.06818,19.47469 -74.11666,38.98904 -111.21921,58.39697 -10.14586,4.75547 -22.92449,2.95587 -31.44262,-4.29736 -7.67481,-6.28349 -12.13974,-16.56263 -10.73257,-26.47165 0.60275,-5.08066 1.72152,-10.08071 2.48552,-15.13727 8.64873,-50.49607 17.34955,-100.98403 25.90868,-151.49486 1.60345,-12.3843 -1.82564,-25.30332 -9.29259,-35.30376 -2.33089,-3.26352 -5.24624,-6.03054 -8.12599,-8.79739 -38.84498,-37.90825 -77.758319,-75.74746 -116.544499,-113.7153 -7.753825,-8.35442 -9.826012,-21.36019 -5.268886,-31.77598 3.754181,-8.97002 12.043057,-16.11142 21.716132,-17.76283 5.244992,-1.01766 10.572112,-1.51618 15.841324,-2.38602 50.235789,-7.34375 100.488919,-14.57217 150.714859,-21.98106 15.37061,-2.62658 29.10786,-13.18705 35.65968,-27.32952 18.47084,-37.30781 36.84405,-74.66456 55.30203,-111.979033 6.13171,-12.389469 12.25109,-24.786872 18.42055,-37.156774 5.17399,-9.089053 15.49314,-14.829589 25.91307,-14.746218 z',
            $this->frameId()
        );
    }

    public function symbolViewBox()
    {
        return '0 0 700 700';
    }

    protected function renderStyles()
    {
        return sprintf('.foreground-0 {
            transform: translate(-6%%, 2%%) scale(3);
        }

        #%2$s path {
            transform: scale(0.75);
        }

        #%3$s {
            fill: %4$s;
        }

        .foreground-1 {
            mask: url(#%s);
        }', $this->maskId(), $this->symbolId(), $this->frameId(), $this->qrcode->design->frameColor);
    }

    protected function frameStrokeWidth()
    {
        return 0;
    }

    protected function modifiedViewBox()
    {
        return sprintf(
            '%1$s %1$s %2$s %2$s',
            $this->output->size * -2,
            $this->output->size * 6
        );
    }
}
