<?php

namespace App\Support\QRCodeProcessors\ShapeProcessors;


class ShoppingCartShapeProcessor extends BaseShapeProcessor
{
    public static $shapeId = 'shopping-cart';

    protected function modifiedViewBox()
    {
        return sprintf(
            '%1$s %1$s %2$s %2$s',
            -$this->output->size * 1.2,
            $this->output->size * 4
        );
    }

    public function symbolPath()
    {
        return 'M17,18C15.89,18 15,18.89 15,20A2,2 0 0,0 17,22A2,2 0 0,0 19,20C19,18.89 18.1,18 17,18M1,2H4.4L1,2V4H3L6.6,11.59L5.24,14.04C5.09,14.32 5,14.65 5,15A2,2 0 0,0 7,17H19V15H7.42A0.25,0.25 0 0,1 7.17,14.75C7.17,14.7 7.18,14.66 7.2,14.63L8.1,13H15.55C16.3,13 16.96,12.58 17.3,11.97L20.88,5.5C20.95,5.34 21,5.17 21,5A1,1 0 0,0 20,4H5.21L4.27,2ZM7,18C5.89,18 5,18.89 5,20A2,2 0 0,0 7,22A2,2 0 0,0 9,20C9,18.89 8.1,18 7,18Z';
    }

    protected function renderStyles()
    {
        return sprintf('%s
        .foreground-0 {
            transform: translate(5%%, -7%%);
        }

        #%s use {
            transform: translate(-5%%, 7%%);
        }', parent::renderStyles(), $this->maskId());
    }
}
