<?php

namespace App\Support\QRCodeProcessors\ShapeProcessors;


class ShieldShapeProcessor extends BaseShapeProcessor
{
    public static $shapeId = 'shield';

    public function symbolPath()
    {
        return 'm 500.57422,9.5410156 c -48.72514,0.1961863 -97.44195,2.9101414 -145.88241,8.1715634 -33.83615,3.691624 -67.55203,8.634426 -100.92023,15.376557 -24.16912,4.912693 -48.18093,10.757259 -71.6447,18.391062 -13.39113,4.361914 -26.55514,9.447132 -39.2841,15.483446 -7.44294,3.506167 -14.88716,7.167546 -21.53809,12.055887 -4.86657,3.606373 -9.19418,8.28087 -11.22364,14.083524 -2.28721,6.469878 -2.12197,13.484575 -1.35774,20.212105 1.91895,18.10833 4.38649,36.15236 6.78012,54.20239 6.70081,49.7395 13.84657,99.41688 21.12101,149.07572 4.97155,34.00918 10.16918,67.98521 14.98007,102.01779 8.52104,60.19127 16.59006,120.46414 24.47166,180.75027 7.64583,58.87765 15.1313,117.80316 22.17225,176.76124 2.98714,24.98199 5.83115,49.98071 8.55743,74.99249 2.68706,24.42852 5.50359,48.84356 8.45834,73.24074 2.42206,19.80209 4.88771,39.60121 7.73035,59.34762 0.8715,5.6589 1.64172,11.34146 2.83388,16.94408 1.27544,5.2485 3.39863,10.2965 6.23799,14.8916 4.89543,7.8645 12.15408,13.8974 19.70819,19.0951 11.34306,7.74 23.53045,14.1147 35.55729,20.7032 30.84113,16.6684 61.85185,33.0218 92.90665,49.2888 19.6416,10.2626 39.29037,20.5148 59.08633,30.4776 6.12903,3.0624 12.32655,6.0239 18.76623,8.3806 4.79903,1.7226 9.92285,2.7608 15.03665,2.2967 6.64156,-0.5046 12.96647,-2.8284 19.10218,-5.2794 10.29927,-4.2886 20.27895,-9.2944 30.26598,-14.2537 32.60464,-16.4079 65.13012,-32.9734 97.52087,-49.8002 19.28733,-10.0568 38.58026,-20.1101 57.6162,-30.6371 9.11142,-5.0986 18.40301,-10.1432 26.21239,-17.1647 4.6044,-4.1545 8.40102,-9.2105 10.95899,-14.8684 3.60811,-7.8588 5.37217,-16.39195 6.95631,-24.84566 1.54055,-8.71617 2.54934,-17.5144 3.74384,-26.28176 7.25687,-55.96544 13.70881,-112.03477 20.49343,-168.05508 9.95246,-82.57339 20.29108,-165.10495 31.38349,-247.52645 13.01066,-96.8828 26.86307,-193.63544 40.85113,-290.38206 6.59496,-45.5828 13.26068,-91.15547 19.87664,-136.73514 1.17345,-9.59701 1.71044,-19.26887 1.63284,-28.936563 -0.0184,-2.851121 0.0704,-5.714548 -0.0233,-8.557865 -0.2593,-1.200836 -0.99469,-2.283304 -2.04464,-2.933962 C 832.29353,75.201123 827.07566,70.637516 821.21599,66.958165 810.5845,60.12345 799.00606,54.90907 787.26248,50.307303 767.93196,42.838108 747.92968,37.243523 727.77242,32.50435 698.74774,25.745933 669.29532,20.937377 639.72096,17.340619 597.3964,12.240614 554.77005,9.7706325 512.14422,9.558375 c -3.85661,-0.024746 -7.71333,-0.024674 -11.57,-0.017359 z';
    }

    protected function frameNode()
    {
        return $this->makeSinglePathUsedSymbol(
            'symbol-frame-' . $this::$shapeId,
            $this->symbolViewBox(),
            'M 599.95745,7.0974723 C 728.59621,20.705616 804.92893,40.905048 836.61021,69.609675 l 9.99343,9.142818 -0.42525,20.83736 C 845.96577,111.2843 843.8395,133.61 841.50062,149.3444 c -2.55153,15.73433 -6.37878,42.09995 -8.71768,58.47218 -2.33888,16.37219 -5.10302,35.93378 -6.16616,43.58834 -8.71766,56.77112 -17.64795,119.70846 -23.38885,162.65889 -1.27576,9.35552 -5.31566,37.63479 -8.71767,62.72466 -9.99342,71.8676 -10.20605,73.99389 -13.82069,100.99739 -1.70102,14.03333 -4.25251,32.10653 -5.31566,40.39894 -1.06312,8.07977 -3.40201,27.21615 -5.31564,42.52521 -1.701,15.09644 -4.03989,34.23279 -5.31564,42.52519 -1.06314,8.0798 -4.03991,31.04341 -6.3788,51.03025 -2.33887,19.77423 -5.31564,43.80097 -6.37877,53.15652 -1.06313,9.35555 -3.61465,29.98027 -5.31564,45.7146 -1.91365,15.73432 -4.25254,35.9338 -5.31566,44.65146 -1.27576,8.71766 -4.03989,33.59491 -6.59141,55.28276 -5.95353,55.07011 -8.9303,65.48881 -23.17624,80.37261 -11.05656,11.4819 -25.3025,19.349 -150.53922,82.7115 l -72.93073,36.7844 -13.4992,3.4268 c -28.95801,-3.9613 -19.45783,-3.8521 -46.46136,-17.4601 -26.36562,-13.1829 -40.82421,-20.8374 -66.33934,-34.8708 -5.95348,-3.1893 -22.11309,-11.907 -36.14639,-19.1363 -14.03333,-7.4419 -26.57825,-14.0333 -27.64138,-14.8838 -1.27575,-0.8505 -10.84391,-6.1662 -21.2626,-11.6944 -51.03027,-27.2162 -57.40901,-36.5717 -63.57519,-93.55547 -0.63785,-5.95353 -2.76414,-23.17623 -4.46516,-38.27269 -1.9136,-15.30908 -4.67773,-40.61157 -6.37876,-56.34589 -5.10305,-47.20298 -9.35559,-82.92415 -17.01008,-145.64884 -1.91366,-15.30907 -4.25253,-35.29591 -5.31565,-44.65146 -2.12628,-18.49849 -9.14295,-72.7181 -12.75756,-99.93425 -1.27574,-9.35552 -3.18941,-25.08986 -4.46515,-35.08328 -1.06312,-9.78081 -2.55149,-19.77423 -2.97677,-22.32573 -0.63791,-2.33887 -1.91366,-12.3323 -3.18941,-22.32573 -2.12624,-18.49847 -8.29242,-63.57519 -13.82069,-100.57213 -1.701,-11.2692 -4.67778,-30.40551 -6.37875,-42.52517 -1.91365,-11.90709 -4.25253,-27.42878 -5.31569,-34.44544 -1.06312,-7.01667 -3.40199,-23.38885 -5.31563,-36.14641 -1.91361,-12.97019 -4.67774,-32.53179 -6.37877,-43.58834 C 115.38276,216.32163 106.45244,149.3444 103.47567,123.404 100.4989,98.739343 102.62518,89.383753 112.40598,79.815683 143.44939,50.473223 244.2341,23.894973 383.07887,8.7985943 409.44455,5.8217083 576.78121,4.5460493 599.95745,7.0974723 Z M 429.85663,13.263714 c -22.32573,1.063084 -42.73787,2.551527 -45.71458,2.976782 -2.97677,0.42515 -12.9702,1.488338 -22.32579,2.338847 -9.35552,0.850509 -29.555,3.402036 -44.65144,5.740884 -15.30907,2.338952 -32.74442,5.103054 -38.91055,5.953563 -22.32572,3.401932 -72.93072,15.521737 -98.23322,23.601469 -26.57823,8.50509 -58.04691,24.026724 -64.85093,32.106554 -5.95354,7.01655 -7.01666,19.561497 -3.18941,42.950497 1.06311,7.22922 3.40205,24.02676 5.31563,37.42217 6.16618,46.77775 23.60149,167.97459 30.83078,213.68915 9.78079,64.00047 24.02675,167.33668 33.80754,248.77245 1.06317,8.07983 4.03988,31.0434 6.37882,51.03027 2.55149,19.77422 5.95353,48.47874 7.86712,63.7878 1.70103,15.09645 4.25252,34.2328 5.31565,42.52521 1.27574,8.07979 2.97677,24.02674 4.03994,35.0833 1.9136,19.77421 5.52827,50.17974 11.90703,104.18675 1.70102,14.67119 4.03988,35.0833 5.103,45.50197 5.10306,45.07672 11.0566,53.58172 54.21967,76.75802 7.65451,4.0398 20.19949,10.8439 28.06663,15.0964 8.07979,4.2526 26.36561,14.0333 41.03683,21.6879 14.67117,7.6545 30.83077,16.1596 36.14642,19.1364 5.31562,2.9766 25.30249,13.3953 44.65145,23.1762 44.65148,22.9635 45.71462,22.9635 86.32618,2.3388 15.09644,-7.6545 50.39236,-25.7277 78.45901,-39.9737 76.75799,-39.1231 102.48575,-53.1565 110.35291,-60.5984 13.8207,-12.9702 16.79745,-22.751 23.60149,-78.67158 1.701,-15.30908 4.67778,-39.1232 6.37877,-53.15652 1.70102,-14.03333 5.52829,-46.5651 8.50504,-72.29285 2.97677,-25.72775 6.3788,-53.58176 7.44192,-61.66155 1.06313,-8.29242 4.8904,-38.91056 8.50504,-68.04033 3.40202,-29.34242 7.86716,-63.7878 9.56818,-76.54537 1.701,-12.9702 5.52826,-41.67468 8.50503,-63.78783 7.01666,-53.79434 11.26917,-85.05037 14.88382,-109.50239 1.70102,-11.05654 5.52827,-37.84743 8.50504,-59.53532 5.52828,-41.88729 10.63131,-75.90748 13.82069,-96.74481 1.27576,-7.01667 7.01665,-46.77775 12.75758,-88.23979 5.95351,-41.46211 11.26917,-76.75808 11.69441,-78.24642 0.63788,-1.70102 1.06314,-11.26919 1.27575,-21.26262 l 0.21263,-18.498417 -8.50504,-7.654578 C 808.54357,56.85204 761.3406,40.267219 693.5129,27.297009 659.28012,20.918191 597.61856,13.476289 569.12668,12.625885 517.67117,11.137442 465.36517,11.350121 429.85663,13.263714 Z',
            $this->frameId()
        );
    }

    public function symbolViewBox()
    {
        return sprintf('0 0 %s %s', $this->svgWidth(), $this->svgHeight());
    }

    private function svgWidth()
    {
        return '948.83423';
    }

    private function svgHeight()
    {
        return '1162.0956';
    }

    protected function renderStyles()
    {
        return sprintf('.foreground-0 {
            transform: translate(-6%%, -25%%) scale(2.7);
        }

        #%2$s path {
        }

        #%3$s {
            fill: %4$s;
        }

        .foreground-1 {
            mask: url(#%s);
        }', $this->maskId(), $this->symbolId(), $this->frameId(), $this->qrcode->design->frameColor);
    }

    protected function frameStrokeWidth()
    {
        return 3;
    }

    protected function modifiedViewBox()
    {
        return sprintf(
            '%1$s %1$s %2$s %2$s',
            $this->output->size * -2,
            $this->output->size * 6
        );
    }
}
