<?php

namespace App\Support\QRCodeProcessors\ShapeProcessors;


class ShawarmaShapeProcessor extends BaseShapeProcessor
{
    public static $shapeId = 'shawarma';

    public function symbolPath()
    {
        return 'm 47.273859,115.65975 h 5.452282 v 5.45227 c 0,1.49939 -1.226764,2.72615 -2.726141,2.72615 -1.499377,0 -2.726141,-1.22676 -2.726141,-2.72615 z M 77.125104,42.053943 c 0,-0.681535 0.272614,-1.36307 0.817842,-1.908299 1.363071,-1.36307 2.044606,-2.998755 2.044606,-4.907054 0,-3.816597 -2.998756,-6.815352 -6.815352,-6.815352 H 26.8278 c -3.816597,0 -6.815352,2.998755 -6.815352,6.815352 0,1.499378 0.545229,2.862449 1.36307,4.089212 h 8.993777 c 1.499378,0 2.72614,1.226764 2.72614,2.726141 0,1.499378 -1.226762,2.726142 -2.72614,2.726142 h -8.993777 c -0.954149,1.226763 -1.36307,2.589833 -1.36307,4.089211 0,2.31722 1.226764,4.498133 3.271369,5.724896 0.681535,0.408922 1.090457,1.090457 1.226764,1.771992 0.136306,0.681535 0,1.499378 -0.408921,2.044605 -0.95415,1.363072 -1.363071,2.726142 -1.363071,4.089212 0,2.180913 1.090457,4.225519 2.726141,5.452283 h 9.630705 c 1.499378,0 2.726142,1.226763 2.726142,2.726141 0,1.499377 -1.226764,2.726141 -2.726142,2.726141 h -9.085476 c -0.408922,0.817843 -0.545229,1.771992 -0.545229,2.726141 0,2.31722 1.226764,4.498133 3.271369,5.724896 0.681535,0.408922 1.090457,1.090457 1.226764,1.771992 0.136307,0.681535 0,1.499378 -0.408921,2.044605 -0.954149,1.363072 -1.363071,2.726142 -1.363071,4.089212 0,2.180913 1.090457,4.225519 2.726141,5.452282 h 9.630705 c 1.499378,0 2.726142,1.226764 2.726142,2.726141 0,1.499378 -1.226764,2.726135 -2.726142,2.726135 h -9.085476 c -0.408922,0.81785 -0.545229,1.772 -0.545229,2.72615 0,3.81659 2.998755,6.81534 6.815353,6.81534 h 24.53527 c 3.816598,0 6.815353,-2.99875 6.815353,-6.81534 0,-1.36308 -0.408921,-2.72615 -1.226764,-3.952907 -0.408921,-0.681535 -0.681535,-1.36307 -0.408921,-2.044605 0.136307,-0.681536 0.545228,-1.363071 1.226764,-1.771993 2.044605,-1.226763 3.271369,-3.407675 3.271369,-5.724896 0,-0.95415 -0.272614,-1.908299 -0.545229,-2.726141 h -9.221784 c -1.499378,0 -2.726141,-1.226763 -2.726141,-2.726141 0,-1.499377 1.226763,-2.726141 2.726141,-2.726141 h 9.630705 c 1.771992,-1.226764 2.726142,-3.271369 2.726142,-5.452282 0,-1.36307 -0.408921,-2.726142 -1.226764,-3.952904 -0.408921,-0.681535 -0.681535,-1.363072 -0.408921,-2.044607 0.136307,-0.681535 0.545228,-1.36307 1.226764,-1.771991 2.044605,-1.226764 3.271369,-3.407677 3.271369,-5.724896 0,-0.95415 -0.272614,-1.908299 -0.545228,-2.726142 h -9.221784 c -1.499378,0 -2.726142,-1.226763 -2.726142,-2.726141 0,-1.499378 1.226764,-2.726141 2.726142,-2.726141 h 9.630704 c 1.771993,-1.226763 2.726142,-3.271369 2.726142,-5.452282 0,-1.908298 -0.681535,-3.543984 -2.044606,-4.907054 -0.545228,-0.817842 -0.817842,-1.499377 -0.817842,-2.180913 z M 52.726141,9.7491716 V 3.887968 c 0,-1.4993776 -1.226764,-2.7261411 -2.726141,-2.7261411 -1.499377,0 -2.726141,1.2267635 -2.726141,2.7261411 V 9.7491716 C 48.091701,9.4765573 49.04585,9.3402497 50,9.3402497 c 0.954149,0 1.908298,0.1363076 2.726141,0.4089219 z M 50,22.970956 c 2.31722,0 4.089211,-1.908299 4.089211,-4.089212 0,-2.31722 -1.771991,-4.089212 -4.089211,-4.089212 -2.31722,0 -4.089211,1.771992 -4.089211,4.089212 0,2.180913 1.771991,4.089212 4.089211,4.089212 z';
    }

    public function symbolViewBox()
    {
        return sprintf('0 0 %s %s', $this->svgWidth(), $this->svgHeight());
    }

    private function svgWidth()
    {
        return '100';
    }

    private function svgHeight()
    {
        return '125';
    }

    protected function renderStyles()
    {
        return sprintf('.foreground-0 {
            transform: translate(5%%, -2%%) scale(1.3);
        }

        #%2$s path {
        }

        #%3$s {
            fill: transparent;
        }

        .foreground-1 {
            mask: url(#%s);
        }', $this->maskId(), $this->symbolId(), $this->frameId(), $this->qrcode->design->frameColor);
    }

    protected function frameStrokeWidth()
    {
        return 1.5;
    }

    protected function modifiedViewBox()
    {
        return sprintf(
            '%1$s %1$s %2$s %2$s',
            $this->output->size * -2,
            $this->output->size * 6
        );
    }
}
