<?php

namespace App\Support\QRCodeProcessors\ShapeProcessors;

class SearchShapeProcessor extends BaseShapeProcessor
{
    public static $shapeId = 'search';

    public function symbolPath()
    {
        return 'm 325.39648,528.85704 c -40.54354,-5.07151 -76.19299,-23.19575 -104.68239,-53.22068 -30.99681,-32.66752 -46.94011,-72.52652 -46.97291,-117.43454 -0.0348,-47.67174 17.65918,-89.67162 51.9856,-123.3972 50.44104,-49.55813 126.83295,-62.73814 191.86391,-33.10258 26.26254,11.96822 53.88175,35.64557 70.18857,60.17113 20.20586,30.38974 29.10261,59.87681 29.10261,96.45657 0,47.93245 -18.77943,91.3112 -53.91092,124.52927 -23.93499,22.63139 -52.63927,37.37561 -85.68502,44.01293 -13.12709,2.63661 -38.82247,3.61962 -51.88945,1.9851 z';
    }

    protected function frameNode()
    {
        return $this->makeSinglePathUsedSymbol(
            'symbol-frame-' . $this::$shapeId,
            '0 0 700 700',
            'm 516.26431,591.14671 c -1.56448,0 -3.11582,-0.60038 -4.29906,-1.79244 -2.35776,-2.37524 -2.33576,-6.20984 0.0394,-8.5631 l 59.79304,-59.18386 c 2.384,-2.35336 6.21422,-2.33138 8.5631,0.0439 2.36213,2.37524 2.33576,6.20984 -0.0394,8.5631 l -59.78854,59.18386 c -1.18762,1.16574 -2.72584,1.75294 -4.26406,1.74856 z m 29.74338,29.73888 c -1.55134,0 -3.11582,-0.5916 -4.30344,-1.79242 -2.35776,-2.37088 -2.33576,-6.20536 0.0394,-8.56312 l 59.79304,-59.17936 c 2.384,-2.349 6.21422,-2.33138 8.5631,0.0439 2.36214,2.37524 2.33576,6.20984 -0.0394,8.5631 l -59.78854,59.18834 c -1.18762,1.16138 -2.72584,1.73982 -4.26406,1.73982 z M 397.90559,445.17845 h 0.0131 z m 48.71442,-36.33894 c -2.35774,0 -4.70664,0.894 -6.49906,2.68636 l -37.9421,37.9376 c -1.71346,1.72232 -2.6601,4.02734 -2.6601,6.49032 0.004,2.46288 0.94659,4.77238 2.6601,6.4947 l 171.49112,171.49112 c 1.72668,1.71346 4.0362,2.67322 6.49468,2.67322 2.46288,0 4.76802,-0.95973 6.4947,-2.67322 l 37.93314,-37.9421 c 1.72668,-1.72232 2.67322,-4.02734 2.67322,-6.49032 0,-2.46288 -0.94659,-4.77238 -2.67322,-6.49032 L 453.12381,411.52575 c -1.79244,-1.78806 -4.15008,-2.68634 -6.4947,-2.68634 z m 133.54902,239.88114 c -5.69704,0 -11.04796,-2.20876 -15.0624,-6.2186 L 393.63795,471.01093 c -4.00984,-4.00984 -6.2186,-9.35628 -6.2186,-15.05344 0,-5.7014 2.20876,-11.04796 6.2186,-15.05792 l 37.92976,-37.9376 c 8.30014,-8.30014 21.81054,-8.30014 30.11136,0 l 171.4911,171.4799 c 4.01422,4.00984 6.2186,9.35628 6.2186,15.05792 0,5.69704 -2.20876,11.0436 -6.2186,15.05342 l -37.92976,37.9421 c -4.00982,4.00984 -9.36076,6.21862 -15.0624,6.21862 z m -141.8532,-237.4343 c -1.55134,0 -3.09392,-0.59162 -4.27718,-1.77482 l -40.97904,-40.9667 c -2.35774,-2.36214 -2.36212,-6.19662 0,-8.56312 2.37088,-2.3665 6.19224,-2.3665 8.56312,0 l 40.98352,40.9667 c 2.35776,2.36212 2.35776,6.20098 0,8.56312 -1.18324,1.18324 -2.73896,1.77482 -4.28592,1.77482 z m -42.42066,42.41728 c -1.55134,0 -3.09392,-0.58724 -4.27718,-1.77044 l -40.9667,-40.97118 c -2.37088,-2.36214 -2.37524,-6.19662 0,-8.56312 2.36214,-2.3665 6.19224,-2.3665 8.56312,0 l 40.97118,40.97118 c 2.35776,2.36214 2.35776,6.19662 0,8.56312 -1.18762,1.17888 -2.73896,1.77044 -4.28592,1.77044 z m -136.8451,-347.5225 c -43.32826,0 -84.05826,16.87202 -114.70138,47.50504 -30.63752,30.63752 -47.505041,71.36638 -47.505041,114.69016 0,43.32826 16.863041,84.05824 47.505041,114.69016 30.63752,30.63302 71.36638,47.50502 114.69016,47.50502 43.32378,0 84.05824,-16.872 114.69016,-47.50502 30.64088,-30.63304 47.51736,-71.36638 47.51736,-114.69016 0,-43.32826 -16.87648,-84.05824 -47.51736,-114.69016 -30.62406,-30.63302 -71.35742,-47.50504 -114.69016,-47.50504 z m 0,336.50898 c -46.57164,0 -90.34192,-18.12964 -123.26136,-51.0502 -32.91942,-32.92054 -51.050185,-76.69532 -51.050185,-123.26134 0,-46.56266 18.125165,-90.33406 51.050185,-123.26134 32.92504,-32.92728 76.69084,-51.054676 123.26136,-51.054676 46.55816,0 90.32956,18.129636 123.25012,51.054676 32.92504,32.92054 51.05018,76.69532 51.05018,123.26134 0,46.56266 -18.12514,90.33406 -51.05018,123.26134 -32.92056,32.92056 -76.69084,51.0502 -123.25012,51.0502 z m 0,-303.89134 c -34.61236,0 -67.15484,13.48056 -91.62648,37.95558 -24.48398,24.4795 -37.95556,57.0186 -37.95556,91.62646 0,34.60786 13.47158,67.15034 37.95556,91.62648 24.47052,24.475 57.01412,37.95556 91.62648,37.95556 34.59888,0 67.14248,-13.48056 91.62646,-37.95556 24.47054,-24.4795 37.95558,-57.01862 37.95558,-91.62648 0,-34.61234 -13.48504,-67.15034 -37.95558,-91.62646 -24.4795,-24.47502 -57.01412,-37.95558 -91.62646,-37.95558 z m 0,271.27144 c -37.8546,0 -73.42616,-14.73818 -100.1943,-41.5007 -26.76254,-26.76702 -41.50072,-62.34756 -41.50072,-100.18982 0,-37.84112 14.7337,-73.42616 41.50072,-100.1898 26.76702,-26.76254 62.34756,-41.50522 100.1898,-41.50522 37.84114,0 73.42616,14.7382 100.1943,41.50522 26.75468,26.76252 41.50072,62.34754 41.50072,100.1898 0.004,37.84114 -14.74716,73.42616 -41.50072,100.18982 -26.76702,26.76252 -62.35204,41.5007 -100.1898,41.5007 z',
            $this->frameId()
        );
    }

    public function symbolViewBox()
    {
        return '0 0 700 700';
    }

    protected function renderStyles()
    {
        return sprintf('.foreground-0 {
            transform: translate(-8%%, -7%%) scale(1.45);
        }

        #%2$s path {
            transform: scale(0.75);
        }

        #%3$s {
            fill: %4$s;
        }

        .foreground-1 {
            mask: url(#%s);
        }', $this->maskId(), $this->symbolId(), $this->frameId(), $this->qrcode->design->frameColor);
    }

    protected function frameStrokeWidth()
    {
        return 3;
    }

    protected function modifiedViewBox()
    {
        return sprintf(
            '%1$s %1$s %2$s %2$s',
            $this->output->size * -2,
            $this->output->size * 6
        );
    }
}
