<?php

namespace App\Support\QRCodeProcessors\ShapeProcessors;


class SalonShapeProcessor extends BaseShapeProcessor
{
    public static $shapeId = 'salon';

    public function symbolPath()
    {
        return 'M 453.59823,588.56966 C 369.86359,565.97288 297.90313,492.6564 272.89866,404.46508 264.58046,375.12659 262.57911,330.13757 268.36901,302.6417 292.51335,187.98191 406.41003,141.09575 518.82346,199.54084 c 70.38973,36.59646 122.09852,107.04942 137.61185,187.49538 11.22498,58.20825 -3.87865,119.07908 -39.12405,157.67831 -30.7439,33.6694 -67.76051,49.36477 -115.76415,49.08498 -18.67715,-0.1089 -35.95633,-1.9935 -47.94888,-5.22985 z';
    }

    protected function frameNode()
    {
        return $this->makeSinglePathUsedSymbol(
            'symbol-frame-' . $this::$shapeId,
            '0 0 700 700',
            'm 116.34199,279.81945 c -1.02677,-9.68118 -9.86603,-16.66008 -19.483371,-15.54655 -9.681179,1.02678 -16.660079,9.86603 -15.546545,19.48338 1.026774,9.68118 9.86603,16.66008 19.483376,15.54654 9.68118,-1.02677 16.63807,-9.72091 15.54654,-19.48337 z m 470.66342,136.02198 c -8.20323,0.95663 -14.08641,8.34892 -13.20715,16.61507 0.95663,8.20323 8.34892,14.0864 16.61507,13.20715 8.20323,-0.95664 14.0864,-8.34893 13.20715,-16.61507 -1.04012,-8.14167 -8.49128,-14.10446 -16.61507,-13.20715 z M 518.48388,58.486496 c -6.48232,0.707313 -13.24614,3.27494 -19.52513,7.014691 -4.89415,-5.428235 -10.59718,-9.879117 -16.5813,-12.469838 0.70731,6.482319 3.27494,13.246136 7.01469,19.525128 -5.42824,4.894148 -9.87912,10.597183 -12.46984,16.581304 6.48232,-0.707313 13.24614,-3.27494 19.52513,-7.014691 4.89415,5.428236 10.59718,9.879117 16.5813,12.469838 -0.70731,-6.482319 -3.27494,-13.246135 -7.01469,-19.525128 5.42824,-4.894147 9.9627,-10.658821 12.46984,-16.581304 z M 344.39572,537.08775 c -7.08674,-7.88471 -15.39631,-14.48709 -24.13815,-18.22641 0.98992,9.45644 4.78507,19.25943 10.28183,28.44532 -7.88471,7.08674 -14.48709,15.3963 -18.22641,24.13814 9.45644,-0.98992 19.25942,-4.78507 28.44532,-10.28182 7.08674,7.8847 15.3963,14.48708 24.13814,18.2264 -0.98992,-9.45644 -4.78507,-19.25942 -10.28182,-28.44531 7.8847,-7.08674 14.48708,-15.39631 18.2264,-24.13815 -9.45265,0.98713 -19.25942,4.78507 -28.44531,10.28183 z m 91.1005,-501.549617 c -7.51226,-8.461686 -16.3734,-15.295412 -25.58096,-19.32444 1.12906,9.986701 5.12344,20.409764 10.9046,30.148123 -8.46169,7.512262 -15.29541,16.373399 -19.32444,25.580963 9.9867,-1.129059 20.40976,-5.123442 30.14812,-10.904601 7.51226,8.461686 16.3734,15.295412 25.58096,19.32444 -1.12906,-9.986701 -5.12344,-20.409764 -10.9046,-30.148123 8.46169,-7.512262 15.29541,-16.3734 19.32444,-25.580963 -10.04834,1.045481 -20.55102,5.098732 -30.14812,10.904601 z M 220.49424,125.86017 c -24.40586,17.9991 -42.10173,41.99805 -52.89381,69.30966 -19.58983,58.36909 -7.82407,131.80539 37.0572,192.6621 64.52167,87.48809 173.9125,117.56979 248.70465,70.18343 4.69655,-2.95376 10.71204,-2.04494 13.99614,2.40813 3.58921,4.86679 2.20177,11.61621 -2.90856,14.87519 -12.56605,7.99551 -26.07726,14.00954 -40.04536,18.20373 0.2795,3.48625 1.4015,6.73227 3.34726,9.37063 7.41953,10.0605 24.79472,10.48616 43.48334,2.68714 10.71441,28.50739 31.13717,65.00469 53.27463,95.02196 39.28509,53.26858 68.75957,65.26834 85.33433,53.04461 16.49118,-12.16209 13.73528,-43.86507 -25.55052,-97.13462 -22.25787,-30.18053 -51.35852,-60.65908 -75.42798,-79.31725 12.08613,-15.02641 16.27538,-31.09878 9.10026,-40.82788 -3.83003,-5.19333 -10.32658,-7.78755 -18.19299,-8.09885 C 547.67002,363.90031 545.16347,265.04524 487.81908,187.28917 419.5013,94.828507 299.90205,67.309036 220.49288,125.87257 Z m 368.06025,498.9041 c -5.52356,4.07357 -13.34454,2.96655 -17.4184,-2.5574 -4.07357,-5.52356 -2.82133,-13.32259 2.70262,-17.39645 5.44386,-4.01481 13.26095,-2.90492 17.33481,2.61903 4.07746,5.52069 2.82513,13.3198 -2.61903,17.33482 z M 447.49672,425.03324 c -61.10065,45.06117 -155.98742,20.31934 -211.57011,-55.04794 -55.58268,-75.36728 -51.10546,-173.38914 9.91258,-218.38939 61.10065,-45.06117 155.98742,-20.31934 211.5701,55.04794 55.58167,75.37403 51.18516,173.33037 -9.91257,218.38939 z m -317.92277,151.37394 5.12842,-6.59299 30.76482,-40.28697 c 17.82389,-23.44107 10.98716,-49.81043 8.05757,-58.11216 -0.48882,-1.22119 -1.95357,-1.46475 -2.68594,-0.48882 l -53.47295,69.83226 -20.509742,26.85943 -22.706821,29.78859 c -10.987157,-4.63964 -24.173141,-1.71001 -31.742371,8.3013 -9.033808,11.71966 -6.592992,28.32401 5.128415,37.35782 11.719663,9.0338 28.567742,6.59299 37.357817,-4.88294 7.814271,-10.25509 7.080021,-24.17314 -0.975934,-33.45068 l 4.394165,-5.86049 c 4.150651,-5.37171 10.498384,-8.3013 17.336851,-8.79007 1.22119,0 2.44239,-0.24356 3.41828,-0.48882 1.95356,-0.24356 3.90709,-0.97593 5.61544,-1.71001 6.10248,-2.44069 10.98541,-6.34795 14.89255,-11.47419 z M 74.391819,630.1243 c -4.394165,5.86049 -12.940943,6.83672 -18.801429,2.44239 -5.860485,-4.39417 -7.080021,-12.94095 -2.442385,-18.80143 4.394166,-5.86049 12.940943,-7.08002 18.801429,-2.44239 5.617189,4.39591 6.838469,12.94094 2.442385,18.80143 z m 45.171221,-59.333 c -3.17472,1.95357 -7.3255,0.97593 -9.27885,-2.44239 -1.95357,-3.17471 -0.73238,-7.3255 2.44238,-9.27885 3.17472,-1.95356 7.3255,-0.73237 9.27885,2.44239 1.70831,3.42002 0.73068,7.57054 -2.44238,9.27885 z m 34.18362,31.00943 -15.38307,-25.63816 -3.41827,4.63965 c -3.17472,4.15065 -6.83673,7.56879 -10.98716,10.25508 6.34795,1.46475 12.20844,4.88294 15.38307,10.74386 l 3.66183,6.34795 c -9.03381,8.3013 -11.47593,22.21979 -4.88294,33.20695 7.5688,12.69721 23.9281,16.84808 36.62531,9.27885 12.69721,-7.56879 16.84808,-23.9281 9.27885,-36.62531 -6.10422,-10.98716 -18.80143,-15.6268 -30.27736,-12.20844 z m 14.40552,37.11408 c -6.34795,3.66183 -14.651,1.71001 -18.31266,-4.63964 -3.66183,-6.34795 -1.71001,-14.651 4.63964,-18.31266 6.34796,-3.66183 14.651,-1.71001 18.31266,4.63965 3.66353,6.34795 1.71001,14.40551 -4.63964,18.31265 z M 69.752613,465.06536 c -3.907092,7.81427 -13.91849,33.45068 1.221193,58.84467 l 22.219791,37.35781 20.509733,-26.85943 -41.264948,-69.58809 c -0.732375,-0.97593 -2.197126,-0.97593 -2.685943,0.24356 z M 252.635,469.21798 h -43.21831 c -7.56879,0 -13.42971,6.10421 -13.42971,13.42971 v 152.60546 c 0,7.5688 6.10422,13.42972 13.42971,13.42972 H 252.635 c 1.46475,0 2.68594,-1.22119 2.68594,-2.68595 v -11.23263 c 0,-1.46475 -1.22119,-2.68594 -2.68594,-2.68594 h -29.54529 c -1.2212,0 -2.19713,-0.97594 -2.19713,-2.19713 v -6.83672 c 0,-1.2212 0.97593,-2.19713 2.19713,-2.19713 h 29.29981 c 1.46475,0 2.9295,-1.22119 2.9295,-2.9295 v -5.61545 c 0,-1.46475 -1.22119,-2.9295 -2.9295,-2.9295 h -29.29981 c -1.2212,0 -2.19713,-0.97593 -2.19713,-2.19712 v -6.59648 c 0,-1.2212 0.97593,-2.19713 2.19713,-2.19713 h 29.29981 c 1.71001,0 2.9295,-1.22119 2.9295,-2.9295 v -5.61545 c 0,-1.46475 -1.22119,-2.9295 -2.9295,-2.9295 h -29.29981 c -1.2212,0 -2.19713,-0.97593 -2.19713,-2.19712 v -6.83673 c 0,-1.22119 0.97593,-2.19713 2.19713,-2.19713 h 29.29981 c 1.46475,0 2.9295,-1.22119 2.9295,-2.9295 v -5.61544 c 0,-1.46475 -1.22119,-2.9295 -2.9295,-2.9295 h -29.29981 c -1.2212,0 -2.19713,-0.97594 -2.19713,-2.19713 v -6.83672 c 0,-1.2212 0.97593,-2.19713 2.19713,-2.19713 h 29.29981 c 1.46475,0 2.9295,-1.22119 2.9295,-2.9295 v -5.61545 c 0,-1.46475 -1.22119,-2.9295 -2.9295,-2.9295 h -29.29981 c -1.2212,0 -2.19713,-0.97593 -2.19713,-2.19712 v -7.08875 c 0,-1.22119 0.97593,-2.19712 2.19713,-2.19712 h 29.29981 c 1.46475,0 2.9295,-1.22119 2.9295,-2.9295 v -5.61545 c 0,-1.46475 -1.22119,-2.9295 -2.9295,-2.9295 h -29.29981 c -1.2212,0 -2.19713,-0.97593 -2.19713,-2.19713 v -7.08002 c 0,-1.22119 0.97593,-2.19712 2.19713,-2.19712 h 29.29981 c 1.46475,0 2.9295,-1.2212 2.9295,-2.92951 v -5.61544 c 0,-1.46475 -1.22119,-2.9295 -2.9295,-2.9295 h -29.29981 c -1.2212,0 -2.19713,-0.97594 -2.19713,-2.19713 v -7.08002 c 0,-1.22119 0.97593,-2.19713 2.19713,-2.19713 H 252.635 c 1.46475,0 2.68594,-1.22119 2.68594,-2.68594 v -9.76588 c 0,-1.22799 -1.22119,-2.44748 -2.68594,-2.44748 z',
            $this->frameId()
        );
    }

    public function symbolViewBox()
    {
        return '0 0 700 700';
    }

    protected function renderStyles()
    {
        return sprintf('.foreground-0 {
            transform: translate(2%%, -6%%) scale(1.6);
        }

        #%2$s path {
            transform: scale(0.75);
        }

        #%3$s {
            fill: %4$s;
        }

        .foreground-1 {
            mask: url(#%s);
        }', $this->maskId(), $this->symbolId(), $this->frameId(), $this->qrcode->design->frameColor);
    }

    protected function frameStrokeWidth()
    {
        return 3;
    }

    protected function modifiedViewBox()
    {
        return sprintf(
            '%1$s %1$s %2$s %2$s',
            $this->output->size * -2,
            $this->output->size * 6
        );
    }
}
