<?php

namespace App\Support\QRCodeProcessors\ShapeProcessors;


class RealtorShapeProcessor extends BaseShapeProcessor
{
    public static $shapeId = 'realtor';

    public function symbolPath()
    {
        return 'm 670.20564,824.9388 c -26.31352,-0.81775 -29.55254,-1.18507 -37.65413,-4.27013 -23.28371,-8.86638 -40.47219,-24.64407 -50.46435,-46.32234 -8.37372,-18.16703 -8.42186,-18.89682 -8.00344,-121.33677 l 0.37826,-92.60784 3.66812,-10.81757 c 8.99855,-26.53742 29.92193,-47.50399 56.30289,-56.41913 l 10.99982,-3.71726 79.81414,-0.40181 c 89.01,-0.44811 91.11403,-0.28695 109.35621,8.37622 23.61788,11.21608 40.89441,31.71776 48.08453,57.0608 2.25499,7.94814 2.43904,15.72109 2.43904,103.00149 v 94.40459 l -3.12214,10.04304 c -9.43448,30.34813 -33.2654,53.30747 -63.41406,61.09479 -7.04031,1.8185 -17.73272,2.23516 -64.02334,2.49486 -30.56432,0.17147 -68.52702,-0.0908 -84.36155,-0.58294 z m 139.82817,-90.32757 c 8.35517,-3.49102 15.16058,-10.94471 16.7471,-18.34243 1.98505,-9.25596 1.93423,-120.53917 -0.0582,-127.71637 -1.97677,-7.12032 -9.8173,-14.76625 -17.17324,-16.747 -10.73588,-2.89087 -24.0352,2.78719 -29.12338,12.43404 -2.02964,3.84808 -2.25799,10.87451 -2.24977,69.22777 0.009,70.62172 -0.1674,68.84691 7.60499,76.10649 3.63833,3.39827 11.83467,6.76361 16.70084,6.85722 1.68075,0.0323 5.07906,-0.78655 7.55178,-1.81972 z M 104.91926,682.41219 c -6.509543,-2.33723 -11.748859,-6.58476 -16.138994,-13.08393 -9.857277,-14.59276 -3.64557,-35.07431 13.168704,-43.42051 5.03616,-2.49982 10.76113,-2.56963 210.72439,-2.56963 h 205.54759 l 5.35629,2.89027 c 10.94119,5.90392 16.7384,15.09785 16.7384,26.54583 0,12.62645 -5.55589,21.89774 -16.7384,27.93187 l -5.35629,2.89028 -204.20852,0.28482 c -165.51417,0.23085 -205.13408,-0.0475 -209.09317,-1.469 z M 153.32377,467.67716 V 342.10993 l 41.17647,-31.42364 c 22.64706,-17.28301 76.38009,-58.48529 119.40674,-91.56063 43.02666,-33.07535 80.3541,-61.39008 82.94988,-62.92162 5.99528,-3.5373 16.46442,-3.65412 22.94228,-0.256 2.57771,1.35221 25.17456,18.30922 50.21521,37.68226 25.04065,19.37303 78.3692,60.44238 118.50789,91.26522 l 72.97943,56.04152 0.34842,60.52144 0.34841,60.52143 h -7.23061 c -9.71319,0 -26.68899,3.32951 -36.42041,7.14322 -21.57823,8.45644 -42.02869,27.40199 -52.09118,48.25788 -6.43134,13.32984 -7.87596,19.76506 -10.10843,45.02932 -1.65074,18.68094 -3.37465,23.08641 -10.72332,27.4036 -4.60085,2.70289 -6.24885,2.72846 -198.47008,3.078 l -193.8307,0.35247 z';
    }

    protected function frameNode()
    {
        return $this->makeSinglePathUsedSymbol(
            'symbol-frame-' . $this::$shapeId,
            '0 0 700 700',
            'm 304.92188,66.486328 c -5.72934,0.207461 -11.00776,3.008039 -15.39718,6.529406 -7.65544,5.980928 -15.3863,11.867045 -23.07103,17.811162 -20.99553,16.167524 -41.97096,32.363194 -63.04648,48.424694 -6.78199,4.6499 -13.59197,9.26047 -20.37985,13.8988 -0.009,-13.89453 0.0496,-27.78937 -0.0703,-41.68359 -0.52939,-2.17963 -2.94081,-3.47828 -5.07851,-3.06063 -14.40026,-0.004 -28.80082,-0.0589 -43.20079,0.0606 -2.25122,0.48719 -3.52995,2.99007 -3.10531,5.15664 -0.002,23.38951 0.34165,46.78962 -0.49502,70.16914 -0.93673,8.05087 -5.73229,15.33164 -12.18093,20.10178 -18.34742,14.72068 -37.392233,28.64483 -55.85358,43.27971 -4.477354,3.50056 -7.305173,9.3226 -6.567868,15.04212 0.716587,5.29262 4.463731,9.76824 9.019028,12.33606 5.92587,3.40123 13.260865,3.90797 19.740679,1.91032 3.674589,-0.75908 7.669349,2.5409 7.316052,6.35266 0,54.14818 0,108.29636 0,162.44454 -7.52741,0.0959 -15.0633,-0.24571 -22.585293,0.0339 -2.446277,0.28631 -4.152292,2.26044 -5.782142,3.90873 -3.115923,3.28029 -6.382287,6.548 -9.577544,9.81749 -10.285728,10.44573 -20.703896,20.75982 -31.109708,31.0856 14.178036,13.99595 28.028675,28.3201 42.419092,42.09722 0.838678,0.79986 1.716096,1.55684 2.612158,2.29145 5.111737,-0.97513 10.365078,-1.23341 15.541015,-0.66406 1.000433,0.11504 2.261504,0.28506 3.352655,0.48671 6.564729,1.13209 12.819936,3.77728 18.330906,7.50047 4.79211,3.1917 9.23811,7.21612 13.14986,11.5425 1.48347,1.61303 2.86261,3.31704 4.2701,4.99571 6.89549,-6.76718 13.5753,-13.7793 20.93998,-20.04682 2.4892,-1.8535 5.45267,-3.06435 8.52876,-3.47857 0.41719,-0.0594 1.19671,-0.13535 1.76209,-0.14475 4.68946,-0.21202 9.14546,1.98619 12.62983,4.98225 3.26747,2.80273 6.14546,6.01897 9.24702,8.99825 3.34212,3.31711 6.64089,6.67735 9.9138,10.06269 6.85212,-7.12707 13.7373,-14.26062 21.30115,-20.64201 4.14814,-3.06828 9.82365,-4.45412 14.76929,-2.60715 4.96147,1.65263 8.63886,5.56581 12.30004,9.10598 4.7383,4.56705 9.38583,9.20385 14.03968,13.8463 6.33525,-6.18561 12.57166,-12.4769 19.00817,-18.55603 5.00473,-4.00013 11.61018,-5.53474 17.92425,-5.20185 37.89515,-0.003 75.79105,-0.0679 113.68568,0.069 5.27188,0.17373 10.78457,1.91522 14.37286,5.95429 2.34853,2.55926 3.65224,6.03065 3.54425,9.50476 0.53279,9.33059 1.48619,18.63928 2.86713,27.88216 0.37352,2.42005 1.05837,4.78979 2.10585,7.00396 6.33999,17.35206 19.52563,32.08435 36.09378,40.26449 9.92986,4.96065 20.97508,7.56223 32.0575,7.84674 30.60904,0.46238 61.22332,0.32679 91.83466,0.22558 9.2503,-0.0615 18.50534,-0.0751 27.74915,-0.44128 12.89609,-0.85456 25.41967,-5.59389 35.91552,-13.08526 6.89503,-4.76819 13.05408,-10.63958 17.9016,-17.4939 8.59487,-11.84058 13.57444,-26.28242 13.97456,-40.91775 0.218,-6.96438 0.0946,-13.93483 0.16548,-20.90177 0.16137,-31.14206 0.21533,-62.28513 0.0512,-93.42729 -0.0694,-9.95116 -0.11718,-19.90456 -0.28852,-29.85359 -1.10048,-19.73049 -10.27815,-38.97656 -25.27038,-51.91677 -10.5919,-9.28342 -23.86453,-15.45188 -37.79152,-17.55445 -5.27244,-0.85799 -10.62375,-0.97362 -15.95435,-0.94015 -26.61813,-0.0924 -53.23747,-0.33413 -79.85512,-0.0312 0,-24.44206 0,-48.88412 0,-73.32617 5.66169,1.37829 11.3567,3.28154 17.25977,2.94531 5.93844,-0.36623 11.95716,-2.96818 15.57812,-7.81641 2.92231,-3.92189 4.34953,-9.24304 2.79102,-13.99023 -1.6218,-4.69875 -5.44506,-8.16886 -9.29628,-11.0981 -22.4093,-17.31935 -44.90277,-34.52973 -67.35108,-51.79858 -48.04109,-36.89449 -96.0468,-73.83836 -144.14908,-110.64933 -3.98703,-3.009391 -7.91049,-6.10615 -11.9379,-9.059997 -4.87994,-3.355985 -10.65602,-5.764569 -16.668,-5.581495 z m 1.36523,47.705082 c 1.01292,-0.01 1.91777,0.0721 2.97656,0.23437 5.04906,0.83137 9.47041,3.67251 13.36077,6.8627 44.64178,34.93125 89.79256,69.21802 134.69348,103.82262 13.11538,10.06974 26.23076,20.13947 39.34614,30.20921 0,30.47396 0,60.94792 0,91.42188 -7.40287,0.20241 -14.8721,0.4952 -22.08965,2.30245 -11.91061,2.81247 -23.12876,8.55949 -32.274,16.70498 -8.52909,7.55769 -15.34714,17.09728 -19.48834,27.7278 -0.61201,1.51216 -0.8565,3.16758 -1.75738,4.55383 -0.74145,1.44926 -0.77251,3.11553 -1.12049,4.6805 -1.57754,10.05515 -2.3095,20.21545 -3.03772,30.36052 -0.65318,4.6454 -4.22492,8.414 -8.33837,10.3815 -4.06607,1.93436 -8.66504,2.13599 -13.09011,2.02377 -24.99142,-0.0154 -49.98311,-0.008 -74.97464,-0.0148 -59.43019,-0.008 -118.86051,0.0137 -178.29059,-0.10537 -9.20756,-0.0488 -18.41513,-0.0976 -27.62269,-0.14638 -0.001,-63.03451 -0.003,-126.06901 -0.004,-189.10352 59.06792,-45.06898 118.10929,-90.16795 176.8711,-135.63476 4.28642,-3.2972 9.28792,-6.17536 14.83984,-6.28125 z M 495.24219,366.1582 c 35.49011,0.0359 70.98106,-0.0308 106.47094,0.0972 19.06238,0.807 37.51507,10.47426 49.09538,25.62738 4.02211,5.19324 7.2426,10.99936 9.56844,17.14065 0.28605,0.78059 0.66786,1.84013 0.96289,2.73633 1.65474,5.04904 2.70433,10.29754 3.08985,15.59765 0.0179,0.40535 0.0768,1.20557 0.0932,1.61003 0.12496,4.43104 0.0243,8.86586 0.0672,13.29855 0.0253,32.34594 0.0255,64.69197 -0.0226,97.03789 -0.0276,6.15071 -0.009,12.30392 -0.10274,18.45294 -1.09038,19.24831 -11.24973,37.72117 -26.82337,49.06179 -11.74988,8.65556 -26.42267,13.29109 -41.01984,12.82606 -34.47362,0.001 -68.94775,0.0716 -103.421,-0.0746 -2.77763,-0.0678 -5.61615,-0.34067 -8.41728,-0.80834 -2.29009,-0.37968 -4.85123,-0.96537 -7.21036,-1.65515 -5.73899,-1.67166 -11.25175,-4.11817 -16.34823,-7.24134 -1.20396,-0.74508 -2.47534,-1.57611 -3.74135,-2.48271 -11.2662,-7.9662 -19.84184,-19.60341 -24.23561,-32.6734 -2.51594,-7.40058 -3.66902,-15.25001 -3.43955,-23.06146 -0.0298,-40.22443 -0.0456,-80.44923 0.0399,-120.67342 0.0362,-7.94877 1.7189,-16.03244 4.7425,-23.4525 5.04583,-12.48175 13.93207,-23.41446 25.26879,-30.70867 5.78713,-3.76669 12.17444,-6.59891 18.83801,-8.40291 1.00546,-0.26048 2.26569,-0.58072 3.38299,-0.81397 4.32274,-0.9277 8.74092,-1.40705 13.16193,-1.43799 z m 106.51562,62.41992 c -6.37782,0.44139 -12.59057,3.99251 -15.86226,9.53703 -1.69478,3.14611 -1.81004,6.81638 -1.70097,10.30513 -0.34902,29.39804 -0.44618,58.80388 0.15308,88.19886 0.50262,5.43498 4.18127,10.26739 9.00032,12.69113 4.23052,2.34313 9.57368,3.22678 14.10223,1.20721 4.08011,-1.7485 7.42737,-4.83838 10.26854,-8.1835 2.05089,-2.86978 2.43023,-6.52556 2.5864,-9.9492 0.12931,-4.2391 -0.0159,-8.48136 0.0407,-12.72189 -0.0124,-24.8341 0.0468,-49.66958 -0.0939,-74.50273 -0.56189,-7.37652 -6.03157,-14.2497 -13.28976,-16.01129 -1.69087,-0.45827 -3.45398,-0.65434 -5.20438,-0.57075 z M 85.773438,466.74219 c 99.526032,0.006 199.052622,0.008 298.578312,0.0533 10.22059,0.49191 19.57777,8.55931 21.44357,18.64281 1.8511,8.81142 -1.86999,18.63213 -9.3422,23.74334 -0.90477,0.64883 -2.06992,1.36688 -3.16087,1.8959 -4.094,2.05663 -8.75354,2.78599 -13.30162,2.51208 -98.59252,-0.0674 -197.18579,0.0127 -295.777861,-0.0794 -10.361921,-0.55953 -19.769881,-8.89982 -21.450266,-19.16125 -1.678455,-8.92018 2.325721,-18.73608 10.027719,-23.64327 3.816216,-2.55569 8.391508,-3.94566 12.983216,-3.96353 z',
            $this->frameId()
        );
    }

    public function symbolViewBox()
    {
        return '0 0 700 700';
    }

    protected function renderStyles()
    {
        return sprintf('.foreground-0 {
            transform: translate(-5%%, -3%%) scale(1.9);
        }

        #%2$s path {
            transform: scale(0.75);
        }

        #%3$s {
            fill: %4$s;
        }

        .foreground-1 {
            mask: url(#%s);
        }', $this->maskId(), $this->symbolId(), $this->frameId(), $this->qrcode->design->frameColor);
    }

    protected function frameStrokeWidth()
    {
        return 2;
    }

    protected function modifiedViewBox()
    {
        return sprintf(
            '%1$s %1$s %2$s %2$s',
            $this->output->size * -2,
            $this->output->size * 6
        );
    }
}
