<?php

namespace App\Support\QRCodeProcessors\ShapeProcessors;

class PlumberShapeProcessor extends BaseShapeProcessor
{
    public static $shapeId = 'plumber';

    public function symbolPath()
    {
        return 'm 422.47729,186.13104 v -49.54567 h 45.52845 45.52846 v 49.54567 49.54567 H 468.00574 422.47729 Z M 283.36928,108.13008 c -4.59431,-10.771061 -5.97914,-16.424011 -5.99652,-24.47797 -0.0189,-8.752164 4.82289,-24.782486 8.44062,-27.945513 1.43539,-1.254977 11.28654,-2.509994 31.54674,-4.01899 59.18102,-4.407853 72.01969,-4.981708 128.55093,-5.745898 58.3109,-0.788247 102.02541,0.446263 153.99331,4.348816 13.9933,1.050833 31.02776,2.306751 37.85435,2.790929 l 12.41198,0.880322 2.73819,6.16115 c 4.02644,9.059811 6.79855,22.324861 5.85055,27.995991 -1.32845,7.947167 -6.02376,21.555743 -8.1819,23.713883 -1.73883,1.73883 -24.75095,1.98834 -183.38457,1.98834 H 285.79675 Z m 455.29347,767.00208 c -1.56341,-6.23351 -2.84256,-13.94657 -2.84256,-17.14013 0,-3.19356 -0.53701,-6.37892 -1.19336,-7.07859 -1.30512,-1.39126 -4.84543,-29.78689 -6.29411,-50.48302 l -0.91389,-13.05595 h 55.46134 55.46134 l 2.30481,25.1076 c 2.22297,24.2161 5.71763,47.64355 9.46988,63.484 1.77129,7.47767 1.75264,7.59703 -1.41156,9.03874 -2.14022,0.97515 -20.49776,1.461 -55.20294,1.461 h -51.99639 z m 128.65492,-78.72465 c -5.54097,-13.70831 -5.54702,-13.74279 -7.21926,-41.17078 -2.23677,-36.68751 -2.2045,-164.59467 0.0511,-202.57812 l 1.73213,-29.16827 5.43933,-12.34297 c 2.99163,-6.78863 5.57902,-12.51227 5.74975,-12.71919 0.17074,-0.20692 2.77911,5.35583 5.79639,12.36166 5.47428,12.71074 5.4896,12.79425 7.19263,39.20931 2.25682,35.0049 2.23953,174.15611 -0.0259,208.58526 -1.65986,25.22565 -1.72088,25.55073 -7.16356,38.16356 -3.0192,6.99665 -5.60589,12.86928 -5.74821,13.05027 -0.14233,0.18098 -2.7543,-5.84484 -5.80439,-13.39073 z M 728.31563,507.1736 c 1.49411,-20.24511 4.96597,-48.30866 6.28029,-50.76448 0.67334,-1.25817 1.22427,-4.55777 1.22427,-7.33246 0,-2.77468 1.30022,-10.34658 2.88938,-16.82643 l 2.88938,-11.78155 h 55.36026 c 30.44814,0 55.36026,0.45601 55.36026,1.01337 0,0.55735 -1.49114,7.63769 -3.31364,15.7341 -3.56822,15.85165 -8.01085,48.20827 -9.51339,69.28792 l -0.93062,13.05595 h -55.58016 -55.58017 z m -4.03877,232.32903 C 722.80618,706.56617 722.78962,603.66773 724.2496,570.11 l 1.1506,-26.44668 55.75997,-0.002 55.75997,-0.002 -0.86095,22.43164 c -1.10954,28.90874 -1.1065,145.45041 0.005,175.42285 l 0.85637,23.10122 -55.76109,-0.002 -55.76108,-0.002 z M 64.993785,881.44429 C 60.450429,865.33428 56.651863,839.10472 52.291729,793.73506 l -0.611268,-6.36059 h 62.178259 62.17825 l 0.57537,3.01291 c 0.31645,1.6571 1.57267,13.55811 2.79159,26.44668 1.21892,12.88857 3.76226,31.56862 5.65185,41.51123 1.88959,9.94262 3.7146,19.65582 4.05558,21.58491 1.089,6.16107 -2.65801,6.53561 -65.38406,6.53561 H 66.409958 Z M 49.346083,747.53707 c -1.478143,-22.16075 -1.478143,-164.63983 0,-186.80058 l 1.138796,-17.07317 61.797251,2e-5 61.79726,3e-5 v 110.47345 110.47346 l -61.79726,-3e-5 -61.797251,-10e-6 z m 2.95881,-234.32444 c 4.743355,-48.17586 7.714952,-68.8981 12.195464,-85.04429 l 2.136632,-7.69966 h 62.090401 c 34.14972,0 62.0904,0.22031 62.0904,0.48958 0,0.26927 -1.46725,7.04832 -3.26055,15.06456 -4.03246,18.02552 -7.13573,39.60854 -9.21944,64.12065 l -1.59363,18.74702 -62.53342,0.34797 -62.533416,0.34797 z M 451.79507,885.12584 c -22.08999,-3.51257 -66.09834,-17.70158 -94.64683,-30.51569 l -17.0239,-7.64124 -66.95361,-0.6724 -66.95361,-0.6724 -2.26428,-20.37646 c -4.24847,-38.23227 -6.56926,-84.02013 -7.34938,-144.99896 -1.00897,-78.86758 0.96958,-133.06847 7.12449,-195.16978 l 2.28936,-23.09899 h 65.30501 65.305 l 3.75713,-3.23136 3.75711,-3.23135 0.36017,-98.53813 0.36018,-98.53814 h 123.14383 123.14383 l 0.36018,98.53814 0.36017,98.53813 3.75712,3.23135 3.75713,3.23136 h 54.82728 c 42.98326,0 54.82156,0.36159 54.80076,1.67384 -0.0146,0.92061 -0.61301,5.72923 -1.32983,10.68582 -10.47186,72.40958 -10.49297,278.42683 -0.0367,358.56334 0.72073,5.52367 1.32902,10.79627 1.35175,11.71688 0.0324,1.31254 -11.81407,1.67384 -54.88245,1.67384 H 599.1912 l -16.38181,6.87021 c -59.46446,24.93824 -105.12802,36.07823 -131.01428,31.96199 z';
    }

    protected function frameNode()
    {
        return $this->makeSinglePathUsedSymbol(
            'symbol-frame-' . $this::$shapeId,
            '0 0 700 700',
            'm 344.5332,17.054688 c -42.41046,0.368193 -84.7858,2.764502 -127.02459,6.515808 -3.5752,0.357197 -7.0969,0.596617 -10.64533,1.177551 -2.90342,0.820128 -4.81547,3.399854 -6.11395,5.971872 -5.59356,9.456217 -9.42091,20.168177 -9.79474,31.219093 -0.14935,9.487731 2.80417,18.728261 6.73123,27.264645 1.6302,3.454043 3.32726,6.923192 5.62387,9.987431 2.02097,2.190592 5.19153,2.816952 8.05437,2.535472 29.44701,0 58.89401,0 88.34102,0 0,25.08073 0,50.16146 0,75.24219 -17.07487,0.0141 -34.15017,-0.0607 -51.22461,0.0918 -4.12239,0.54902 -7.37211,4.67833 -6.90832,8.81679 -0.052,47.89568 -0.0105,95.79141 -0.0233,143.68711 -21.58985,0 -43.17969,0 -64.76953,0 -1.8513,-7.93653 -3.36526,-16.14915 -7.47767,-23.30151 -1.77986,-3.01995 -4.34183,-5.93573 -7.85436,-6.85278 -2.30258,-0.60462 -4.69514,-0.22263 -7.0418,-0.32613 -35.98107,-0.0457 -71.962418,-0.0568 -107.943335,0.0324 -1.554397,0.0137 -3.209562,-0.071 -4.569501,0.82538 -2.244149,1.37821 -3.640707,3.72622 -4.955118,5.93526 -2.178963,3.97256 -3.610846,8.29911 -4.992733,12.59748 -2.919382,9.72531 -4.636727,19.76153 -6.131391,29.78924 -2.630152,18.30183 -4.010595,36.75826 -5.031719,55.21157 -2.006718,37.36093 -2.207212,74.79221 -1.872512,112.19745 0.363557,30.80313 1.306977,61.62432 4.070983,92.31487 1.220395,13.02919 2.767381,26.0458 5.27819,38.8961 1.698392,8.49126 3.70306,17.0032 7.245051,24.93915 1.543836,3.34922 3.345738,6.84647 6.506666,8.93869 2.622215,1.25766 5.584803,0.63731 8.375105,0.78734 36.258941,0.0181 72.519504,-0.014 108.777434,5e-4 2.69513,-0.10181 5.31624,-1.28397 7.13819,-3.27997 3.35429,-3.39019 5.15544,-7.93243 6.69048,-12.36074 1.59883,-4.86734 2.62696,-9.89465 3.78999,-14.87754 23.70182,0 47.40365,0 71.10547,0 18.72432,8.37377 37.81544,16.00118 57.43788,22.01557 10.84599,3.27814 21.86065,6.1397 33.10277,7.66466 7.26103,0.96342 14.64771,1.14591 21.91775,0.16615 13.4913,-1.61959 26.65991,-5.18394 39.61386,-9.19404 17.2721,-5.39643 34.13784,-12.01408 50.75521,-19.16024 1.60537,-0.62753 3.17414,-1.49972 4.94449,-1.49486 2.32706,-0.066 4.6555,0.066 6.98351,-0.005 24.24101,0 48.48203,0 72.72304,0 2.28126,8.44221 4.18797,17.16666 8.65985,24.78818 1.3915,2.25524 3.06294,4.70091 5.76097,5.4484 1.70917,0.41348 3.49651,0.22556 5.2409,0.29784 34.22274,-0.002 68.44571,0.0365 102.66836,-0.0813 2.68496,-0.27474 4.63724,-2.41696 6.01778,-4.55716 3.26626,-4.85149 4.99354,-10.50965 6.7205,-16.04049 3.03627,-10.56971 4.78044,-21.45557 6.28911,-32.33179 2.54255,-19.06998 3.854,-38.27993 4.81812,-57.48712 1.43333,-30.05523 1.77892,-60.15328 1.66516,-90.23964 -0.12351,-30.4607 -0.76709,-60.93558 -2.82898,-91.33121 -1.30105,-18.36425 -3.02824,-36.73687 -6.44921,-54.8424 -1.66565,-8.47011 -3.6148,-16.95626 -7.00745,-24.92362 -1.44811,-3.34225 -3.19387,-6.69044 -5.91088,-9.1797 -1.4878,-1.23205 -3.48079,-1.54107 -5.35582,-1.44553 -8.92358,-0.0898 -17.84833,-0.0264 -26.77239,-0.0477 -26.04346,0.005 -52.0895,-0.0296 -78.13125,0.0943 -2.70699,0.25673 -4.64122,2.45174 -6.03793,4.58923 -2.78536,4.08959 -4.37808,8.82942 -5.94016,13.4831 -1.27855,4.0749 -2.28245,8.22717 -3.37738,12.35345 -24.97786,0 -49.95573,0 -74.93359,0 -0.007,-48.48112 0.008,-96.96227 -0.0586,-145.44336 -0.43199,-4.19689 -4.59066,-7.59754 -8.79531,-7.1291 -16.43603,-0.0439 -32.87213,-0.0248 -49.3082,-0.0272 0,-25.08138 0,-50.16276 0,-75.24414 30.52345,-0.003 61.04698,0.0278 91.57031,-0.0762 3.26418,-0.40437 5.82211,-2.984081 7.10374,-5.887926 5.18382,-9.072651 9.06792,-19.089746 9.95926,-29.56734 0.66869,-9.583216 -1.87731,-19.120888 -5.78977,-27.800881 -1.83803,-3.988779 -3.75336,-8.008356 -6.47635,-11.480181 -1.90304,-2.114202 -4.87254,-2.64735 -7.58199,-2.768267 -21.02267,-1.944298 -42.07378,-3.594207 -63.1538,-4.762639 -27.76957,-1.563964 -55.58134,-2.446512 -83.39703,-2.328468 z m 6.48438,16.28125 c 14.29558,0.04383 28.58978,0.327353 42.87695,0.816406 14.67292,0.518754 29.46435,1.262932 44.1234,2.192364 16.70663,1.067618 33.37345,2.369588 50.0348,3.883808 0.66514,0.530497 0.69838,1.513968 1.13765,2.212179 3.00186,6.655522 5.69791,13.737266 5.55842,21.151097 -0.10913,6.498028 -2.44928,12.674877 -4.93021,18.591165 -0.47683,1.652514 -1.84064,3.320073 -3.7099,3.236136 -2.73927,0.04033 -5.48034,-0.01903 -8.2208,0.01059 -88.09088,-10e-7 -176.18177,0 -264.27266,0 -2.78019,-6.798271 -5.93719,-13.686375 -6.31445,-21.134766 -0.3151,-7.230866 2.04267,-14.251091 4.94832,-20.772013 0.52408,-1.463594 1.40683,-3.088406 3.09124,-3.376784 1.66834,-0.289256 3.37673,-0.221158 5.05438,-0.457781 29.26036,-2.563513 58.56349,-4.485378 87.93747,-5.516766 14.18992,-0.495754 28.4629,-0.779039 42.68539,-0.83564 z m 34.97265,68.396482 c 0,25.07943 0,50.15886 0,75.23828 -23.32942,-6.5e-4 -46.65885,-0.001 -69.98828,-0.002 0,-25.07878 0,-50.15755 0,-75.23633 23.32943,0 46.65886,0 69.98828,0 z m 58.16211,91.54492 c 0.007,48.47527 -0.009,96.95056 0.0606,145.42578 0.41666,4.20124 4.58343,7.59956 8.78555,7.1388 26.49789,0.0427 52.99583,0.0188 79.49375,0.0233 -1.75563,13.23914 -3.20856,26.51989 -4.14859,39.84331 -2.12745,29.41586 -2.84474,58.91478 -3.06791,88.40114 -0.16459,26.27372 0.0241,52.55385 0.88909,78.81515 0.86974,24.91407 2.26879,49.83663 5.38607,74.58149 0.28759,2.40551 0.59196,4.80938 0.88665,7.21438 -27.00392,-7.6e-4 -54.0079,-0.0245 -81.01172,0.0625 -3.54823,0.67556 -6.58748,2.75849 -9.95852,3.9429 -13.33407,5.67705 -26.77642,10.91861 -40.53351,15.45935 -5.9129,1.95571 -11.74246,3.72859 -17.76314,5.3998 -6.48241,1.7896 -12.93634,3.35482 -19.57295,4.4167 -2.38331,0.37683 -4.96209,0.70783 -7.43771,0.92249 -1.64463,0.1422 -3.2015,0.23439 -4.79737,0.29106 -3.73223,0.0716 -7.46497,-0.20101 -11.16531,-0.67839 -1.15598,-0.16196 -2.55741,-0.36273 -3.80249,-0.5754 -9.07743,-1.57982 -18.02103,-3.95626 -26.7815,-6.68046 -14.05846,-4.41604 -27.89913,-9.51854 -41.47222,-15.25478 -5.33115,-2.2126 -10.60805,-4.56287 -15.90473,-6.84874 -3.29527,-0.90763 -6.72778,-0.23632 -10.08633,-0.42997 -29.29739,-0.0182 -58.59479,-0.025 -87.89219,-0.0192 -2.3816,-18.52797 -4.0281,-37.10263 -5.19601,-55.75538 -0.70718,-11.40724 -1.24907,-22.94976 -1.63587,-34.38707 -1.23452,-35.68406 -1.24997,-71.41048 -0.0548,-107.09584 0.70577,-20.59867 1.7842,-41.23455 3.65483,-61.76723 0.89669,-9.97528 1.96129,-19.90262 3.22994,-29.85777 32.18685,-0.005 64.37382,0.036 96.56055,-0.0742 4.18027,-0.49201 7.51105,-4.66804 7.0235,-8.85586 0.0408,-47.88593 0.0162,-95.77188 0.0214,-143.65782 62.097,0 124.19401,0 186.29101,0 z m -300.2832,122.08204 c -2.70612,10.96402 -5.19233,22.00347 -6.69314,33.20558 -1.90415,13.4498 -3.12574,26.98898 -4.12327,40.5327 -0.12398,0.5062 0.20865,1.45715 -0.5625,1.53515 -6.34582,-0.0674 -12.71479,-0.0104 -19.06953,-0.0293 -25.045179,0 -50.090361,0 -75.135544,0 1.822413,-20.7004 3.413618,-41.47789 7.597791,-61.88313 0.869428,-4.53113 2.262846,-8.93654 3.548694,-13.36101 31.479166,0 62.958329,-10e-6 94.437499,0 z m 412.06055,0 c 28.08333,-10e-6 56.16666,-10e-6 84.25,0 -2.57659,10.46357 -4.99048,20.98624 -6.47361,31.66862 -2.1336,14.45178 -3.36753,29.01591 -4.49124,43.57552 -28.1556,0 -56.31119,0 -84.46679,0 1.18141,-14.40305 2.47002,-28.76836 4.38079,-43.06009 0.23113,-1.51227 0.35157,-3.07775 0.67911,-4.55364 1.78067,-2.38255 2.25163,-5.64283 1.32486,-8.45659 1.17083,-6.48739 2.73717,-12.91222 4.79688,-19.17382 z m 101.13867,61.5957 c 2.19534,5.00757 4.45314,9.9475 6.49975,14.99497 0.63011,3.82781 0.58135,7.72223 0.90069,11.58047 2.72602,45.90738 3.05656,91.94794 1.65354,137.92726 -0.5059,15.66609 -1.30244,31.38805 -2.36648,47.02074 -3.01823,6.86653 -6.03646,13.73307 -9.05469,20.5996 -2.6994,-6.61559 -5.52378,-13.18071 -8.27155,-19.77457 -0.99041,-3.18287 -0.66714,-6.56531 -1.01754,-9.84175 -2.83779,-46.28229 -3.2225,-92.70723 -1.83902,-139.07247 0.49776,-16.06286 1.32883,-32.20068 2.40155,-48.23699 2.96419,-6.73828 5.92838,-13.47656 8.89258,-20.21484 0.73372,1.67253 1.46745,3.34505 2.20117,5.01758 z m -525.11328,29.96094 c -1.92346,42.47209 -2.14844,85.0095 -1.32322,127.51323 0.28418,13.0968 0.7436,26.18746 1.32517,39.27387 -31.5651,10e-6 -63.130207,0 -94.695311,0 -2.316913,-43.85654 -2.792929,-87.83932 -1.461232,-131.75851 0.341763,-11.66735 0.893435,-23.3532 1.459279,-35.02859 31.565104,0 63.130204,0 94.695314,0 z m 496.30273,0 c -1.92346,42.47209 -2.14843,85.0095 -1.32322,127.51323 0.28418,13.0968 0.7436,26.18746 1.32518,39.27387 -28.18295,10e-6 -56.36589,0 -84.54883,0 -2.42307,-45.94971 -2.85783,-92.03429 -1.25229,-138.04206 0.32014,-9.5652 0.77226,-19.16337 1.24643,-28.74504 28.18424,0 56.36849,0 84.55273,0 z M 132.9043,590.01562 c 1.79068,22.65263 3.70375,45.42678 9.13086,67.55469 0.38024,1.66025 0.88762,3.38094 1.18945,5.00391 -2.76497,1.26912 -5.56906,2.96777 -8.73435,2.71353 -13.93001,-0.0683 -27.86046,-0.0139 -41.790651,-0.0319 -14.414843,0 -28.829687,0 -43.244531,0 -3.172304,-9.58239 -5.002394,-19.60696 -6.377314,-29.48117 -2.201169,-15.16138 -3.477578,-30.47376 -4.788702,-45.75907 31.538412,10e-6 63.076828,0 94.615238,0 z m 411.84765,0 c 28.15235,0 56.30469,10e-6 84.45703,0 1.72717,21.89299 3.56999,43.88791 8.59375,65.31836 0.61793,2.53226 1.22144,5.06829 1.82813,7.60352 -2.04783,1.19227 -4.2215,2.63591 -6.7108,2.3575 -7.15046,-0.0794 -14.30226,-0.009 -21.45326,-0.0342 -18.51107,-0.002 -37.02214,-0.003 -55.53321,-0.005 -1.56386,-4.71885 -2.8327,-9.5614 -3.85937,-14.34961 -0.31538,-1.50622 -0.66155,-3.23336 -0.94727,-4.83203 0.92779,-2.85741 0.44504,-6.16986 -1.38476,-8.57227 -1.16821,-8.07169 -2.0989,-16.20141 -2.91992,-24.28906 -0.76565,-7.72484 -1.4423,-15.46365 -2.07032,-23.19727 z',
            $this->frameId()
        );
    }

    public function symbolViewBox()
    {
        return '0 0 700 700';
    }

    protected function renderStyles()
    {
        return sprintf('.foreground-0 {
            transform: translate(-2%%, 18.5%%) scale(2.2);
        }

        #%2$s path {
            transform: scale(0.75);
        }
        
        #%3$s {
            fill: %4$s;
        }

        .foreground-1 {
            mask: url(#%s);
        }', $this->maskId(), $this->symbolId(), $this->frameId(), $this->qrcode->design->frameColor);
    }

    protected function frameStrokeWidth()
    {
        return 3;
    }

    protected function modifiedViewBox()
    {
        return sprintf(
            '%1$s %1$s %2$s %2$s',
            $this->output->size * -2,
            $this->output->size * 6
        );
    }
}
