<?php

namespace App\Support\QRCodeProcessors\ShapeProcessors;

class PizzaShapeProcessor extends BaseShapeProcessor
{
    public static $shapeId = 'pizza';

    public function symbolPath()
    {
        return 'm 569.32215,315.83581 -2.1701,-5.7886 -246.71146,72.34941 72.3494,-247.43496 -7.237,-2.17009 h -1.44841 v -0.72167 l -6.51029,-1.44841 c -23.1544,-6.51029 -47.75189,-9.40698 -71.62721,-9.40698 -150.48676,0 -273.480742,122.9927 -273.480742,273.48075 v 13.74767 13.74769 c 0,150.48676 122.992702,273.48075 273.480742,273.48075 150.48806,0 273.48076,-122.9927 273.48076,-273.48075 0,-4.34018 0,-7.9587 -0.72168,-11.57707 0,-5.06691 0.72168,-10.12866 0.72168,-15.19596 0.72671,-28.21627 -2.89179,-54.26205 -10.12362,-79.58176 z M 306.69122,654.43103 c -143.9753,0 -260.457845,-117.20474 -260.457845,-260.45786 0,-143.97532 117.204745,-260.45785 260.457845,-260.45785 20.97875,0 41.96266,2.17009 62.22049,7.237 l -9.40697,31.83503 c -17.36514,-4.34018 -35.4525,-6.51028 -53.53984,-6.51028 -125.88926,0 -228.624128,102.73615 -228.624128,228.62412 0,125.88926 102.736158,228.62412 228.624128,228.62412 125.88796,0 228.62411,-102.73616 228.62411,-228.62412 0,-20.25783 -2.89179,-40.51437 -7.95869,-59.3291 l 31.83503,-9.40697 c 5.7886,22.42703 9.40697,44.85533 9.40697,68.73065 0,143.25181 -117.20475,259.73435 -261.18135,259.73435 z M 686.52818,231.18701 c -2.17008,-6.51028 -4.34019,-12.29875 -6.51028,-18.80955 h 0.72167 l -2.17009,-6.51028 C 651.80149,116.14746 578.72601,44.528007 488.29054,19.929209 L 482.50194,18.4808 402.19411,293.40853 393.51373,323.79529 688.6993,237.6982 Z M 633.71312,212.37229 C 610.55872,141.47116 553.40528,85.760837 482.50286,64.779509 l 8.68038,-30.38675 c 81.75612,24.597506 146.8693,88.266271 173.63857,169.297601 z';
    }


    public function symbolViewBox()
    {
        return '0 0 700 700';
    }

    protected function renderStyles()
    {
        return sprintf(
            '.foreground-0 {
            transform: translate(-17%%, 7.5%%) scale(1.8);
        }

        #%2$s path {
            transform: scale(1);
        }
        
        #%3$s {
            fill: none;
        }

        .foreground-1 {
            mask: url(#%1$s);
        }',
            $this->maskId(),
            $this->symbolId(),
            $this->frameId(),
            $this->qrcode->design->frameColor
        );
    }

    protected function frameStrokeWidth()
    {
        return 10;
    }

    protected function modifiedViewBox()
    {
        return sprintf(
            '%1$s %1$s %2$s %2$s',
            $this->output->size * -2,
            $this->output->size * 6
        );
    }
}
