<?php

namespace App\Support\QRCodeProcessors\ShapeProcessors;

use SVG\Nodes\Shapes\SVGPath;
use SVG\Nodes\Structures\SVGSymbol;

class PetShapeProcessor extends BaseShapeProcessor
{
    public static $shapeId = 'pet';

    public function symbolPath()
    {
        return 'm 774.9976,478.6838 c -22.92974,-4.16696 -41.25688,-19.30145 -50.62582,-41.80666 -5.1896,-12.46598 -6.88734,-22.53861 -6.36656,-37.77268 0.55319,-16.18263 2.59491,-24.62135 9.16366,-37.87468 20.17899,-40.71384 63.36209,-58.01978 98.7837,-39.58829 4.83137,2.51399 9.33492,6.04914 15.46152,12.13683 7.57966,7.53152 9.2386,9.80969 13.46716,18.49398 7.70209,15.81798 10.69503,32.57735 8.70162,48.72589 -2.92741,23.71489 -12.31578,42.49906 -29.18013,58.38331 -11.09903,10.45399 -23.37442,16.843 -37.1407,19.33071 -8.62591,1.55879 -13.56519,1.55248 -22.26445,-0.0284 z M 588.47787,288.40193 c -3.12466,-0.7212 -8.60819,-2.41929 -12.18561,-3.77354 -25.84613,-9.78411 -46.53686,-35.91651 -54.05329,-68.26927 -12.54615,-54.00203 13.50875,-114.92177 58.51705,-136.820521 12.33488,-6.001524 18.69251,-7.498431 36.0929,-8.498095 12.77269,-0.7338 14.40462,-0.650591 16.57017,0.844873 1.32118,0.912361 5.38476,2.831774 9.0302,4.265362 9.69592,3.812973 17.03801,8.589807 25.225,16.41161 20.61127,19.691881 31.32464,46.776671 31.36471,79.294021 0.0343,27.85934 -6.94419,51.50379 -21.77706,73.78448 -14.03292,21.07911 -33.60166,35.74266 -55.78182,41.79932 -7.67011,2.09445 -25.80503,2.62295 -33.00225,0.96176 z m -294.47565,-0.0612 c -33.26014,-7.31833 -60.5969,-34.04478 -74.10956,-72.45502 -10.52491,-29.91744 -9.61891,-63.688 2.4603,-91.70597 9.56288,-22.1813 27.13481,-40.24506 46.44228,-47.742172 22.19516,-8.618408 44.00581,-6.946462 66.31896,5.083833 17.20546,9.276449 32.76673,26.113189 43.4079,46.965799 9.80434,19.21276 13.7363,35.83521 13.84239,58.51906 0.0789,16.87526 -1.01956,24.80331 -5.31335,38.34812 -5.53229,17.45171 -13.58614,30.75354 -25.60873,42.29571 -11.91497,11.43885 -23.11635,17.46642 -38.56075,20.74989 -7.64243,1.62478 -21.35377,1.59665 -28.87944,-0.0593 z M 113.48801,478.69499 C 99.699419,475.80738 88.63728,469.81532 77.164422,459.01947 60.308253,443.15796 50.91523,424.14069 48.277467,400.53446 c -4.406562,-39.43583 18.952009,-76.74288 53.037303,-84.70832 23.56265,-5.50639 51.09704,3.83972 68.58584,23.28038 29.543,32.84018 32.8064,81.70631 7.68806,115.12109 -14.02237,18.65388 -41.59852,29.17975 -64.10066,24.46738 z M 300.15685,886.6165 c -23.45226,-2.93656 -48.81993,-12.10613 -67.9032,-24.54475 -55.29602,-36.04237 -82.82193,-100.74784 -69.78187,-164.03704 2.61928,-12.71255 6.94002,-24.88054 13.68584,-38.54181 8.12644,-16.45722 17.84694,-29.6226 31.80941,-43.08245 11.56924,-11.15277 22.43459,-18.95268 38.32705,-27.51381 13.77375,-7.4198 20.59895,-12.33287 28.41146,-20.45176 14.60835,-15.18123 21.50203,-30.34226 25.97986,-57.13668 10.79727,-64.60841 59.80997,-115.48714 124.08433,-128.80851 19.67743,-4.07831 44.72677,-3.85901 64.44854,0.56422 43.13316,9.67398 79.04025,35.45944 101.7625,73.07729 10.40124,17.21977 16.34549,33.74625 20.7542,57.70167 5.0233,27.29496 11.41067,40.43308 27.30878,56.17109 9.09949,9.00786 11.0553,10.33724 33.70528,22.90987 18.17373,10.08794 38.74151,28.7589 51.46351,46.7174 7.20939,10.17686 17.02409,29.80719 20.90874,41.81948 23.83854,73.71461 -10.71569,154.34211 -81.27174,189.63632 -23.18845,11.59955 -48.47201,16.87743 -75.76096,15.8149 -29.33596,-1.14222 -54.70652,-9.51705 -81.55608,-26.92169 -18.52341,-12.0074 -30.53935,-15.75718 -50.61602,-15.79561 -20.52594,-0.0393 -30.6115,3.22297 -52.52665,16.99014 -19.21056,12.06814 -36.36708,19.14301 -56.41466,23.26383 -9.19046,1.88912 -38.28537,3.23635 -46.81832,2.1679 z';
    }

    protected function frameNode()
    {
        return $this->makeSinglePathUsedSymbol(
            'symbol-frame-' . $this::$shapeId,
            '0 0 700 700',
            'm 475.14062,43.132812 c -1.55349,0.122624 -2.88041,1.046814 -4.08984,1.953126 -11.78283,-1.678818 -23.9739,-0.07163 -35.01562,4.328124 -0.95163,0.392043 -2.14545,0.880428 -3.17084,1.359791 -2.5071,1.136034 -5.07517,2.521799 -7.33893,3.896069 -6.43951,3.916804 -12.08357,9.005888 -17.24769,14.46351 -12.8437,13.725689 -21.80234,31.072078 -25.39242,49.535218 -0.76946,3.79799 -1.3379,7.58328 -1.72459,11.46999 -0.24682,2.4991 -0.40475,5.03098 -0.48491,7.48441 -0.19896,6.60611 0.1943,13.23213 1.22266,19.76172 1.83198,11.60082 5.77829,23.08851 11.81456,33.26411 1.15586,1.94487 2.29723,3.71151 3.60887,5.57128 4.89962,6.96573 10.91427,13.17976 17.89688,18.07476 1.68459,1.18762 3.67104,2.45515 5.59314,3.53903 10.3453,5.90498 22.38329,8.75737 34.27795,8.1641 1.1635,-0.0585 2.57212,-0.16252 3.82618,-0.29493 2.56242,-0.26893 5.2867,-0.73288 7.63086,-1.26562 4.89967,-1.10963 9.65051,-2.82016 14.20117,-4.93945 0.87792,-0.42293 1.9973,-0.96482 2.95044,-1.47091 15.73031,-8.25464 28.32096,-21.7907 36.70287,-37.34464 11.44603,-21.20201 15.4315,-46.33114 11.12511,-70.0359 -0.72773,-3.98218 -1.68423,-7.84401 -2.89847,-11.733539 -1.19963,-3.800378 -2.57882,-7.411019 -4.25377,-11.052357 -4.80889,-10.465539 -11.67289,-20.060222 -20.43868,-27.573595 -0.96245,-0.821482 -2.18746,-1.820018 -3.19019,-2.581048 -2.83507,-2.174272 -5.97441,-4.188499 -9.03833,-5.83692 -3.04904,-1.635342 -6.23173,-3.015325 -9.50391,-4.138672 -1.31784,-1.74206 -2.96248,-3.311824 -4.93063,-4.283173 -0.67636,-0.257312 -1.40995,-0.365841 -2.13187,-0.314484 z m -255.02539,1.355469 c -6.45864,0.14258 -12.88064,1.362159 -18.97265,3.501953 -0.38401,0.147778 -1.16004,0.418731 -1.55342,0.570967 -4.12659,1.575373 -8.09116,3.569367 -11.82354,5.930987 -0.60179,0.395032 -1.47093,0.952011 -2.15552,1.436133 -7.28938,5.055964 -13.517,11.567933 -18.59229,18.824175 -9.14678,13.14011 -14.31516,28.804704 -15.84272,44.681474 -0.49455,5.05954 -0.60047,10.15424 -0.37236,15.23205 0.0609,0.86428 0.10613,2.01456 0.19103,2.98866 1.33911,17.62045 6.9546,34.96347 16.54146,49.83303 4.28757,6.62632 9.37428,12.7431 15.17376,18.10018 0.99491,0.91138 2.18317,1.96527 3.29204,2.88726 6.7101,5.59066 14.28045,10.20366 22.4775,13.25923 0.86159,0.32362 1.97863,0.71896 2.87,1.00233 10.70425,3.53128 22.32957,4.37151 33.38195,2.05431 1.06444,-0.21649 2.52893,-0.57583 3.57812,-0.85157 4.78605,-1.29876 9.42035,-3.15055 13.78516,-5.5039 0.98778,-0.53116 2.1774,-1.21815 3.21875,-1.85352 11.69735,-7.25587 20.98322,-18.0414 27.28212,-30.21648 3.1683,-6.09407 5.59594,-12.56061 7.3585,-19.19563 0.28686,-1.09227 0.61875,-2.44006 0.88804,-3.63802 1.28276,-5.7412 2.05044,-11.59433 2.33657,-17.4694 0.0596,-1.38828 0.11391,-3.00983 0.11707,-4.49062 0.0326,-4.99675 -0.29039,-9.99401 -0.93347,-14.94883 -0.21752,-1.58625 -0.48034,-3.38139 -0.7804,-5.03958 -2.7135,-15.62928 -8.96046,-30.679105 -18.4425,-43.42118 -7.26312,-9.703519 -16.10903,-18.378863 -26.5896,-24.558774 -2.20707,-1.255519 -4.5019,-2.392318 -6.76426,-3.372882 -3.31944,-1.434767 -6.74908,-2.611756 -10.24941,-3.519696 -1.0996,-0.283307 -2.45059,-0.600351 -3.66062,-0.843531 -5.17763,-1.057718 -10.47669,-1.519675 -15.75931,-1.379126 z m 251.54688,12.365235 c 0.75183,-0.04954 1.34014,0.590969 1.92969,0.99414 1.71037,1.631971 4.19612,1.831336 6.29668,2.710911 6.80212,2.67668 13.06639,6.686154 18.35345,11.733281 7.45441,7.054735 12.90105,16.035609 16.57448,25.571033 6.04112,15.854739 6.99961,33.411519 3.79516,50.005709 -3.12972,16.03595 -10.27142,31.42624 -21.24156,43.60754 -8.3649,9.28139 -19.14366,16.62347 -31.28091,19.89438 -10.54199,2.90344 -22.00815,2.42651 -32.2166,-1.53049 -10.13253,-3.8563 -18.86067,-10.94763 -25.27193,-19.63517 -8.52711,-11.51808 -13.31191,-25.54343 -14.70775,-39.74109 -1.87958,-19.52704 2.07068,-39.73699 11.99359,-56.732595 4.95899,-8.533923 11.38984,-16.22625 18.94846,-22.57648 6.1605,-5.175822 13.32941,-9.198394 21.08005,-11.420428 6.95077,-2.083029 14.24922,-2.858757 21.48976,-2.630654 1.42271,0.01481 2.85063,-0.05173 4.25743,-0.250087 z M 221.75586,57.25 c 15.33427,0.15048 30.41595,6.655223 41.28821,17.427426 10.75182,10.391746 18.79956,23.533756 23.20406,37.822074 3.82765,12.47506 5.02279,25.73313 3.69128,38.70527 -1.57307,14.63288 -6.70808,29.09032 -15.91402,40.6839 -6.9693,8.79808 -16.39863,15.83332 -27.20899,19.09253 -11.50486,3.61069 -24.22932,2.88742 -35.35186,-1.70649 -12.3124,-4.96615 -22.73517,-13.94602 -30.45868,-24.65166 -14.23891,-19.74548 -20.07,-45.18442 -16.45729,-69.20626 2.03657,-13.488 7.2026,-26.6766 15.83523,-37.324318 7.13263,-8.854232 16.85187,-15.766826 27.8503,-18.856532 4.39959,-1.215664 8.94996,-1.971667 13.52176,-1.98594 z m 373.82617,169.56055 c -15.11464,0.16679 -29.85742,6.6334 -40.79602,16.95865 -14.2577,12.95412 -23.50161,31.48054 -25.13171,50.59994 -0.13002,1.51267 -0.2256,2.94011 -0.27123,4.39667 -0.0889,2.60557 -0.0471,5.26123 0.11781,7.78007 0.29791,4.72673 1.06487,9.57889 2.19834,14.07521 2.12386,8.33506 5.58762,16.38187 10.55172,23.42581 7.1649,10.01142 17.58085,17.61872 29.24125,21.53708 0.41555,0.13302 1.17191,0.38269 1.72703,0.55085 4.34164,1.29837 8.83589,2.08204 13.36281,2.30267 0.44429,0.007 1.2631,0.052 1.85153,0.0508 1.18973,0.0236 2.37966,-0.008 3.56839,-0.0567 0.7497,-0.0453 1.80359,-0.11225 2.66797,-0.19336 4.51393,-0.43321 8.97391,-1.38969 13.2793,-2.81055 1.031,-0.35046 2.29695,-0.79455 3.40003,-1.24156 9.76696,-3.83037 18.36545,-10.27551 25.3896,-18.01153 3.1828,-3.50388 6.10774,-7.4541 8.53068,-11.39925 8.71168,-14.14168 12.62331,-31.1084 11.30573,-47.64259 -1.09296,-13.89651 -6.11501,-27.58131 -14.9056,-38.4636 -6.06438,-7.56166 -13.9284,-13.74778 -22.90989,-17.45826 -1.58657,-0.66455 -3.40321,-1.31817 -5.12486,-1.84652 -5.75317,-1.7708 -11.95525,-2.65513 -18.05288,-2.55387 z m -509.589842,0.004 c -16.542221,0.27762 -32.777687,8.22457 -43.126384,21.13747 -1.057663,1.26481 -2.157251,2.73151 -3.041585,3.98363 -8.632647,12.28479 -12.946668,27.39685 -12.70228,42.36831 0.112364,12.00627 2.991411,23.97426 8.335092,34.72544 0.330867,0.644 0.79319,1.5691 1.204179,2.30647 5.767481,10.68921 14.140726,19.99317 24.258712,26.72673 0.982495,0.64037 2.181,1.39868 3.278181,2.03603 10.750303,6.32236 23.478673,9.36248 35.920637,8.12629 2.02128,-0.18262 4.20306,-0.52904 6.01407,-0.9006 15.37217,-3.19105 29.14497,-12.97912 37.52931,-26.21184 3.38946,-5.29012 5.76743,-11.16418 7.62727,-17.14598 3.40907,-11.35867 4.1667,-23.49182 2.2692,-35.19492 -0.11107,-0.61955 -0.26434,-1.56512 -0.41529,-2.30611 -3.03755,-15.66323 -11.06765,-30.3042 -22.56773,-41.35417 -5.9528,-5.66684 -12.80239,-10.48123 -20.38936,-13.69248 -7.62735,-3.20055 -15.928268,-4.74442 -24.194022,-4.60427 z m 1.314453,12.81641 c 12.209326,0.14717 24.108909,5.26722 33.108429,13.42715 8.89746,8.02905 15.43301,18.59955 18.76529,30.1034 3.764,12.72935 3.60473,26.63346 -0.76011,39.19243 -3.13119,9.11962 -8.39722,17.74431 -16.11222,23.68185 -10.50725,8.21063 -24.71638,11.64664 -37.763316,8.66154 -8.794694,-1.92528 -16.826721,-6.57998 -23.419031,-12.64282 -9.911795,-9.01561 -16.904377,-21.18007 -19.662906,-34.29512 -2.988298,-13.81565 -1.774878,-28.74634 4.557111,-41.48461 4.722751,-9.596 12.502588,-17.79952 22.217385,-22.40042 5.925656,-2.8259 12.511893,-4.23743 19.069368,-4.2434 z m 509.984379,0.0117 c 10.58405,0.01 21.01968,4.18272 28.91237,11.19175 9.12183,8.05357 14.80459,19.53645 16.85867,31.43914 2.99949,17.28712 -1.20986,35.72661 -11.47705,49.96265 -6.38668,8.67324 -14.88967,15.9551 -24.86283,20.15552 -14.06925,5.80339 -31.03379,3.83074 -43.38976,-5.06038 -8.64032,-6.13858 -14.84266,-15.37676 -17.92825,-25.46352 -3.0252,-9.37631 -3.96971,-19.42594 -2.6059,-29.19039 1.78392,-13.67756 8.12439,-26.68903 17.73222,-36.57872 7.29113,-7.58427 16.68144,-13.39079 27.07855,-15.44291 3.18347,-0.65453 6.43227,-0.98832 9.68198,-1.01314 z m -257.36914,36.29101 c -5.73327,0.089 -11.45678,0.56961 -17.18555,1.45118 -1.85295,0.28299 -3.81021,0.62877 -5.66016,1 -3.06664,0.61755 -6.01458,1.31731 -8.97469,2.1368 -7.37134,2.0276 -14.72761,4.78712 -21.59969,8.09784 -13.92778,6.67255 -26.59698,15.94777 -37.14643,27.22831 -16.37719,17.46289 -27.69917,39.64459 -32.0397,63.20159 -1.17467,6.03503 -1.61199,12.24225 -3.62535,18.08992 -3.48858,10.73983 -10.00403,20.49953 -18.71633,27.70333 -4.33716,3.64928 -9.20176,6.62907 -14.30662,9.07382 -4.74822,2.32587 -9.31056,5.01714 -13.71228,7.943 -0.63654,0.44381 -1.5244,1.03149 -2.16602,1.48544 -17.80646,12.44883 -32.36086,29.5216 -41.72706,49.13357 -9.00379,18.75271 -13.28834,39.75146 -12.30614,60.53333 0.0702,1.03351 0.1218,2.33462 0.22392,3.47137 0.40615,5.46261 1.21271,10.89227 2.35225,16.24933 0.34221,1.53843 0.73529,3.28912 1.15508,4.89705 3.79711,14.84798 10.27868,28.99779 18.99531,41.601 0.80775,1.14879 1.75553,2.48417 2.65027,3.67929 14.34182,19.28315 34.28353,34.30018 56.71301,42.90079 0.86264,0.32899 1.79998,0.68705 2.69861,1.00303 7.42588,2.68439 15.28702,4.70654 23.1593,5.94878 4.05761,0.63421 8.0226,1.06995 12.1325,1.31289 4.70559,0.28327 9.61267,0.29314 14.39473,0.0136 2.098,-0.12712 4.05906,-0.28548 6.18153,-0.52092 20.24635,-2.1893 39.90866,-9.42705 56.77786,-20.82945 4.45671,-2.98283 9.02399,-5.90936 14.11353,-7.69748 14.15067,-5.22134 30.47964,-4.70791 44.03118,2.06341 6.2097,3.05647 11.68361,7.35387 17.69796,10.74943 7.415,4.2699 15.30387,7.7096 23.44366,10.3415 1.70467,0.54923 3.55684,1.10056 5.3031,1.57738 6.13562,1.68281 12.42276,2.89673 18.69168,3.63014 7.68706,0.90158 15.51219,1.09469 23.22781,0.55956 3.80392,-0.26148 7.74322,-0.72164 11.56257,-1.35301 2.84831,-0.48007 5.84647,-1.07984 8.71449,-1.78543 3.58994,-0.88237 7.27036,-1.94552 10.83434,-3.12864 1.03951,-0.36817 2.33463,-0.79876 3.4602,-1.22677 22.67355,-8.32906 42.96082,-23.1351 57.61568,-42.35718 15.99094,-20.82489 25.43956,-46.6554 26.36162,-72.91605 0.0923,-2.80131 0.0977,-5.75759 -0.006,-8.61719 -0.0657,-1.85712 -0.18307,-3.85286 -0.3393,-5.71989 -0.62067,-7.50182 -1.93036,-14.94904 -3.8686,-22.17933 -5.12266,-19.13856 -14.76761,-37.21614 -28.0845,-51.98278 -10.39944,-11.61094 -22.94315,-21.21394 -36.81411,-28.38222 -3.4304,-1.70761 -6.88311,-3.39954 -10.05718,-5.56291 -13.54931,-9.02111 -23.12723,-23.75675 -25.86634,-39.80356 -0.63092,-4.07867 -1.22508,-8.262 -2.05982,-12.24626 -1.51542,-7.6525 -3.8951,-15.23163 -6.89293,-22.49487 -7.26722,-17.62739 -18.57444,-33.56836 -32.79261,-46.27075 -0.67146,-0.57195 -1.53463,-1.35237 -2.29713,-1.98897 -10.56659,-8.9556 -22.6429,-16.1106 -35.53295,-21.17119 -1.22594,-0.46819 -2.67815,-1.02348 -4.00422,-1.48804 -14.31263,-5.06925 -29.52524,-7.59967 -44.71062,-7.35376 z m 2.13671,12.62891 c 22.06684,0.0356 44.05418,6.66378 62.50692,18.75421 24.38412,15.88954 42.10554,41.55451 48.54097,69.91924 1.57104,6.58198 2.07318,13.36911 3.75699,19.92837 0.71642,2.92355 1.69527,6.00674 2.91734,8.86285 2.7367,6.77875 6.52616,13.12216 11.14302,18.78728 0.50091,0.60594 1.19583,1.44116 1.79617,2.11338 6.61572,7.54832 14.79631,13.71291 23.87959,17.98414 7.02191,3.55314 13.81824,7.60717 19.96946,12.53539 19.41486,15.1871 33.83516,36.75015 40.06181,60.63076 4.90398,18.56494 5.09903,38.39787 0.23854,56.99371 -5.82394,22.56069 -18.62773,43.27945 -36.29465,58.48647 -18.72967,16.16328 -42.78906,26.07994 -67.48926,27.6671 -23.67424,1.55409 -47.74251,-4.76026 -67.72677,-17.5159 -4.97568,-3.20342 -9.80857,-6.71582 -15.28259,-9.0475 -1.01496,-0.46152 -1.93255,-0.84584 -2.91144,-1.2292 -9.04654,-3.57674 -18.86282,-5.1473 -28.57485,-4.69452 -0.9879,0.0556 -2.24425,0.13281 -3.33173,0.24141 -9.63954,0.91238 -19.06661,3.92794 -27.44564,8.78091 -4.77653,2.6843 -9.11815,6.06262 -13.89923,8.74079 -24.30806,13.99555 -53.96837,18.47136 -81.2916,12.04496 -26.88223,-6.24527 -51.42172,-22.38988 -67.46623,-44.88826 -15.37308,-21.39871 -23.33424,-48.18558 -21.36637,-74.52008 1.76879,-24.28802 11.45357,-47.98663 27.45228,-66.37576 10.13349,-11.7348 22.70843,-21.30875 36.61545,-28.1433 6.31757,-3.09836 12.2959,-6.94147 17.48942,-11.70689 12.66003,-11.44647 21.18271,-27.41528 23.44432,-44.34936 0.9629,-6.40294 2.10243,-12.8026 4.07365,-18.98295 6.90462,-22.7711 21.07629,-43.29661 40.0301,-57.69991 18.67936,-14.17831 41.78313,-22.49836 65.24162,-23.22187 1.30708,-0.0391 2.61524,-0.0635 3.92271,-0.0955 z',
            $this->frameId()
        );
    }

    public function symbolViewBox()
    {
        return '0 0 700 700';
    }

    protected function renderStyles()
    {
        return sprintf('.foreground-0 {
            transform: translate(2%%, 25%%) scale(1.7);
        }

        #%2$s path {
            transform: scale(0.75);
        }

        #%3$s {
            fill: %4$s;
        }

        .foreground-1 {
            mask: url(#%s);
        }', $this->maskId(), $this->symbolId(), $this->frameId(), $this->qrcode->design->frameColor);
    }

    protected function frameStrokeWidth()
    {
        return 3;
    }

    protected function modifiedViewBox()
    {
        return sprintf(
            '%1$s %1$s %2$s %2$s',
            $this->output->size * -2,
            $this->output->size * 6
        );
    }
}
