<?php

namespace App\Support\QRCodeProcessors\ShapeProcessors;

use SVG\Nodes\Shapes\SVGPath;
use SVG\Nodes\Structures\SVGSymbol;

class BurgerShapeProcessor extends BaseShapeProcessor
{
    public static $shapeId = 'burger';

    public function symbolPath()
    {
        return 'm 275.84888,822.0978 c -28.75791,-5.10813 -54.53837,-19.20487 -72.63363,-39.71603 -11.55635,-13.09922 -24.43349,-36.43707 -27.53849,-49.90927 -1.01845,-4.41894 -2.4783,-10.14347 -3.2441,-12.72119 -1.31544,-4.42782 7.69732,-4.68675 163.13593,-4.68675 H 500.0969 l 1.27514,26.48103 c 1.91348,39.73721 12.43998,53.89603 41.58575,55.93543 12.87475,0.90088 16.96628,0.0396 24.66402,-5.19189 15.48452,-10.52346 19.94661,-21.29732 21.14151,-51.04685 l 1.05142,-26.17772 h 108.15338 c 123.72644,0 113.04769,-2.71215 102.41663,26.01144 -11.31684,30.57664 -33.57437,55.20765 -63.50943,70.28197 -25.9155,13.0502 -33.20075,13.43629 -248.11396,13.14901 -110.47346,-0.14767 -206.28408,-1.2318 -212.91248,-2.40918 z M 137.49042,599.90802 c -8.18984,-3.30258 -10.5136,-12.57233 -4.74858,-18.94261 4.49042,-4.96185 9.64564,-5.16436 131.47047,-5.16436 h 126.79678 v 13.39072 13.39073 l -123.86418,-0.16977 c -68.1253,-0.0934 -126.46982,-1.22048 -129.65449,-2.50471 z m 399.66883,164.51092 c -3.58314,-3.58314 -4.20851,-13.4066 -4.20851,-66.10806 0,-56.65962 -0.45671,-62.82128 -5.39521,-72.78814 -7.55207,-15.24156 -16.79912,-21.1213 -35.3248,-22.46133 l -15.52102,-1.12269 v -13.06883 -13.06884 h 180.95081 c 119.61244,0 182.70679,0.93978 186.13104,2.77237 2.91992,1.5627 5.18022,5.5864 5.18022,9.22165 0,9.72785 -9.46327,14.78743 -27.65794,14.78743 -16.82263,0 -25.04671,3.26849 -60.8761,24.19398 -38.01333,22.20098 -59.27449,21.02406 -107.43754,-5.94725 -29.08754,-16.28903 -30.88073,-16.90766 -49.00894,-16.90766 -15.57563,0 -20.36967,1.1076 -27.83275,6.43041 -17.14886,12.23088 -18.97949,20.7971 -19.04565,89.12195 -0.05,51.59072 -0.69254,61.37022 -4.26733,64.94501 -2.31468,2.31468 -5.84409,4.20851 -7.84314,4.20851 -1.99904,0 -5.52846,-1.89383 -7.84314,-4.20851 z M 424.63774,623.41175 c -3.44109,-4.91287 -4.16906,-15.44968 -4.16906,-60.34427 0,-59.2077 -1.50188,-67.12387 -15.54141,-81.91629 -12.16199,-12.8142 -24.9974,-17.8322 -45.61251,-17.8322 -23.99449,0 -36.42768,4.60229 -67.20621,24.87716 -22.71527,14.96334 -26.63486,16.63407 -39.0239,16.63407 -12.38557,0 -16.31501,-1.67354 -39.02391,-16.62028 -31.65813,-20.837 -41.42721,-24.89095 -59.98142,-24.89095 -21.43124,0 -32.30733,-11.782 -20.63076,-22.34915 4.50473,-4.07672 32.98646,-4.4323 355.0302,-4.4323 236.23371,0 351.81771,0.90186 355.3128,2.77237 7.02729,3.76089 6.60264,14.67463 -0.77198,19.84 -5.24418,3.67317 -27.46389,4.17027 -186.80057,4.17909 -175.73462,0.01 -181.09519,0.1605 -189.57682,5.33181 -4.80066,2.92699 -11.12325,9.2496 -14.05024,14.05024 -4.91135,8.05522 -5.32257,13.58844 -5.33181,71.73848 -0.008,52.68311 -0.6933,63.98555 -4.17909,68.96222 -2.293,3.2737 -6.44273,5.95219 -9.22165,5.95219 -2.77893,0 -6.92866,-2.67849 -9.22166,-5.95219 z M 166.00847,401.08445 c -8.73282,-4.40316 -13.71833,-9.35047 -18.24968,-18.1098 -5.69278,-11.00443 -6.09205,-14.28182 -4.59489,-37.71704 2.33512,-36.55212 10.2011,-66.56212 25.5636,-97.52925 32.74872,-66.01362 90.48772,-110.32034 164.20703,-126.00625 27.76665,-5.90815 285.28498,-5.65126 314.6198,0.31386 40.47527,8.23049 80.66753,29.17946 112.20509,58.48346 49.48046,45.97615 75.82164,106.10979 75.82164,173.09145 0,25.43119 -4.02236,34.9732 -19.6124,46.52546 -7.55796,5.60048 -7.67754,5.60281 -322.75291,6.3044 L 178.02364,407.1426 Z M 332.35031,252.64527 c 19.56942,-18.89269 23.10934,-28.0321 14.2781,-36.86335 -7.79512,-7.79511 -15.14398,-4.80309 -33.88784,13.79714 -14.93947,14.825 -18.14468,19.53236 -18.14468,26.64836 0,8.98209 5.09858,14.03192 14.32065,14.18373 2.72094,0.0448 13.26613,-7.94986 23.43377,-17.76588 z m 347.30246,13.67824 c 10.75189,-7.53092 7.76266,-16.36913 -12.33307,-36.46484 -20.54212,-20.54214 -29.20832,-23.27236 -36.85017,-11.60941 -6.50344,9.92548 -3.23766,17.20926 15.99739,35.67971 18.03829,17.32127 23.33017,19.29772 33.18585,12.39454 z';
    }

    protected function frameNode()
    {
        return $this->makeSinglePathUsedSymbol(
            'symbol-frame-' . $this::$shapeId,
            '0 0 700 700',
            'm 650.19652,419.52262 c -1.61203,-1.65855 -3.43827,-3.09824 -5.42767,-4.2815 2.66959,-4.71016 4.07194,-10.03073 4.07194,-15.44409 v -20.87199 c -0.014,-5.36708 -1.37433,-10.64102 -3.96472,-15.34151 6.72746,-4.31418 11.54949,-11.04165 13.47854,-18.79434 1.92881,-7.75711 0.81531,-15.95694 -3.10754,-22.92222 -3.92287,-6.96039 -10.35681,-12.1642 -17.98809,-14.53168 7.4915,-9.28052 11.5774,-20.84456 11.58205,-32.77142 v -10.43599 c 0,-52.59027 -20.89107,-103.02297 -58.07781,-140.20017 C 553.58006,86.739778 503.14736,65.849893 450.56305,65.849893 H 283.58709 c -52.59027,0 -103.02297,20.891078 -140.20017,58.077817 -37.18793,37.18316 -58.077811,87.61586 -58.077811,140.20017 v 10.43599 c 0.0048,11.92686 4.090553,23.48994 11.582048,32.77142 -7.621975,2.38537 -14.041485,7.59872 -17.951108,14.56388 -3.904136,6.96982 -4.999021,15.165 -3.060908,22.91745 1.942766,7.74781 6.769444,14.46131 13.501199,18.76571 -2.655633,4.68225 -4.053222,9.96549 -4.071947,15.34152 v 20.87199 c 0.01395,5.36709 1.374331,10.64102 3.964725,15.34151 -8.74477,5.80039 -13.999742,15.59317 -13.999742,26.09 0,10.49193 5.255211,20.28996 13.999742,26.08999 -2.720754,4.87319 -4.090553,10.38471 -3.964725,15.96648 v 20.87199 c -0.0048,6.47593 2.003354,12.79752 5.739798,18.08589 3.736445,5.28789 9.024339,9.28994 15.132789,11.44703 2.18965,28.92262 15.24372,55.93933 36.54031,75.62818 21.29659,19.68885 49.25433,30.59 78.25566,30.50651 h 292.20793 c 29.00133,0.0838 56.96027,-10.81801 78.25566,-30.50651 21.2954,-19.68849 34.35054,-46.70556 36.54031,-75.62818 6.10786,-2.15709 11.39575,-6.15914 15.13279,-11.44703 3.73644,-5.28789 5.74445,-11.61008 5.7398,-18.08589 v -20.87199 c -0.0186,-5.49291 -1.4583,-10.88325 -4.1744,-15.654 6.85794,-4.2815 11.79637,-11.05094 13.77671,-18.88736 2.47387,-10.51054 -0.64293,-21.5566 -8.24635,-29.22079 z m -22.22808,11.58205 c 3.2379,-0.0885 6.33614,1.33712 8.37671,3.84832 2.04522,2.51585 2.80472,5.83294 2.05929,8.98712 -1.63994,5.00832 -6.42464,8.29751 -11.68927,8.03667 h -9.18272 c -8.83804,0.0792 -17.50386,2.45061 -25.14897,6.88585 l -29.32336,16.80017 -0.005,0.005 c -17.94157,10.11457 -39.87148,10.11457 -57.81304,0 l -29.32337,-16.6976 h -0.005 c -6.37347,-3.76912 -13.5012,-6.08925 -20.87199,-6.78339 h -2.92113 c -8.08783,-0.10723 -15.90565,2.92112 -21.81302,8.45125 -7.04901,6.2895 -11.07432,15.29022 -11.06025,24.7339 v 81.40078 c 0,5.76306 -4.67294,10.436 -10.436,10.436 -5.76305,0 -10.43599,-4.67294 -10.43599,-10.436 v -83.48797 c 0.01,-8.04133 -3.07487,-15.77565 -8.60976,-21.60312 -5.5349,-5.82746 -13.10523,-9.3039 -21.13319,-9.70452 h -12.0008 v -20.87199 z m -521.79986,0 h 187.84795 v 20.87199 H 106.16858 c -5.76306,0 -10.435997,-4.67294 -10.435997,-10.43599 0,-5.76306 4.672937,-10.436 10.435997,-10.436 z m 0,-166.97596 c 0,-47.05024 18.69177,-92.17669 51.96053,-125.44665 33.27354,-33.26996 78.39998,-51.96053 125.44665,-51.96053 h 166.97596 c 47.05024,0 92.17669,18.69177 125.44665,51.96053 33.26996,33.27354 51.96053,78.39998 51.96053,125.44665 v 10.436 c 0,8.30216 -3.29849,16.26942 -9.16877,22.13863 -5.87028,5.8692 -13.83753,9.16877 -22.13862,9.16877 H 137.46763 c -8.30217,0 -16.26943,-3.2985 -22.13863,-9.16877 -5.8692,-5.87028 -9.16877,-13.83754 -9.16877,-22.13863 z m 0,62.61599 h 521.79986 c 5.76306,0 10.436,4.67294 10.436,10.43599 0,5.76306 -4.67294,10.436 -10.436,10.436 H 365.50609 c -8.02737,0.40067 -15.59794,3.87623 -21.13319,9.70452 -5.53525,5.8283 -8.61906,13.56203 -8.60976,21.60311 v 83.48798 c 0,5.76306 -4.67294,10.436 -10.43599,10.436 -5.76306,0 -10.436,-4.67294 -10.436,-10.436 v -71.17469 c 0,-11.0556 -4.1837,-21.70091 -11.71718,-29.79328 -7.53348,-8.09726 -17.85331,-13.03605 -28.88088,-13.828 h -6.7834 c -13.15174,0.67555 -25.88485,4.89192 -36.83847,12.21072 l -23.69031,15.75656 c -5.13415,3.41037 -11.15817,5.23196 -17.32137,5.23196 -6.1632,0 -12.18805,-1.82159 -17.32137,-5.23196 l -29.01088,-19.30719 h -0.005 c -7.20275,-4.82203 -15.48106,-7.79444 -24.10537,-8.66092 h -13.04559 c -5.76305,0 -10.435996,-4.67294 -10.435996,-10.436 0,-5.76306 4.672946,-10.436 10.435996,-10.436 z M 513.17247,618.95262 H 220.96455 c -23.07608,-0.0372 -45.33636,-8.56778 -62.52295,-23.96582 -17.1866,-15.39805 -28.10683,-36.58682 -30.66991,-59.52216 h 249.7364 v 31.30799 c 0,11.18608 5.96807,21.51963 15.65399,27.11451 9.68592,5.59072 21.6222,5.59072 31.30799,0 9.68592,-5.59536 15.654,-15.92831 15.654,-27.11451 v -31.30799 h 166.35576 c -2.56702,22.95442 -13.5012,44.15321 -30.71165,59.55555 -17.21045,15.40234 -39.49339,23.92408 -62.58855,23.93243 z M 231.39697,201.51166 c 2.77204,0.0139 5.44163,-1.07156 7.40765,-3.02835 l 20.87199,-20.872 c 4.09521,-4.09055 4.09521,-10.72486 0,-14.81553 -4.09055,-4.09521 -10.72486,-4.09521 -14.81554,0 l -20.87199,20.87199 c -1.97533,1.95672 -3.08882,4.62631 -3.08882,7.40765 0,2.78134 1.11348,5.45093 3.08882,7.40765 1.96602,1.95672 4.63561,3.0423 7.40765,3.02835 z m 263.92935,-3.02943 c 1.95672,1.97533 4.62631,3.08882 7.40765,3.08882 2.78134,0 5.45093,-1.11348 7.40765,-3.08882 1.97533,-1.95672 3.08882,-4.6263 3.08882,-7.40765 0,-2.78134 -1.11348,-5.45093 -3.08882,-7.40764 l -20.87199,-20.872 c -4.09056,-4.0952 -10.72487,-4.0952 -14.81554,0 -4.09521,4.09055 -4.09521,10.72487 0,14.81554 z',
            $this->frameId()
        );
    }

    public function symbolViewBox()
    {
        return '0 0 700 700';
    }

    protected function renderStyles()
    {
        return sprintf('.foreground-0 {
            transform: translate(7%%, -17%%) scale(1.5);
        }

        #%2$s path {
            transform: scale(0.75);
        }

        #%3$s {
            fill: %4$s;
        }

        .foreground-1 {
            mask: url(#%s);
        }', $this->maskId(), $this->symbolId(), $this->frameId(), $this->qrcode->design->frameColor);
    }

    protected function frameStrokeWidth()
    {
        return 3;
    }

    protected function modifiedViewBox()
    {
        return sprintf(
            '%1$s %1$s %2$s %2$s',
            $this->output->size * -2,
            $this->output->size * 6
        );
    }
}
