<?php

namespace App\Support\QRCodeProcessors\ShapeProcessors;

class BuilderShapeProcessor extends BaseShapeProcessor
{
    public static $shapeId = 'builder';

    public function symbolPath()
    {
        return 'M 310.32999,14.060262 H 688.95264 V 392.68291 H 310.32999 Z M 6.6989714,343.76662 55.768478,313.57608 l 15.09527,24.53517 -49.069504,30.19054 z m 50.4144176,271.8054 h 24.965634 v 28.80776 H 57.113389 Z M 416.24747,469.60718 h 24.96564 v 28.80776 h -24.96564 z m -65.29486,0 h 57.61554 v 28.80776 h -57.61554 z m -65.29486,0 h 57.61554 v 28.80776 h -57.61554 z m -65.30309,0 h 57.61553 v 28.80776 h -57.61553 z m 195.89281,72.98242 h 24.96564 v 28.80776 h -24.96564 z m -65.29486,0 h 57.61554 v 28.80776 h -57.61554 z m -65.29486,0 h 57.61554 v 28.80776 h -57.61554 z m -65.30309,0 h 57.61553 v 28.80776 h -57.61553 z m -65.29486,0 h 57.61553 v 28.80776 H 155.0598 Z m 261.18767,72.98242 h 24.96564 v 28.80776 h -24.96564 z m -65.29486,0 h 57.61554 v 28.80776 h -57.61554 z m -65.29486,0 h 57.61554 v 28.80776 h -57.61554 z m -65.30309,0 h 57.61553 v 28.80776 h -57.61553 z m -65.29486,0 h 57.61553 v 28.80776 H 155.0598 Z M 383.60416,506.1025 h 57.61553 v 28.80777 h -57.61553 z m -65.30309,0 h 57.61553 v 28.80777 h -57.61553 z m -65.29486,0 h 57.61553 v 28.80777 h -57.61553 z m -65.29486,0 h 57.61553 v 28.80777 h -57.61553 z m 195.89281,72.97419 h 57.61553 v 28.80777 h -57.61553 z m -65.30309,0 h 57.61553 v 28.80777 h -57.61553 z m -65.29486,0 h 57.61553 v 28.80777 h -57.61553 z m -65.29486,0 h 57.61553 v 28.80777 h -57.61553 z m -65.3031,0 h 57.61554 v 28.80777 h -57.61554 z m -65.294861,0 h 57.615541 v 28.80777 H 57.113389 Z m 326.490771,72.98242 h 57.61553 v 28.80777 h -57.61553 z m -65.30309,0 h 57.61553 v 28.80777 h -57.61553 z m -65.29486,0 h 57.61553 v 28.80777 h -57.61553 z m -65.29486,0 h 57.61553 v 28.80777 h -57.61553 z m -65.3031,0 h 57.61554 v 28.80777 H 122.40825 Z M 89.764937,615.57202 h 57.615533 v 28.80776 H 89.764937 Z m -32.651548,36.48709 h 57.615541 v 28.80777 H 57.113389 Z M 197.47306,263.15426 c 0,23.866 -19.34894,43.21165 -43.21165,43.21165 -23.866,0 -43.21165,-19.34565 -43.21165,-43.21165 0,-23.866 19.34565,-43.21165 43.21165,-43.21165 23.86271,0 43.21165,19.34565 43.21165,43.21165 m -47.6645,312.08688 v -94.97509 h 8.90242 v 58.48388 h 25.15494 v -36.48874 h 22.3359 V 372.01716 c 4.74554,3.99967 9.93785,7.81926 15.74468,10.94778 6.91254,3.6878 14.84093,6.55566 23.8306,6.58784 0.18648,0.003 0.37296,0.007 0.55944,0.007 10.47533,0 21.63134,-5.03494 29.53455,-13.99564 8.19219,-9.08268 14.1051,-21.44203 18.81805,-38.17358 2.27631,-8.17614 -2.49821,-16.64842 -10.67122,-18.92753 -0.73626,-0.20255 -1.47257,-0.33438 -2.2056,-0.42761 v -5.90304 h 5.76155 c 10.56175,0 16.17186,-8.09252 12.45895,-17.98264 l -15.31997,-40.85517 c -3.71028,-9.89012 -9.78065,-9.89012 -13.4878,0 l -15.31997,40.85517 c -3.71027,9.89012 1.89695,17.98264 12.45895,17.98264 h 5.76155 v 6.8997 c -4.26009,1.72658 -7.70673,5.32755 -9.03493,10.09918 -3.85177,13.91827 -8.47854,22.02395 -11.94453,25.74345 -3.61702,3.68459 -4.97707,3.76813 -7.37232,3.95143 -2.04806,0.0322 -5.34038,-0.79093 -9.29832,-2.93543 -5.93514,-3.14119 -12.85732,-9.00283 -18.69953,-15.0146 -5.90946,-6.03161 -10.77082,-12.03424 -13.88288,-15.81876 -2.10272,-2.54965 -4.85806,-4.23754 -7.82567,-5.04136 -1.4822,-0.49835 -3.06087,-0.77485 -4.71023,-0.77485 h -74.19893 c -2.29565,0 -4.46266,0.53692 -6.40455,1.46936 -3.37915,1.43397 -6.26634,4.06395 -7.93497,7.6585 0,0 -0.0514,0.11253 -0.21863,0.45976 -1.21857,2.58176 -7.671344,15.65497 -15.82781,27.26779 -4.034983,5.79695 -8.55591,11.19223 -12.403804,14.51994 -1.90658,1.66863 -3.613811,2.80357 -4.742335,3.34376 -0.482275,0.23792 -0.852051,0.37295 -1.086711,0.44369 -0.530499,-0.4244 -1.774723,-1.6269 -3.334129,-4.3308 -2.048067,-3.50451 -4.481912,-9.35923 -6.697147,-17.72171 -0.160755,-0.60446 -0.363315,-1.18318 -0.594806,-1.75226 l -27.039793,16.63855 c 3.211901,10.11811 6.986542,18.12667 12.040823,24.61829 3.092967,3.92568 6.790403,7.30804 11.175768,9.70986 4.317955,2.38562 9.295031,3.64279 14.008805,3.64279 0.05144,0 0.102885,-0.003 0.154327,-0.003 5.980164,-0.007 11.281945,-1.76509 15.760318,-4.08971 7.362692,-3.88716 13.101775,-9.28516 18.297054,-15.10762 V 575.2589 Z';
    }

    protected function frameNode()
    {
        return $this->makeSinglePathUsedSymbol(
            'symbol-frame-' . $this::$shapeId,
            '0 0 700 700',
            'm 6.6989714,343.76662 49.0695066,-30.19054 15.09527,24.53517 -49.069504,30.19054 z m 50.4144176,271.8054 h 24.965634 v 28.80776 H 57.113389 Z M 416.24747,469.60718 h 24.96564 v 28.80776 h -24.96564 z m -65.29486,0 h 57.61554 v 28.80776 h -57.61554 z m -65.29486,0 h 57.61554 v 28.80776 h -57.61554 z m -65.30309,0 h 57.61553 v 28.80776 h -57.61553 z m 195.89281,72.98242 h 24.96564 v 28.80776 h -24.96564 z m -65.29486,0 h 57.61554 v 28.80776 h -57.61554 z m -65.29486,0 h 57.61554 v 28.80776 h -57.61554 z m -65.30309,0 h 57.61553 v 28.80776 h -57.61553 z m -65.29486,0 h 57.61553 v 28.80776 H 155.0598 Z m 261.18767,72.98242 h 24.96564 v 28.80776 h -24.96564 z m -65.29486,0 h 57.61554 v 28.80776 h -57.61554 z m -65.29486,0 h 57.61554 v 28.80776 h -57.61554 z m -65.30309,0 h 57.61553 v 28.80776 h -57.61553 z m -65.29486,0 h 57.61553 v 28.80776 H 155.0598 Z M 383.60416,506.1025 h 57.61553 v 28.80777 h -57.61553 z m -65.30309,0 h 57.61553 v 28.80777 h -57.61553 z m -65.29486,0 h 57.61553 v 28.80777 h -57.61553 z m -65.29486,0 h 57.61553 v 28.80777 h -57.61553 z m 195.89281,72.97419 h 57.61553 v 28.80777 h -57.61553 z m -65.30309,0 h 57.61553 v 28.80777 h -57.61553 z m -65.29486,0 h 57.61553 v 28.80777 h -57.61553 z m -65.29486,0 h 57.61553 v 28.80777 h -57.61553 z m -65.3031,0 h 57.61554 v 28.80777 h -57.61554 z m -65.294861,0 h 57.615541 v 28.80777 H 57.113389 Z m 326.490771,72.98242 h 57.61553 v 28.80777 h -57.61553 z m -65.30309,0 h 57.61553 v 28.80777 h -57.61553 z m -65.29486,0 h 57.61553 v 28.80777 h -57.61553 z m -65.29486,0 h 57.61553 v 28.80777 h -57.61553 z m -65.3031,0 h 57.61554 v 28.80777 H 122.40825 Z M 89.764937,615.57202 h 57.615533 v 28.80776 H 89.764937 Z m -32.651548,36.48709 h 57.615541 v 28.80777 H 57.113389 Z M 197.47306,263.15426 c 0,23.866 -19.34894,43.21165 -43.21165,43.21165 -23.866,0 -43.21165,-19.34565 -43.21165,-43.21165 0,-23.866 19.34565,-43.21165 43.21165,-43.21165 23.86271,0 43.21165,19.34565 43.21165,43.21165 m -47.6645,312.08688 v -94.97509 h 8.90242 v 58.48388 h 25.15494 v -36.48874 h 22.3359 V 372.01716 c 4.74554,3.99967 9.93785,7.81926 15.74468,10.94778 6.91254,3.6878 14.84093,6.55566 23.8306,6.58784 0.18648,0.003 0.37296,0.007 0.55944,0.007 10.47533,0 21.63134,-5.03494 29.53455,-13.99564 8.19219,-9.08268 14.1051,-21.44203 18.81805,-38.17358 2.27631,-8.17614 -2.49821,-16.64842 -10.67122,-18.92753 -0.73626,-0.20255 -1.47257,-0.33438 -2.2056,-0.42761 v -5.90304 h 5.76155 c 10.56175,0 16.17186,-8.09252 12.45895,-17.98264 l -15.31997,-40.85517 c -3.71028,-9.89012 -9.78065,-9.89012 -13.4878,0 l -15.31997,40.85517 c -3.71027,9.89012 1.89695,17.98264 12.45895,17.98264 h 5.76155 v 6.8997 c -4.26009,1.72658 -7.70673,5.32755 -9.03493,10.09918 -3.85177,13.91827 -8.47854,22.02395 -11.94453,25.74345 -3.61702,3.68459 -4.97707,3.76813 -7.37232,3.95143 -2.04806,0.0322 -5.34038,-0.79093 -9.29832,-2.93543 -5.93514,-3.14119 -12.85732,-9.00283 -18.69953,-15.0146 -5.90946,-6.03161 -10.77082,-12.03424 -13.88288,-15.81876 -2.10272,-2.54965 -4.85806,-4.23754 -7.82567,-5.04136 -1.4822,-0.49835 -3.06087,-0.77485 -4.71023,-0.77485 h -74.19893 c -2.29565,0 -4.46266,0.53692 -6.40455,1.46936 -3.37915,1.43397 -6.26634,4.06395 -7.93497,7.6585 0,0 -0.0514,0.11253 -0.21863,0.45976 -1.21857,2.58176 -7.671344,15.65497 -15.82781,27.26779 -4.034983,5.79695 -8.55591,11.19223 -12.403804,14.51994 -1.90658,1.66863 -3.613811,2.80357 -4.742335,3.34376 -0.482275,0.23792 -0.852051,0.37295 -1.086711,0.44369 -0.530499,-0.4244 -1.774723,-1.6269 -3.334129,-4.3308 -2.048067,-3.50451 -4.481912,-9.35923 -6.697147,-17.72171 -0.160755,-0.60446 -0.363315,-1.18318 -0.594806,-1.75226 l -27.039793,16.63855 c 3.211901,10.11811 6.986542,18.12667 12.040823,24.61829 3.092967,3.92568 6.790403,7.30804 11.175768,9.70986 4.317955,2.38562 9.295031,3.64279 14.008805,3.64279 0.05144,0 0.102885,-0.003 0.154327,-0.003 5.980164,-0.007 11.281945,-1.76509 15.760318,-4.08971 7.362692,-3.88716 13.101775,-9.28516 18.297054,-15.10762 V 575.2589 Z',
            $this->frameId()
        );
    }

    public function symbolViewBox()
    {
        return '0 0 700 700';
    }

    protected function renderStyles()
    {
        return sprintf('.foreground-0 {
            transform: translate(11%%, -31.3%%) scale(3.25);
        }

        #%2$s path {
            transform: scale(1);
        }
        
        #%3$s {
            fill: none;
            stroke: %4$s;
        }

        .foreground-1 {
            mask: url(#%s);
        }', $this->maskId(), $this->symbolId(), $this->frameId(), $this->qrcode->design->frameColor);
    }

    protected function frameStrokeWidth()
    {
        return 6;
    }

    protected function modifiedViewBox()
    {
        return sprintf(
            '%1$s %1$s %2$s %2$s',
            $this->output->size * -2,
            $this->output->size * 6
        );
    }
}
