<?php

namespace App\Support\QRCodeProcessors\ShapeProcessors;


class BootShapeProcessor extends BaseShapeProcessor
{
    public static $shapeId = 'boot';

    public function symbolPath()
    {
        return 'm 324.78711,2.0488281 c -11.47664,0.065105 -23.04033,1.4111298 -33.98223,4.955862 -11.43446,3.4693139 -22.59293,7.7731029 -33.70906,12.1377709 -4.54918,1.853851 -9.11562,3.747689 -13.33803,6.275418 -3.48753,2.442535 -5.68419,6.576075 -5.86717,10.818449 -3.15331,-1.768946 -6.97675,-2.185796 -10.45973,-1.250403 -5.22885,1.224615 -9.80386,4.173439 -14.40071,6.82188 -10.71767,6.465636 -20.80927,13.896493 -30.85128,21.350003 -13.96172,10.490052 -27.54854,21.506687 -40.36208,33.379667 -14.70332,13.826455 -28.31779,28.816495 -40.64838,44.795395 -13.121714,17.12019 -24.504656,35.54483 -34.235018,54.78838 -9.171646,18.00171 -16.95405,36.66715 -24.356528,55.45296 -2.739052,6.89538 -5.575866,13.75641 -8.1497,20.71428 -1.032302,3.72534 0.256482,7.5232 1.335297,11.07896 3.797492,12.78278 7.177542,25.70278 11.652879,38.27287 1.480295,3.56846 4.65111,6.45227 8.430333,7.36749 -2.486689,6.45417 -3.855119,13.53283 -2.637262,20.42151 0.771775,4.87138 2.016766,9.65206 2.846271,14.51366 4.736644,24.60594 8.520195,49.33709 12.200564,74.12224 4.610894,31.37561 8.765195,62.83511 12.492026,94.31521 3.530823,30.25099 6.400633,60.54949 9.039947,90.88751 2.669393,31.38527 4.741081,62.83684 5.843325,94.31575 1.590276,43.59155 1.902563,87.21479 2.587886,130.82635 0.232851,16.09933 0.42839,32.1994 0.765915,48.29699 -3.419122,-0.80075 -7.126963,0.0362 -9.915891,2.15747 -3.437496,2.52746 -5.541274,6.33662 -7.914907,9.78591 -5.579179,8.55588 -10.379167,17.57705 -15.497327,26.39842 -10.125495,-0.91326 -20.180301,-1.70327 -30.240545,-3.30426 -2.881727,-0.36885 -5.634285,-1.27663 -8.528986,-1.52191 -5.505496,-0.43517 -11.25842,2.95248 -13.068463,8.26026 -1.688338,4.59837 -0.390119,9.85948 2.511814,13.67762 3.947895,5.81668 8.855706,10.88135 13.399948,16.22045 3.764363,4.29419 7.560193,8.56066 11.346154,12.83581 -5.833896,11.89394 -12.044319,23.6334 -16.931641,35.9629 -1.24843,3.2462 -2.051815,6.9119 -0.876953,10.3027 1.47442,4.7097 5.996451,8.4346 11.007216,8.4814 4.16614,0.1255 7.924183,-1.9308 11.711669,-3.3669 10.440062,-4.226 20.702281,-8.8715 31.023303,-13.3762 6.273714,5.0112 12.387081,10.1241 18.076172,15.8086 3.695464,3.5946 7.167372,7.5078 11.502742,10.3593 2.91345,1.9239 6.46467,3.1869 9.98463,2.5621 0.58742,-0.089 1.16887,-0.2178 1.73919,-0.3843 -0.1101,0.3922 0.41095,1.5751 -0.34581,1.1911 -3.87685,-0.9871 -8.20778,-0.236 -11.36289,2.278 -3.40309,2.6101 -5.31197,6.9452 -5.07051,11.214 0.13842,4.5949 1.90056,8.9167 3.42074,13.1908 3.93275,10.4659 8.48081,20.6848 12.85854,30.9687 5.83708,13.5659 11.68999,27.1264 17.59368,40.6633 2.0775,4.6155 7.17018,7.4174 12.14998,7.2866 15.26687,1.1953 30.54071,2.5467 45.86344,2.732 42.7479,1.0433 85.50878,0.2165 128.25954,-0.1596 3.42265,-0.1092 6.88576,0.1731 10.27364,-0.4267 5.10613,-1.1142 9.22864,-5.8486 9.40942,-11.1074 2.16811,-17.5724 4.23728,-35.1573 6.56351,-52.7097 6.22031,-0.2632 12.46154,-0.516 18.71094,-0.3066 16.48637,0.6988 33.04294,2.4562 49.47235,4.4244 18.53722,2.2657 37.07284,4.9774 55.45863,8.3452 13.97526,2.5482 27.81805,5.7066 41.26987,10.4123 13.47559,4.7154 26.41368,10.6591 39.23999,16.9192 16.02799,7.6824 32.01814,15.4892 48.5002,22.1633 9.41556,3.5404 19.48528,4.8596 29.46415,5.5962 13.86438,0.9482 27.88823,0.6224 41.5756,-1.9233 11.3573,-2.2658 22.20585,-6.4632 32.89718,-10.82 23.87408,-9.9501 46.79389,-22.0249 69.30542,-34.7198 20.99472,-11.9149 41.55677,-24.6009 61.54417,-38.1385 23.43963,-16.264 45.02615,-35.1005 64.99248,-55.452 11.06521,-11.4114 21.6166,-23.39282 30.67225,-36.47907 4.50475,-6.62884 8.62916,-13.66353 10.91304,-21.39376 1.34494,-4.7067 1.5537,-9.92031 -0.44986,-14.47718 -2.57905,-6.27869 -7.29495,-11.32334 -12.04763,-16.03439 -1.73149,-1.65369 -3.36125,-3.42881 -5.2219,-4.93827 -3.65727,-2.70913 -8.92247,-3.30869 -12.90866,-0.95549 -2.25507,1.24438 -3.98896,3.20298 -5.60111,5.17034 -2.12549,-5.21848 -6.16216,-9.39845 -10.52348,-12.84427 -7.87752,-6.06168 -17.5543,-9.27437 -27.25191,-10.96042 -15.34243,-2.64494 -31.19944,-1.58942 -46.25799,2.20084 -8.33657,2.09695 -16.30046,5.37498 -24.38913,8.23464 -6.19441,2.23244 -12.34773,4.39605 -18.69131,6.27516 -3.23495,0.94143 -6.50241,1.78492 -9.81782,2.39288 -0.63297,0.10749 -1.49208,0.26071 -2.11133,0.34961 -3.22867,0.49068 -6.53301,0.71781 -9.72156,0.84623 -9.92472,0.3301 -19.85371,-0.0962 -29.77524,-0.35322 -13.10402,-0.3979 -26.2093,-0.84169 -39.29031,-1.97544 -7.92701,-0.7171 -16.00938,-1.60681 -23.85369,-3.3099 -6.53847,-1.43633 -12.97317,-3.24063 -19.48076,-4.80271 -0.91782,-0.2209 -1.83572,-0.44198 -2.75539,-0.65496 1.76259,-4.1485 1.30284,-9.25071 -1.53633,-12.81797 -2.36133,-3.0864 -6.02537,-4.76859 -9.65432,-5.87029 -9.13888,-2.96411 -18.78841,-3.75842 -28.04568,-6.2512 -0.8718,-0.23446 -1.90944,-0.50828 -2.81447,-0.77135 -8.12039,-2.33703 -16.31492,-5.00889 -23.38279,-9.7638 -3.2855,-2.30865 -4.93314,-6.10625 -6.65113,-9.59072 -3.9985,-8.41058 -6.95749,-17.33548 -9.60473,-26.20811 -2.53908,-8.64255 -4.71715,-17.43169 -6.65264,-26.14809 -4.42285,-20.06116 -7.63312,-40.29888 -9.9837,-60.69288 -1.71746,-14.95475 -2.86272,-29.97349 -3.46019,-45.01464 -0.62201,-14.06994 -0.96064,-28.16778 -2.37613,-42.18736 -0.44196,-3.4247 -1.97186,-6.85453 -4.83797,-8.9151 -0.51724,-0.39604 -1.06765,-0.74922 -1.6425,-1.0556 0.81157,-2.55722 1.01279,-5.21916 1.39525,-7.82068 1.47206,-11.94863 2.03057,-23.98329 2.85088,-35.98794 0.59517,-9.28808 1.34619,-18.50485 2.26722,-27.76149 3.77063,-39.63602 9.5969,-78.94666 16.34508,-118.18957 6.76463,-39.04539 14.63143,-77.92478 23.51876,-116.55312 4.74949,-20.69574 9.89926,-41.3396 14.8757,-62.00033 0.57164,-2.51309 1.23958,-5.01399 1.69126,-7.54859 0.2785,-3.44798 -1.00399,-6.90165 -3.13946,-9.57969 4.75444,-1.6188 8.34878,-5.74284 9.94922,-10.42969 2.14075,-6.03395 1.86812,-12.58256 1.17232,-18.84945 -1.70113,-14.35891 -6.54353,-28.15051 -12.51995,-41.24842 -7.84762,-17.1107 -17.82293,-33.16699 -28.73615,-48.4758 C 543.48958,131.54452 523.31068,109.47697 501.56267,89.188253 485.3133,73.934181 468.13871,59.605821 449.65389,47.124947 439.11832,39.973691 428.14257,33.485264 416.8838,27.541323 c -7.52696,-4.036151 -15.07936,-8.036697 -22.79524,-11.701652 -4.63339,-2.114076 -9.58374,-4.134288 -14.77606,-3.859202 -2.16416,0.131216 -4.32022,0.664874 -6.24023,1.685547 -1.56583,-2.307844 -3.93705,-3.9239792 -6.45684,-5.0360097 C 362.77208,6.5514405 358.76029,4.5585062 354.37118,4.0052299 344.6228,2.2172744 334.66953,2.0399914 324.78711,2.0488281 Z M 163.99805,965.93359 c 0.88834,0.11538 0.82135,0.28019 -0.0524,0.44405 -0.66494,0.27782 -1.1694,0.38448 -0.85966,-0.50459 -0.0714,-0.33963 0.73143,0.0961 0.91211,0.0605 z m -42.77539,39.50591 c 0.6792,0.1416 0.87678,1.0745 0.21161,1.3921 -0.52307,0.353 -0.95782,-0.6234 -0.79755,-1.0679 0.0775,-0.2344 0.33725,-0.4226 0.58594,-0.3242 z';
    }

    protected function frameNode()
    {
        return $this->makeSinglePathUsedSymbol(
            'symbol-frame-' . $this::$shapeId,
            $this->symbolViewBox(),
            'm 283.30202,857.72566 c -1.90383,0.016 -3.67715,0.8122 -5.45146,1.4107 -3.61288,1.3071 -6.84764,3.5162 -9.54927,6.2313 -2.7338,2.6376 -5.17751,5.7561 -6.20865,9.4724 -0.57797,1.828 -0.81655,3.7439 -0.7571,5.6581 -0.045,4.0782 0.0663,8.2954 1.71783,12.0966 0.92838,2.1016 1.93565,4.2502 3.56115,5.9107 0.31369,0.3728 0.8247,0.5183 1.14161,0.8544 1.2481,2.6483 3.59096,4.5659 5.99812,6.1269 3.02007,1.9016 6.4632,3.4011 10.09408,3.362 2.82059,0.032 5.73281,-0.034 8.37606,-1.1367 4.43871,-1.7718 8.33364,-5.0506 10.60874,-9.277 1.11904,-2.0525 1.67703,-4.3972 1.54296,-6.7349 -0.0578,-0.6432 0.0458,-1.3281 -0.11826,-1.9455 -0.26998,-0.3729 -0.28083,-1.0611 -0.84396,-1.077 -0.44818,-0.1197 -0.91761,-0.3667 -1.27302,0.069 -0.42072,0.2202 -0.75731,0.5238 -0.87172,1.0014 -0.91614,2.215 -1.94198,4.4544 -3.68022,6.1572 -3.45112,3.5814 -8.49584,5.3126 -13.40506,5.3349 -2.78507,0.01 -5.64798,-0.1339 -8.27955,-1.1247 -2.72696,-1.0271 -4.74064,-3.3739 -5.9014,-5.9871 -1.61439,-3.3695 -2.06748,-7.243 -1.38228,-10.908 1.06016,-5.8944 4.7292,-11.4516 10.1433,-14.1767 2.47774,-1.2995 5.39787,-1.7335 8.13364,-1.1104 2.72193,0.5969 5.29827,1.7649 7.68229,3.1897 2.53665,1.5307 4.22409,4.0637 5.54758,6.6479 0.93442,1.6965 1.61403,3.6214 3.06507,4.9628 0.83892,0.7674 2.32455,0.4796 2.77934,-0.5726 0.6122,-1.4446 0.42449,-3.0756 0.28614,-4.5978 -0.29808,-2.7772 -1.58221,-5.3274 -2.97042,-7.7076 -2.29553,-3.558 -5.3791,-6.6203 -8.9594,-8.8821 -2.33853,-1.4852 -5.05765,-2.1719 -7.69467,-2.9193 -1.08545,-0.2966 -2.21131,-0.3592 -3.33147,-0.3288 z m -80.11524,31.2085 c -5.60839,0.08 -11.24406,2.4762 -14.86764,6.8181 -3.20109,3.742 -4.65471,8.8123 -4.21626,13.6912 0.23571,2.6062 0.49415,5.2618 1.42103,7.7279 1.12112,2.7136 3.34143,4.7389 5.30074,6.8487 2.06224,2.0885 4.11858,4.2105 6.46028,5.9898 1.19469,0.8215 2.72596,0.7449 4.11052,0.8703 2.38713,0.077 4.80231,0.07 7.15977,-0.3518 2.77945,-0.5335 4.96005,-2.5651 6.74265,-4.6427 1.92003,-2.3283 3.64182,-4.9179 4.50869,-7.8342 0.29467,-1.3786 0.64122,-2.9579 -0.0937,-4.258 -0.61031,-1.0306 -2.12972,-1.1235 -2.96792,-0.3249 -1.07496,0.9336 -1.63677,2.2973 -2.62015,3.3182 -3.23529,3.7932 -8.19279,6.1134 -13.20133,5.907 -2.28292,-0.017 -4.57475,-0.8383 -6.2182,-2.45 -2.89913,-2.6245 -4.27089,-6.7075 -3.77498,-10.5608 0.44441,-3.717 2.48062,-7.2887 5.60906,-9.3845 2.77773,-1.8045 6.28062,-2.0108 9.47315,-1.5103 3.06967,0.4965 5.73083,2.3364 7.84576,4.5411 1.3858,1.42 2.65281,2.9731 4.03848,4.3789 0.42357,0.091 0.85424,0.5756 1.27244,0.3669 0.36101,-0.2483 1.00649,-0.2571 1.01886,-0.7988 0.17126,-0.4933 0.30397,-0.9889 0.12976,-1.5026 -0.3263,-2.3201 -0.71061,-4.6653 -1.71104,-6.8061 -1.813,-4.0577 -5.04503,-7.6664 -9.2804,-9.2271 -1.95457,-0.6994 -4.08104,-0.8163 -6.13955,-0.8063 z m 102.60206,-647.2207 c -1.02973,0.027 -1.93543,0.5465 -2.79889,1.0471 -2.55248,1.078 -5.36129,1.3935 -7.86776,2.6009 -4.37745,1.9679 -7.94604,5.3033 -11.22301,8.7361 -2.75068,2.999 -5.32768,6.3209 -6.64257,10.2199 -0.76767,3.0274 -0.86334,6.1754 -0.96727,9.2824 -0.0563,4.6469 0.053,9.3976 1.49483,13.858 1.42147,4.3096 4.58223,7.7132 7.68294,10.9019 3.87949,3.9265 8.24304,7.6548 13.55453,9.4407 3.65925,1.2805 7.62788,1.2369 11.43644,0.8281 2.75741,-0.3605 5.5492,-0.897 8.06757,-2.1177 2.64504,-1.604 4.8373,-3.8353 6.96534,-6.0542 2.63859,-2.8155 5.00693,-5.9381 6.55434,-9.4943 3.16863,-7.0386 3.61075,-15.0532 2.27718,-22.5859 -0.70128,-3.9064 -1.66609,-7.9008 -4.0058,-11.1842 -1.95469,-2.7925 -4.39066,-5.204 -6.80584,-7.5938 -2.18924,-2.1413 -4.73004,-4.0293 -7.70309,-4.9031 -2.3109,-0.7326 -4.76085,-1.0632 -6.96914,-2.0971 -0.88717,-0.611 -1.96818,-0.9571 -3.0498,-0.8848 z m -1.56299,14.0303 c 4.18755,-3e-4 8.57256,0.1197 12.38017,2.0748 2.78843,1.4316 5.16005,3.5584 7.27866,5.8423 2.13672,2.3803 3.24239,5.431 4.64439,8.2548 -0.0336,3.4434 0.077,6.8913 -0.0945,10.3315 -0.13588,2.5718 -1.57452,4.8471 -3.17994,6.7725 -2.39517,2.8156 -5.11524,5.41 -8.2709,7.3589 -1.92935,1.0515 -3.97851,1.9511 -6.13725,2.3982 -0.72066,0.1355 -1.59013,0.2283 -2.22603,0.2997 -2.01756,0.2004 -4.07748,0.3013 -6.04252,0.324 -1.32374,-0.039 -2.69463,0.079 -3.97704,-0.2965 -2.47526,-0.9669 -4.8824,-2.1772 -7.01861,-3.7666 -0.88905,-0.7368 -1.3102,-1.8692 -1.88289,-2.8442 -1.54228,-3.0616 -2.96986,-6.2062 -3.92613,-9.5048 -0.58422,-2.7057 -0.37431,-5.5154 -0.01,-8.2371 0.49929,-3.8398 1.99507,-7.5325 4.30558,-10.6387 2.30587,-3.1651 5.40945,-5.7603 9.00378,-7.3375 1.27562,-0.6761 2.69729,-1.0566 4.14583,-1.017 0.33565,0 0.6713,-0.01 1.00696,-0.014 z m 310.32048,903.49694 c -5.57595,-1.416 -27.97449,-11.5303 -49.77454,-22.4763 -32.17395,-16.1547 -43.70322,-20.9547 -61.23673,-25.4944 -38.3986,-9.942 -85.84968,-16.8979 -136.27923,-19.9772 l -20.7647,-1.268 -2.36698,27.8579 c -1.30183,15.3219 -2.84004,30.2233 -3.41821,33.1143 l -1.05124,5.2561 h -99.83729 -99.83727 l -10.08882,-23.9482 c -5.54885,-13.1714 -11.54835,-27.329 -13.33224,-31.4612 -1.78387,-4.1323 -8.42589,-19.7689 -14.76003,-34.7483 -14.069591,-33.2725 -18.434811,-42.107 -22.723181,-45.9879 -3.07084,-2.7791 -5.40861,-1.9619 -31.9347,11.1641 -28.53332,14.1191 -35.71676,16.4531 -35.71676,11.6048 0,-2.6582 8.53092,-19.766 22.43421,-44.98944 l 8.0902,-14.6772 -5.40121,-5.9663 c -2.97066,-3.2815 -13.21957,-14.1694 -22.77534,-24.1955 -18.3733601,-19.2776 -21.54584,-25.9457 -12.3441801,-25.9457 2.76647,0 18.1322801,2.2589 34.1462201,5.0197 l 29.11627,5.0198 2.94991,-4.3566 c 1.62245,-2.3963 8.63987,-15.1657 15.59427,-28.3766 11.53095,-21.9047 12.81142,-25.4778 14.5413,-40.5766 4.043331,-35.2912 1.38006,-140.5194 -5.60072,-221.2899 -14.57128,-168.5954 -33.367,-291.7925 -53.57345,-351.1491 -4.06473,-11.9402 -3.00268,-19.2771 6.48708,-44.8142 23.18471,-62.3902 54.59903,-112.2203 96.225741,-152.635402 22.05277,-21.4109 44.99497,-37.3076 83.29504,-57.7153 50.79752,-27.0669 72.66305,-34.1453996 105.18396,-34.0513996 17.99721,0.052 23.03252,0.8285 39.05348,6.0226 25.13066,8.1475996 44.03868,16.5710996 65.30902,29.0949996 49.87181,29.3644 95.33577,71.520402 127.69541,118.404302 20.81577,30.1587 41.23254,77.2094 41.23254,95.0209 0,3.5121 -2.60642,14.5028 -5.79205,24.4237 -23.86068,74.3084 -51.57109,218.9804 -60.65771,316.6852 -5.6409,60.6544 -5.72327,65.3746 -1.21215,69.4571 3.75235,3.3958 3.92342,4.7901 2.75971,22.491 -2.83578,43.1344 13.71069,151.9627 27.45741,180.5908 4.52548,9.4245 15.72881,21.046 23.4733,24.3494 3.16277,1.3491 15.3731,3.795 27.13408,5.4353 23.90365,3.334 27.6631,5.4129 28.52778,15.7754 0.56835,6.8119 0.6333,6.8597 13.719,10.0777 23.556,5.7929 50.7036,8.976 76.3116,8.9477 28.83457,-0.032 41.97945,-2.5533 64.16655,-12.3085 37.4766,-16.4774 70.25246,-15.8921 98.86016,1.7655 6.548,4.0416 13.43884,6.8142 16.93603,6.8142 9.2932,0 19.7918,6.3858 23.7784,14.463 10.4734,21.221 -0.3639,42.9624 -42.44893,85.15914 -19.7221,19.7743 -33.454,31.613 -49.7753,42.9123 -50.26726,34.8006 -121.29354,73.0589 -158.93589,85.6108 -18.49245,6.1664 -24.16942,7.2179 -42.04057,7.7875 -13.4103,0.4273 -24.21903,-0.245 -30.79925,-1.916 z m 63.9287,-13.1778 c 44.4957,-12.9057 132.09577,-62.2924 182.89741,-103.113 20.5381,-16.503 48.90884,-46.44724 60.67723,-64.04254 8.1416,-12.1727 9.7344,-15.9421 9.7344,-23.0369 0,-7.1798 -1.0033,-9.486 -6.532,-15.0147 -3.5926,-3.5926 -7.9701,-6.255 -9.7277,-5.9166 -1.7577,0.3385 -6.92429,6.1095 -11.48133,12.8243 -10.253,15.1077 -17.3973,22.6592 -38.9382,41.1577 -59.53594,51.12744 -134.44496,93.38244 -190.39511,107.39934 -13.3695,3.3493 -19.7616,3.8674 -38.65665,3.1334 -26.21421,-1.0184 -52.37799,-6.6269 -171.962,-36.8624 -85.74694,-21.6803 -124.99737,-30.0917 -170.92393,-36.6294 -62.67525,-8.9218 -98.09926,-12.1961 -139.93223,-12.9339 l -26.29599,-0.4639 -0.50797,6.574 c -0.27938,3.6157 0.63894,14.181 2.04072,23.4786 1.40178,9.2975 2.17386,17.961 1.71573,19.2524 -1.45584,4.1035 -7.58945,2.5442 -14.7767,-3.7566 l -6.96323,-6.1044 1.25596,6.3039 c 0.69078,3.4672 4.48726,13.6099 8.43664,22.5394 3.94938,8.9295 8.25147,18.7712 9.56019,21.8704 1.30873,3.0992 5.97283,14.0871 10.36467,24.4177 l 7.98515,18.7828 92.13334,0.4872 92.13336,0.4872 1.03493,-4.2438 c 0.56922,-2.334 1.95282,-14.8091 3.07464,-27.7223 2.56255,-29.4969 3.32635,-33.2179 7.11709,-34.6726 7.61085,-2.9205 100.85954,7.2747 137.72126,15.0576 34.02472,7.1838 53.70839,14.39 88.13203,32.2647 40.49307,21.0263 46.21173,22.8106 73.51259,22.9368 17.77687,0.082 24.7932,-0.7499 37.5657,-4.4544 z m 0.67965,-61.1699 c 45.49342,-12.7806 96.55815,-40.4131 151.57545,-82.0217 20.45201,-15.46754 60.81941,-53.62954 65.82311,-62.22704 l 3.2741,-5.6256 -6.6524,-6.4614 c -17.0802,-16.5899 -55.89086,-18.4177 -87.56036,-4.1237 -25.65068,11.5775 -40.2264,14.5399 -71.98965,14.6313 -29.8128,0.086 -43.6137,-1.6066 -77.0133,-9.4438 l -20.66475,-4.8491 -9.63656,5.6819 c -28.14909,16.5973 -67.68973,30.4395 -90.96816,31.8456 -13.67686,0.8261 -18.60514,0.2349 -32.86998,-3.9432 -17.34984,-5.0816 -42.68574,-10.5403 -92.83634,-20.002 l -29.09839,-5.4898 -49.4596,9.4121 c -56.1049,10.6766 -150.28939,30.1373 -167.73452,34.6578 -16.86364,4.3698 -41.10011,16.9445 -41.10011,21.324 0,3.24264 2.62126,3.59134 36.15698,4.81024 60.73684,2.2075 136.58745,11.1391 193.93292,22.8362 17.56197,3.5823 74.19226,17.0694 125.84509,29.9714 127.18239,31.768 141.42368,34.6699 166.22822,33.8724 13.0299,-0.419 24.82072,-2.0666 34.74825,-4.8556 z m -561.66054,-50.2588 c -3.98043,-22.8801 -6.37607,-42.38454 -5.39991,-43.96404 0.64442,-1.0427 10.28566,-6.3688 21.42499,-11.8358 24.87327,-12.2074 25.10567,-12.3505 23.16636,-14.2619 -0.86481,-0.8525 -11.66293,-3.2708 -23.99583,-5.374 -12.3329,-2.1033 -23.50054,-4.9027 -24.81699,-6.2209 -1.31643,-1.3182 -3.90444,-12.8917 -5.7511,-25.7189 -1.84667,-12.8272 -4.202671,-23.5904 -5.235561,-23.9183 -1.0329,-0.328 -6.52676,8.3106 -12.20857,19.1967 -5.68181,10.8861 -11.70655,21.0531 -13.3883,22.5933 -2.71457,2.486 -5.58375,2.3693 -25.56552,-1.0399 -12.37928,-2.1121 -23.0478,-3.8402 -23.70783,-3.8402 -3.67073,0 0.48982,5.8218 14.76537,20.6611 8.78099,9.1278 15.96543,17.7414 15.96543,19.1414 0,1.4 -4.58661,11.2633 -10.19247,21.91844 -12.45175,23.6672 -12.85185,24.6803 -9.74762,24.6803 1.36479,0 11.44085,-4.2262 22.39125,-9.3915 10.95039,-5.1653 21.44778,-9.3914 23.32751,-9.3914 1.87973,0 10.56481,7.1844 19.30018,15.9654 16.913621,17.002 21.152451,19.3295 19.668611,10.8002 z m 95.1131,-78.13264 c 14.86584,-3.4584 58.55645,-12.4836 97.09028,-20.0559 l 70.06149,-13.7678 33.24418,6.1827 c 43.95029,8.1737 86.96698,17.8138 100.63766,22.5531 12.56422,4.3557 17.45795,4.0312 43.74345,-2.9004 20.5104,-5.4085 38.85614,-12.6693 55.27596,-21.8768 13.81479,-7.7466 23.84649,-17.1734 20.48567,-19.2505 -1.19738,-0.74 -10.50404,-2.4337 -20.68148,-3.7638 -20.01786,-2.616 -36.77727,-8.9812 -45.42409,-17.2522 -18.41688,-17.6163 -41.15411,-132.833 -38.79427,-196.5828 0.70962,-19.1702 0.57889,-20.0099 -3.11521,-20.0099 -7.74022,0 -61.16824,31.2903 -85.45751,50.0485 -1.54958,1.1967 -28.59688,22.792 -60.10512,47.9895 -88.33247,70.6405 -82.96437,67.0913 -118.79237,78.5396 -69.37053,22.1661 -143.08289,51.0492 -149.25046,58.4817 -1.77466,2.1387 -1.66041,6.7581 0.5273,21.321 1.53603,10.2249 3.06605,18.864 3.40003,19.198 0.33398,0.334 14.88819,3.1478 32.3427,6.2531 20.70826,3.684 32.38478,6.6074 33.60415,8.4134 2.36688,3.5055 -0.27287,3.8032 31.20764,-3.5205 z m -74.25565,-71.9157 c 32.75676,-16.497 68.3581,-30.8125 113.27935,-45.5502 29.96348,-9.8304 36.05428,-12.5117 46.01798,-20.2579 10.53511,-8.1904 74.58399,-59.0782 92.2499,-73.2939 44.84821,-36.0891 83.66858,-62.5628 111.9409,-76.3385 l 19.90494,-9.6987 1.3197,-23.4786 c 4.959,-88.2236 24.0669,-206.2503 50.16759,-309.8777 l 11.1076,-44.1004 -30.6812,-31.031 c -16.87464,-17.067 -39.17963,-40.7511 -49.56665,-52.6313 -28.37887,-32.4584 -61.96048,-65.8114 -78.933,-78.3958 -15.91555,-11.8007 -46.4025,-28.480402 -48.40175,-26.481202 -0.64542,0.6454 -1.97939,17.956302 -2.96439,38.468602 -1.7993,37.47 -7.50688,113.1082 -11.17652,148.1138 -5.09155,48.5693 -11.29088,100.3604 -12.34045,103.0955 -2.2687,5.9122 -8.02108,2.8 -29.12087,-15.7552 -11.74728,-10.3306 -22.38716,-18.7829 -23.64421,-18.7829 -1.25702,0 -8.03121,5.1237 -15.05372,11.386 -15.96123,14.2333 -34.08696,26.5161 -37.98168,25.7381 -3.72926,-0.745 -3.57261,-5.8556 0.96508,-31.4892 3.02996,-17.1163 3.4734,-29.5244 3.35634,-93.9143 -0.0926,-50.969 -1.12888,-87.1001 -3.31044,-115.4294 -1.74654,-22.6805 -3.56427,-41.6259 -4.03938,-42.101 -2.50788,-2.5079 -30.60186,20.7042 -53.14579,43.9106 -31.62882,32.5584 -61.46732,74.2524 -92.066071,128.6461 -2.61512,4.6488 -8.8557,15.6367 -13.86795,24.4177 -5.01226,8.781 -11.65962,21.1749 -14.77192,27.5421 l -5.65873,11.5766 5.60952,28.8065 c 26.63863,136.797 47.355241,379.5465 41.342381,484.4343 -2.17274,37.9011 -1.81814,48.0902 1.61678,46.4562 0.77424,-0.3684 13.30524,-6.6616 27.84666,-13.9849 z M 348.3608,319.47706 c 11.49174,-106.874 14.40741,-148.693 15.60328,-223.794202 0.59463,-37.3431 0.51521,-70.1514 -0.17656,-72.9073 -1.9569,-7.797 -11.71974,-10.9395 -33.99389,-10.942 -13.81627,0 -22.75612,1.1195 -33.80913,4.2396 -21.2665,6.0034 -47.40932,16.7439 -48.65466,19.9892 -0.57998,1.5114 0.16679,14.7617 1.65933,29.4451 7.70856,75.832102 9.33359,109.283702 9.37204,192.925402 0.0267,58.0645 -0.66128,87.2775 -2.25338,95.6824 -1.26049,6.6544 -1.91649,12.4742 -1.45775,12.9329 1.41029,1.4103 8.72976,-4.2198 24.91306,-19.163 8.53021,-7.8765 16.22962,-14.3209 17.10979,-14.3209 1.84447,0 10.89276,7.2062 30.32262,24.1495 10.14443,8.8461 14.05911,11.28 15.10554,9.3914 0.77688,-1.4021 3.5937,-22.8347 6.25963,-47.6281 z M 68.860889,303.98126 C 127.66922,195.44866 174.89173,133.25056 222.4303,101.71066 c 9.13188,-6.058702 17.03797,-12.148202 17.56912,-13.532302 1.3676,-3.5639 -2.59797,-42.1602 -4.5303,-44.0925 -2.12826,-2.1283 -15.57003,5.0611 -41.85108,22.3842 -22.69756,14.961 -59.4045,48.739202 -76.95342,70.813402 -28.981041,36.4543 -52.274971,80.3333 -67.670151,127.4708 l -4.21168,12.8955 5.14761,17.1571 c 5.94132,19.8026 8.02548,25.6094 9.19167,25.6094 0.45844,0 4.84091,-7.3958 9.73882,-16.435 z m 523.052871,-44.964 c 2.13857,-7.6383 2.03731,-10.4405 -0.76315,-21.1179 -16.40855,-62.5612 -80.29784,-139.651002 -156.17295,-188.440702 -21.39944,-13.7604 -50.40954,-27.6897 -57.66823,-27.6897 -3.53172,0 -3.63084,1.0295 -2.48646,25.8264 0.65555,14.2045 1.59799,27.7803 2.09431,30.1683 0.68764,3.3087 4.66282,6.0711 16.70387,11.6078 36.49985,16.783202 68.49632,43.979202 117.13931,99.564802 28.71937,32.8184 73.4577,78.888 76.60833,78.888 1.14354,0 3.18877,-3.9631 4.54497,-8.807 z',
            $this->frameId()
        );
    }

    public function symbolViewBox()
    {
        return sprintf('0 0 %s %s', $this->svgWidth(), $this->svgHeight());
    }

    private function svgWidth()
    {
        return '948.83423';
    }

    private function svgHeight()
    {
        return '1162.0956';
    }

    protected function renderStyles()
    {
        return sprintf('.foreground-0 {
            transform: translate(-8%%, 2%%) scale(1.4);
        }

        #%2$s path {
        }

        #%3$s {
            fill: %4$s;
        }

        .foreground-1 {
            mask: url(#%s);
        }', $this->maskId(), $this->symbolId(), $this->frameId(), $this->qrcode->design->frameColor);
    }

    protected function frameStrokeWidth()
    {
        return 3;
    }

    protected function modifiedViewBox()
    {
        return sprintf(
            '%1$s %1$s %2$s %2$s',
            $this->output->size * -2,
            $this->output->size * 6
        );
    }
}
