<?php

namespace App\Support\QRCodeProcessors\ShapeProcessors;

use SVG\Nodes\Shapes\SVGPath;
use SVG\Nodes\Structures\SVGSymbol;

class BagShapeProcessor extends BaseShapeProcessor
{
    public static $shapeId = 'bag';

    protected function frameNode()
    {
        $symbol = new SVGSymbol();

        $symbol->setAttribute('id', 'frame-node-' . $this::$shapeId);

        $symbol->setAttribute('viewBox', $this->symbolViewBox());

        $path = new SVGPath('m 616.2633,162.80115 c -0.53001,-6.10237 -3.30898,-11.78925 -7.79267,-15.96306 -4.48846,-4.16856 -10.36163,-6.5225 -16.48747,-6.60844 H 487.69946 C 481.60186,65.358861 427.37255,8.0292334 360.52302,8.0292334 341.504,8.1581578 322.80647,12.971317 306.08431,22.038933 c -6.1119,-1.055256 -12.29959,-1.62821 -18.50317,-1.709376 -62.5712,0 -114.7705,51.875367 -125.67291,119.898383 H 99.977557 c -6.197835,-0.0191 -12.180775,2.2872 -16.755166,6.46529 -4.579159,4.18287 -7.415448,9.93184 -7.950239,16.10609 L 28.954946,671.17504 c -0.381994,5.52455 1.53751,10.95839 5.309775,15.01205 3.767376,4.0539 9.048425,6.36493 14.587882,6.37936 H 643.11276 c 5.53885,-0.0143 10.82002,-2.32534 14.58789,-6.37936 3.77214,-4.0539 5.69164,-9.48775 5.30977,-15.01205 z m -74.23148,426.86741 -77.8644,67.59885 50.16526,-496.28638 h 27.70403 z m 10.69582,18.50317 73.26703,64.17496 H 479.13791 Z m 42.78331,-443.44289 45.56178,493.08375 -78.3998,-68.13303 V 160.99081 h 29.30901 c 1.95776,0.20054 3.49051,1.781 3.63854,3.74353 z M 360.20275,28.78794 c 55.40317,0 100.54078,48.131216 106.95828,111.45174 h -53.47914 v -0.005 C 407.2787,93.822242 378.7157,53.417684 337.10221,31.886678 c 7.63988,-2.043697 15.51323,-3.084554 23.42081,-3.098978 z m -50.27038,15.079282 c 41.07442,10.695827 73.48094,48.236341 82.35787,96.262438 H 254.30795 c 2.82199,-38.91081 23.31568,-74.384282 55.6183,-96.262438 z m -30.91278,-2.244168 h 0.005 c -26.77268,26.190713 -43.05601,61.257136 -45.78192,98.611856 h -50.37551 c 9.84114,-53.369124 48.6654,-94.123275 96.15732,-98.611856 z M 96.334864,164.72897 c 0.148018,-1.96254 1.680773,-3.54295 3.638537,-3.74354 h 59.576369 v 5.66781 5.66781 c -0.38677,12.27636 0.40109,24.56251 2.35406,36.69096 -10.38547,4.11123 -18.16824,12.95479 -20.93326,23.77408 -2.76943,10.82002 -0.18622,22.30844 6.94752,30.90299 7.12892,8.5948 17.94943,13.25549 29.09387,12.5294 11.14469,-0.72101 21.26697,-6.74216 27.22608,-16.18676 5.9591,-9.44484 7.03345,-21.17652 2.88885,-31.54841 -4.14461,-10.3719 -13.00735,-18.12546 -23.83153,-20.86603 -2.22986,-11.58878 -3.12758,-23.39269 -2.67396,-35.18622 v -5.7777 -5.66781 h 213.91655 v 5.66781 5.66781 c 0.45361,11.83227 -0.43929,23.67384 -2.67396,35.29623 -10.79129,2.74082 -19.61553,10.47617 -23.74107,20.81836 -4.12076,10.33767 -3.04641,22.0224 2.89839,31.43351 5.94003,9.41135 16.02907,15.4081 27.13562,16.1293 11.10642,0.72579 21.88794,-3.9154 28.99852,-12.48172 7.10986,-8.56143 9.69311,-20.01159 6.94276,-30.79298 -2.75036,-10.78653 -10.5,-19.60087 -20.84281,-23.71173 1.953,-12.16171 2.74082,-24.4855 2.34929,-36.79609 v -5.56281 -5.66781 h 78.29468 l -51.66023,510.8327 H 49.708392 Z m 78.509816,62.5712 c 5.72037,0 10.87246,3.45224 13.05502,8.74283 2.1773,5.28581 0.95021,11.36911 -3.10851,15.39954 -4.06344,4.0253 -10.1515,5.20942 -15.42277,2.98909 -5.27152,-2.22033 -8.68563,-7.40115 -8.6426,-13.12103 0,-3.73401 1.48984,-7.31521 4.1446,-9.94137 2.65012,-2.63093 6.24087,-4.09693 9.97487,-4.06821 z m 225.46804,0 c 5.72037,0 10.87723,3.45224 13.05502,8.74283 2.1773,5.28581 0.9502,11.36911 -3.10851,15.39954 -4.05867,4.0253 -10.15151,5.20942 -15.42278,2.98909 -5.27151,-2.22033 -8.68562,-7.40115 -8.64259,-13.12103 0.0621,-7.75454 6.36493,-14.0097 14.11971,-14.0097 z');

        $symbol->addChild($path);

        $this->doc->addChild($symbol);

        $node = $this->use($symbol, $this->getViewBoxStart(), $this->getViewBoxStart(), '100%', '100%');

        $node->setAttribute('id', $this->frameId());

        return $node;
    }

    public function symbolPath()
    {
        return 'm 168.29712,252.93629 c -3.78728,-2.12989 -7.07667,-7.66421 -7.06978,-11.89476 0.008,-5.10791 4.39036,-10.54979 9.80039,-12.17067 4.25883,-1.27598 5.65306,-1.19582 9.27947,0.53349 8.26253,3.94014 10.25364,15.47877 3.72879,21.60856 -3.73424,3.50812 -11.28102,4.43038 -15.73887,1.92338 z m 222.98564,-2.31874 c -6.93207,-6.93208 -5.37365,-16.56326 3.41553,-21.10832 7.06715,-3.65458 16.7741,1.22587 18.80656,9.45552 1.13968,4.61474 -2.18497,11.62269 -6.59613,13.90379 -6.12101,3.1653 -10.89779,2.47719 -15.62596,-2.25099 z m 90.35442,421.07024 c 0,-0.93615 70.04645,-61.49404 71.12927,-61.49404 0.59161,0 15.28222,12.42988 32.6458,27.62194 17.36358,15.19206 33.29702,29.11868 35.40766,30.94806 l 3.83751,3.32612 -71.51013,0.0499 c -39.33055,0.0274 -71.51011,-0.17595 -71.51011,-0.45197 z M 601.63914,622.51053 563.88917,589.6737 V 375.58224 161.49078 h 14.65923 c 8.98342,0 14.97003,0.50284 15.46191,1.29871 0.87819,1.42096 46.16716,488.07843 45.67921,490.85099 -0.17162,0.97515 -16.48381,-12.37025 -38.05038,-31.12995 z m -135.9613,29.23703 c 0,-1.80015 11.04878,-112.53547 24.55283,-246.07848 13.50406,-133.54301 24.55283,-243.11437 24.55283,-243.49189 0,-0.37753 6.07682,-0.68641 13.50406,-0.68641 h 13.50406 l -0.0818,213.91653 -0.0818,213.91653 -37.97513,32.84837 c -33.74224,29.18694 -37.97512,32.48354 -37.97512,29.57535 z M 50.752269,668.81364 c 0.05757,-7.16177 46.406821,-504.73589 47.12459,-505.89726 0.629813,-1.01906 9.384181,-1.4256 30.698711,-1.4256 h 29.81763 l 0.8022,20.563 c 0.44122,11.30964 1.14227,22.0822 1.55789,23.939 0.59391,2.65327 0.3098,3.37601 -1.32711,3.37601 -1.14553,0 -5.31335,3.23057 -9.26182,7.17905 -5.76684,5.76683 -7.58812,8.58624 -9.25868,14.33273 -5.28236,18.17073 3.86899,37.06412 21.06993,43.49982 27.65057,10.3454 54.89766,-14.86161 46.66727,-43.17315 -2.51298,-8.64437 -10.8123,-18.17356 -19.08373,-21.91179 -7.07339,-3.19676 -7.12072,-3.36979 -8.29334,-30.31078 l -0.76143,-17.49389 h 107.17445 107.17445 l -0.77967,16.26624 c -0.42882,8.94644 -1.13094,19.06126 -1.56026,22.47739 -0.75178,5.98198 -0.99751,6.31065 -6.66128,8.90895 -13.15862,6.03663 -20.17623,17.21685 -20.17623,32.14412 0,14.72821 7.29988,26.40909 20.2053,32.33145 8.38318,3.84708 21.98517,3.54093 30.07721,-0.67698 21.5617,-11.23882 26.32139,-39.26022 9.58641,-56.43741 -2.42568,-2.48977 -6.04681,-5.20471 -8.04695,-6.0332 -3.32781,-1.37842 -3.57119,-1.88015 -2.8659,-5.9081 0.42392,-2.42097 1.11913,-13.10266 1.54494,-23.73711 l 0.77419,-19.33535 h 37.86746 c 29.44679,0 37.87944,0.34124 37.92134,1.53455 0.0297,0.844 -11.43345,115.47422 -25.47356,254.73383 l -25.52745,253.19925 -195.50191,9.2e-4 c -185.381129,0.002 -195.501025,-0.10884 -195.484651,-2.146 z';
    }

    protected function renderStyles()
    {
        return sprintf('
            .foreground-0 {
                transform: scale(1.3) translate(-12%%, 8%%);
            }

            .foreground-1 {
                mask: url(#%s);
            }

            #%s {
                fill: %s;
            }
        ', $this->maskId(), $this->frameId(), $this->qrcode->design->frameColor);
    }

    public function symbolViewBox()
    {
        return '0 0 700 700';
    }

    protected function frameStrokeWidth()
    {
        return 2;
    }
}
